/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer.jogl;

import com.jogamp.opengl.GL3;
import de.javagl.jgltf.model.GltfConstants;
import de.javagl.jgltf.viewer.GlContext;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.util.logging.Logger;

class GlContextJogl
implements GlContext {
    private static final Logger logger = Logger.getLogger(GlContextJogl.class.getName());
    private GL3 gl;

    GlContextJogl() {
    }

    void setGL(GL3 gl) {
        this.gl = gl;
    }

    public Integer createGlProgram(String vertexShaderSource, String fragmentShaderSource) {
        if (vertexShaderSource == null) {
            logger.warning("The vertexShaderSource is null");
            return null;
        }
        if (fragmentShaderSource == null) {
            logger.warning("The fragmentShaderSource is null");
            return null;
        }
        logger.fine("Creating vertex shader...");
        Integer glVertexShader = this.createGlShader(35633, vertexShaderSource);
        if (glVertexShader == null) {
            logger.warning("Creating vertex shader FAILED");
            return null;
        }
        logger.fine("Creating vertex shader DONE");
        logger.fine("Creating fragment shader...");
        Integer glFragmentShader = this.createGlShader(35632, fragmentShaderSource);
        if (glFragmentShader == null) {
            logger.warning("Creating fragment shader FAILED");
            return null;
        }
        logger.fine("Creating fragment shader DONE");
        int glProgram = this.gl.glCreateProgram();
        this.gl.glAttachShader(glProgram, glVertexShader.intValue());
        this.gl.glDeleteShader(glVertexShader.intValue());
        this.gl.glAttachShader(glProgram, glFragmentShader.intValue());
        this.gl.glDeleteShader(glFragmentShader.intValue());
        this.gl.glLinkProgram(glProgram);
        this.gl.glValidateProgram(glProgram);
        int[] validateStatus = new int[]{0};
        this.gl.glGetProgramiv(glProgram, 35715, validateStatus, 0);
        if (validateStatus[0] != 1) {
            this.printProgramLogInfo(glProgram);
            return null;
        }
        return glProgram;
    }

    public void useGlProgram(int glProgram) {
        this.gl.glUseProgram(glProgram);
    }

    public void deleteGlProgram(int glProgram) {
        this.gl.glDeleteProgram(glProgram);
    }

    public void enable(Iterable<? extends Number> states) {
        if (states != null) {
            for (Number number : states) {
                if (number == null) continue;
                this.gl.glEnable(number.intValue());
            }
        }
    }

    public void disable(Iterable<? extends Number> states) {
        if (states != null) {
            for (Number number : states) {
                if (number == null) continue;
                this.gl.glDisable(number.intValue());
            }
        }
    }

    private Integer createGlShader(int shaderType, String shaderSource) {
        Integer glShader = this.createGlShaderImpl(shaderType, shaderSource);
        if (glShader != null) {
            return glShader;
        }
        if (!shaderSource.contains("#version")) {
            String versionString = "#version 120";
            logger.warning("Inserting GLSL version specifier \"" + versionString + "\" in shader code");
            String shaderSourceWithVersion = versionString + "\n" + shaderSource;
            return this.createGlShaderImpl(shaderType, shaderSourceWithVersion);
        }
        return null;
    }

    private Integer createGlShaderImpl(int shaderType, String shaderSource) {
        int glShader = this.gl.glCreateShader(shaderType);
        this.gl.glShaderSource(glShader, 1, new String[]{shaderSource}, null);
        this.gl.glCompileShader(glShader);
        int[] compileStatus = new int[]{0};
        this.gl.glGetShaderiv(glShader, 35713, compileStatus, 0);
        if (compileStatus[0] != 1) {
            this.printShaderLogInfo(glShader);
            return null;
        }
        return glShader;
    }

    public int getUniformLocation(int glProgram, String uniformName) {
        this.gl.glUseProgram(glProgram);
        return this.gl.glGetUniformLocation(glProgram, uniformName);
    }

    public int getAttributeLocation(int glProgram, String attributeName) {
        this.gl.glUseProgram(glProgram);
        return this.gl.glGetAttribLocation(glProgram, attributeName);
    }

    public void setUniformiv(int type, int location, int count, int[] value) {
        if (value == null) {
            logger.warning("Invalid uniform value: " + value);
            return;
        }
        switch (type) {
            case 5124: 
            case 5125: {
                this.gl.glUniform1iv(location, count, value, 0);
                break;
            }
            case 35667: {
                this.gl.glUniform2iv(location, count, value, 0);
                break;
            }
            case 35668: {
                this.gl.glUniform3iv(location, count, value, 0);
                break;
            }
            case 35669: {
                this.gl.glUniform4iv(location, count, value, 0);
                break;
            }
            default: {
                logger.warning("Invalid uniform type: " + GltfConstants.stringFor((int)type));
            }
        }
    }

    public void setUniformfv(int type, int location, int count, float[] value) {
        if (value == null) {
            logger.warning("Invalid uniform value: " + value);
            return;
        }
        switch (type) {
            case 5126: {
                this.gl.glUniform1fv(location, count, value, 0);
                break;
            }
            case 35664: {
                this.gl.glUniform2fv(location, count, value, 0);
                break;
            }
            case 35665: {
                this.gl.glUniform3fv(location, count, value, 0);
                break;
            }
            case 35666: {
                this.gl.glUniform4fv(location, count, value, 0);
                break;
            }
            default: {
                logger.warning("Invalid uniform type: " + GltfConstants.stringFor((int)type));
            }
        }
    }

    public void setUniformMatrixfv(int type, int location, int count, float[] value) {
        if (value == null) {
            logger.warning("Invalid uniform value: " + value);
            return;
        }
        switch (type) {
            case 35674: {
                this.gl.glUniformMatrix2fv(location, count, false, value, 0);
                break;
            }
            case 35675: {
                this.gl.glUniformMatrix3fv(location, count, false, value, 0);
                break;
            }
            case 35676: {
                this.gl.glUniformMatrix4fv(location, count, false, value, 0);
                break;
            }
            default: {
                logger.warning("Invalid uniform type: " + GltfConstants.stringFor((int)type));
            }
        }
    }

    public void setUniformSampler(int location, int textureIndex, int glTexture) {
        this.gl.glActiveTexture(33984 + textureIndex);
        this.gl.glBindTexture(3553, glTexture);
        this.gl.glUniform1i(location, textureIndex);
    }

    public int createGlVertexArray() {
        int[] vertexArrayArray = new int[]{0};
        this.gl.glGenVertexArrays(1, vertexArrayArray, 0);
        int glVertexArray = vertexArrayArray[0];
        return glVertexArray;
    }

    public void deleteGlVertexArray(int glVertexArray) {
        this.gl.glDeleteVertexArrays(1, new int[]{glVertexArray}, 0);
    }

    public int createGlBufferView(int target, int byteLength, ByteBuffer bufferViewData) {
        int[] bufferViewArray = new int[]{0};
        this.gl.glGenBuffers(1, bufferViewArray, 0);
        int glBufferView = bufferViewArray[0];
        this.gl.glBindBuffer(target, glBufferView);
        this.gl.glBufferData(target, (long)byteLength, (Buffer)bufferViewData, 35044);
        return glBufferView;
    }

    public void createVertexAttribute(int glVertexArray, int target, int glBufferView, int attributeLocation, int size, int type, int stride, int offset) {
        this.gl.glBindVertexArray(glVertexArray);
        this.gl.glBindBuffer(target, glBufferView);
        this.gl.glVertexAttribPointer(attributeLocation, size, type, false, stride, (long)offset);
        this.gl.glEnableVertexAttribArray(attributeLocation);
    }

    public void updateVertexAttribute(int glVertexArray, int target, int glBufferView, int offset, int size, ByteBuffer data) {
        this.gl.glBindVertexArray(glVertexArray);
        this.gl.glBindBuffer(target, glBufferView);
        this.gl.glBufferSubData(target, (long)offset, (long)size, (Buffer)data);
    }

    public void deleteGlBufferView(int glBufferView) {
        this.gl.glDeleteBuffers(1, new int[]{glBufferView}, 0);
    }

    public int createGlTexture(ByteBuffer pixelData, int internalFormat, int width, int height, int format, int type) {
        int[] textureArray = new int[]{0};
        this.gl.glGenTextures(1, textureArray, 0);
        int glTexture = textureArray[0];
        this.gl.glBindTexture(3553, glTexture);
        this.gl.glTexImage2D(3553, 0, internalFormat, width, height, 0, format, type, (Buffer)pixelData);
        return glTexture;
    }

    public void setGlTextureParameters(int glTexture, int minFilter, int magFilter, int wrapS, int wrapT) {
        this.gl.glBindTexture(3553, glTexture);
        this.gl.glTexParameteri(3553, 33084, 0);
        this.gl.glTexParameteri(3553, 33085, 0);
        this.gl.glTexParameteri(3553, 10241, minFilter);
        this.gl.glTexParameteri(3553, 10240, magFilter);
        this.gl.glTexParameteri(3553, 10242, wrapS);
        this.gl.glTexParameteri(3553, 10243, wrapT);
    }

    public void deleteGlTexture(int glTexture) {
        this.gl.glDeleteTextures(1, new int[]{glTexture}, 0);
    }

    public void renderIndexed(int glVertexArray, int mode, int glIndicesBuffer, int numIndices, int indicesType, int offset) {
        this.gl.glBindVertexArray(glVertexArray);
        this.gl.glBindBuffer(34963, glIndicesBuffer);
        this.gl.glDrawElements(mode, numIndices, indicesType, (long)offset);
    }

    public void renderNonIndexed(int glVertexArray, int mode, int numVertices) {
        this.gl.glBindVertexArray(glVertexArray);
        this.gl.glDrawArrays(mode, 0, numVertices);
    }

    public void setBlendColor(float r, float g, float b, float a) {
        this.gl.glBlendColor(r, g, b, a);
    }

    public void setBlendEquationSeparate(int modeRgb, int modeAlpha) {
        this.gl.glBlendEquationSeparate(modeRgb, modeAlpha);
    }

    public void setBlendFuncSeparate(int srcRgb, int dstRgb, int srcAlpha, int dstAlpha) {
        this.gl.glBlendFuncSeparate(srcRgb, dstRgb, srcAlpha, dstAlpha);
    }

    public void setColorMask(boolean r, boolean g, boolean b, boolean a) {
        this.gl.glColorMask(r, g, b, a);
    }

    public void setCullFace(int mode) {
        this.gl.glCullFace(mode);
    }

    public void setDepthFunc(int func) {
        this.gl.glDepthFunc(func);
    }

    public void setDepthMask(boolean mask) {
        this.gl.glDepthMask(mask);
    }

    public void setDepthRange(float zNear, float zFar) {
        this.gl.glDepthRange((double)zNear, (double)zFar);
    }

    public void setFrontFace(int mode) {
        this.gl.glFrontFace(mode);
    }

    public void setLineWidth(float width) {
        this.gl.glLineWidth(width);
    }

    public void setPolygonOffset(float factor, float units) {
        this.gl.glPolygonOffset(factor, units);
    }

    public void setScissor(int x, int y, int width, int height) {
        this.gl.glScissor(x, y, width, height);
    }

    private void printShaderLogInfo(int id) {
        IntBuffer infoLogLength = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.gl.glGetShaderiv(id, 35716, infoLogLength);
        if (infoLogLength.get(0) > 0) {
            infoLogLength.put(0, infoLogLength.get(0) - 1);
        }
        ByteBuffer infoLog = ByteBuffer.allocateDirect(infoLogLength.get(0)).order(ByteOrder.nativeOrder());
        this.gl.glGetShaderInfoLog(id, infoLogLength.get(0), null, infoLog);
        String infoLogString = Charset.forName("US-ASCII").decode(infoLog).toString();
        if (infoLogString.trim().length() > 0) {
            logger.warning("shader log:\n" + infoLogString);
        }
    }

    private void printProgramLogInfo(int id) {
        IntBuffer infoLogLength = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.gl.glGetProgramiv(id, 35716, infoLogLength);
        if (infoLogLength.get(0) > 0) {
            infoLogLength.put(0, infoLogLength.get(0) - 1);
        }
        ByteBuffer infoLog = ByteBuffer.allocateDirect(infoLogLength.get(0)).order(ByteOrder.nativeOrder());
        this.gl.glGetProgramInfoLog(id, infoLogLength.get(0), null, infoLog);
        String infoLogString = Charset.forName("US-ASCII").decode(infoLog).toString();
        if (infoLogString.trim().length() > 0) {
            logger.warning("program log:\n" + infoLogString);
        }
    }
}

