/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.obj.model;

import de.javagl.jgltf.model.gl.ProgramModel;
import de.javagl.jgltf.model.gl.Semantic;
import de.javagl.jgltf.model.gl.ShaderModel;
import de.javagl.jgltf.model.gl.TechniqueModel;
import de.javagl.jgltf.model.gl.TechniqueParametersModel;
import de.javagl.jgltf.model.gl.TechniqueStatesModel;
import de.javagl.jgltf.model.gl.impl.DefaultProgramModel;
import de.javagl.jgltf.model.gl.impl.DefaultShaderModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueParametersModel;
import de.javagl.jgltf.model.gl.impl.TechniqueStatesModels;
import de.javagl.jgltf.model.io.UriResolvers;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

class ObjTechniqueModels {
    static final String AMBIENT_NAME = "ambient";
    static final String DIFFUSE_NAME = "diffuse";
    static final String SPECULAR_NAME = "specular";
    static final String SHININESS_NAME = "shininess";
    static final TechniqueModel TECHNIQUE_MODEL_NONE = ObjTechniqueModels.createTechniqueModel(false, false, "none.vert", "none.frag");
    static final TechniqueModel TECHNIQUE_MODEL_TEXTURE = ObjTechniqueModels.createTechniqueModel(true, false, "texture.vert", "texture.frag");
    static final TechniqueModel TECHNIQUE_MODEL_NORMALS = ObjTechniqueModels.createTechniqueModel(false, true, "normals.vert", "normals.frag");
    static final TechniqueModel TECHNIQUE_MODEL_TEXTURE_NORMALS = ObjTechniqueModels.createTechniqueModel(true, true, "texture_normals.vert", "texture_normals.frag");

    private static TechniqueModel createTechniqueModel(boolean withTexture, boolean withNormals, String vertexShaderUri, String fragmentShaderUri) {
        String programName = "none";
        if (withTexture && withNormals) {
            programName = "texture_normals";
        } else if (withTexture) {
            programName = "texture";
        } else if (withNormals) {
            programName = "normals";
        }
        Function shaderUriResolver = UriResolvers.createResourceUriResolver(ObjTechniqueModels.class);
        DefaultShaderModel vertexShaderModel = new DefaultShaderModel(vertexShaderUri, ShaderModel.ShaderType.VERTEX_SHADER);
        vertexShaderModel.setName("vertex_shader_" + programName);
        ByteBuffer vertexShaderData = (ByteBuffer)shaderUriResolver.apply(vertexShaderUri);
        vertexShaderModel.setShaderData(vertexShaderData);
        DefaultShaderModel fragmentShaderModel = new DefaultShaderModel(fragmentShaderUri, ShaderModel.ShaderType.FRAGMENT_SHADER);
        fragmentShaderModel.setName("fragment_shader_" + programName);
        ByteBuffer fragmentShaderData = (ByteBuffer)shaderUriResolver.apply(fragmentShaderUri);
        fragmentShaderModel.setShaderData(fragmentShaderData);
        DefaultProgramModel programModel = new DefaultProgramModel();
        programModel.setName(programName);
        programModel.setVertexShaderModel((ShaderModel)vertexShaderModel);
        programModel.setFragmentShaderModel((ShaderModel)fragmentShaderModel);
        programModel.addAttribute("a_position");
        if (withTexture) {
            programModel.addAttribute("a_texcoord0");
        }
        if (withNormals) {
            programModel.addAttribute("a_normal");
        }
        DefaultTechniqueModel techniqueModel = new DefaultTechniqueModel();
        techniqueModel.setProgramModel((ProgramModel)programModel);
        Map<String, String> techniqueAttributes = ObjTechniqueModels.createTechniqueAttributes(withTexture, withNormals);
        for (Map.Entry<String, String> entry : techniqueAttributes.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            techniqueModel.addAttribute(string, string2);
        }
        Map<String, String> techniqueUniforms = ObjTechniqueModels.createTechniqueUniforms(withNormals);
        for (Map.Entry<String, String> entry : techniqueUniforms.entrySet()) {
            String string = entry.getKey();
            String v = entry.getValue();
            techniqueModel.addUniform(string, v);
        }
        Map<String, TechniqueParametersModel> map = ObjTechniqueModels.createTechniqueParameters(withTexture, withNormals);
        for (Map.Entry<String, TechniqueParametersModel> entry : map.entrySet()) {
            String k = entry.getKey();
            TechniqueParametersModel v = entry.getValue();
            techniqueModel.addParameter(k, v);
        }
        TechniqueStatesModel techniqueStatesModel = TechniqueStatesModels.createDefault();
        techniqueModel.setTechniqueStatesModel(techniqueStatesModel);
        return techniqueModel;
    }

    private static Map<String, String> createTechniqueAttributes(boolean withTexture, boolean withNormals) {
        LinkedHashMap<String, String> techniqueAttributes = new LinkedHashMap<String, String>();
        techniqueAttributes.put("a_position", "position");
        if (withTexture) {
            techniqueAttributes.put("a_texcoord0", "texcoord0");
        }
        if (withNormals) {
            techniqueAttributes.put("a_normal", "normal");
        }
        return techniqueAttributes;
    }

    private static Map<String, String> createTechniqueUniforms(boolean withNormals) {
        LinkedHashMap<String, String> techniqueUniforms = new LinkedHashMap<String, String>();
        techniqueUniforms.put("u_ambient", AMBIENT_NAME);
        techniqueUniforms.put("u_diffuse", DIFFUSE_NAME);
        techniqueUniforms.put("u_specular", SPECULAR_NAME);
        techniqueUniforms.put("u_shininess", SHININESS_NAME);
        techniqueUniforms.put("u_modelViewMatrix", "modelViewMatrix");
        if (withNormals) {
            techniqueUniforms.put("u_normalMatrix", "normalMatrix");
        }
        techniqueUniforms.put("u_projectionMatrix", "projectionMatrix");
        return techniqueUniforms;
    }

    private static Map<String, TechniqueParametersModel> createTechniqueParameters(boolean withTexture, boolean withNormals) {
        LinkedHashMap<String, TechniqueParametersModel> techniqueParameters = new LinkedHashMap<String, TechniqueParametersModel>();
        techniqueParameters.put("position", ObjTechniqueModels.createTechniqueParametersModel(35665, "POSITION"));
        if (withTexture) {
            techniqueParameters.put("texcoord0", ObjTechniqueModels.createTechniqueParametersModel(35664, "TEXCOORD_0"));
        }
        if (withNormals) {
            techniqueParameters.put("normal", ObjTechniqueModels.createTechniqueParametersModel(35665, "NORMAL"));
        }
        techniqueParameters.put("modelViewMatrix", ObjTechniqueModels.createTechniqueParametersModel(35676, Semantic.MODELVIEW.name()));
        if (withNormals) {
            techniqueParameters.put("normalMatrix", ObjTechniqueModels.createTechniqueParametersModel(35675, Semantic.MODELVIEWINVERSETRANSPOSE.name()));
        }
        techniqueParameters.put("projectionMatrix", ObjTechniqueModels.createTechniqueParametersModel(35676, Semantic.PROJECTION.name()));
        techniqueParameters.put(AMBIENT_NAME, ObjTechniqueModels.createTechniqueParametersModel(35666));
        if (withTexture) {
            techniqueParameters.put(DIFFUSE_NAME, ObjTechniqueModels.createTechniqueParametersModel(35678));
        } else {
            techniqueParameters.put(DIFFUSE_NAME, ObjTechniqueModels.createTechniqueParametersModel(35666));
        }
        techniqueParameters.put(SPECULAR_NAME, ObjTechniqueModels.createTechniqueParametersModel(35666));
        techniqueParameters.put(SHININESS_NAME, ObjTechniqueModels.createTechniqueParametersModel(5126));
        return techniqueParameters;
    }

    private static TechniqueParametersModel createTechniqueParametersModel(Integer type) {
        DefaultTechniqueParametersModel techniqueParametersModel = new DefaultTechniqueParametersModel(type.intValue(), 1, null, null, null);
        return techniqueParametersModel;
    }

    private static TechniqueParametersModel createTechniqueParametersModel(Integer type, String semantic) {
        DefaultTechniqueParametersModel techniqueParametersModel = new DefaultTechniqueParametersModel(type.intValue(), 1, semantic, null, null);
        return techniqueParametersModel;
    }

    private ObjTechniqueModels() {
    }
}

