/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.obj.model;

import de.javagl.jgltf.model.TextureModel;
import de.javagl.obj.FloatTuple;
import de.javagl.obj.Mtl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class MtlMaterialValues {
    static Map<String, Object> createMaterialValues(Mtl mtl, TextureModel textureModel) {
        LinkedHashMap<String, Object> materialValues = new LinkedHashMap<String, Object>();
        materialValues.put("ambient", MtlMaterialValues.createMaterialValue(mtl.getKa()));
        if (textureModel == null) {
            materialValues.put("diffuse", MtlMaterialValues.createMaterialValue(mtl.getKd(), mtl.getD()));
        } else {
            materialValues.put("diffuse", textureModel);
        }
        materialValues.put("specular", MtlMaterialValues.createMaterialValue(mtl.getKs()));
        materialValues.put("shininess", Collections.singletonList(Float.valueOf(mtl.getNs())));
        return materialValues;
    }

    private static List<Float> createMaterialValue(FloatTuple t) {
        return MtlMaterialValues.createMaterialValue(t, 1.0f);
    }

    private static List<Float> createMaterialValue(FloatTuple t, float z) {
        ArrayList<Float> list = new ArrayList<Float>();
        list.add(Float.valueOf(t.getX()));
        list.add(Float.valueOf(t.getY()));
        list.add(Float.valueOf(t.getZ()));
        list.add(Float.valueOf(z));
        return list;
    }

    static Map<String, Object> createDefaultMaterialValues(float r, float g, float b) {
        LinkedHashMap<String, Object> materialValues = new LinkedHashMap<String, Object>();
        materialValues.put("ambient", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)));
        materialValues.put("diffuse", Arrays.asList(Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(1.0f)));
        materialValues.put("specular", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)));
        materialValues.put("shininess", Float.valueOf(30.0f));
        return materialValues;
    }

    private MtlMaterialValues() {
    }
}

