/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.obj.model;

import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.v2.MaterialModelV2;
import de.javagl.jgltf.obj.model.MtlMaterialHandler;
import de.javagl.jgltf.obj.model.TextureModelHandler;
import de.javagl.obj.FloatTuple;
import de.javagl.obj.Mtl;
import de.javagl.obj.ReadableObj;

class MtlMaterialHandlerV2
implements MtlMaterialHandler {
    private final TextureModelHandler textureModelHandler;

    MtlMaterialHandlerV2(String baseUri) {
        this.textureModelHandler = new TextureModelHandler(baseUri);
    }

    @Override
    public MaterialModel createMaterial(ReadableObj obj, Mtl mtl) {
        boolean withTexture;
        boolean bl = withTexture = obj.getNumTexCoords() > 0 && mtl != null && mtl.getMapKd() != null;
        if (withTexture) {
            return this.createMaterialWithTexture(mtl);
        }
        MaterialModelV2 material = this.createMaterialWithColor(true, 0.75f, 0.75f, 0.75f);
        if (mtl == null) {
            return material;
        }
        FloatTuple ambientColor = mtl.getKd();
        float r = ambientColor.get(0);
        float g = ambientColor.get(1);
        float b = ambientColor.get(2);
        float opacity = mtl.getD();
        if (opacity < 1.0f) {
            material.setAlphaMode(MaterialModelV2.AlphaMode.BLEND);
        }
        material.setBaseColorFactor(new float[]{r, g, b, opacity});
        float shininess = mtl.getNs();
        material.setMetallicFactor(shininess / 128.0f);
        material.setDoubleSided(true);
        return material;
    }

    private MaterialModel createMaterialWithTexture(Mtl mtl) {
        String imageUri = mtl.getMapKd();
        TextureModel textureModel = this.textureModelHandler.getTextureModel(imageUri);
        MaterialModelV2 material = new MaterialModelV2();
        material.setBaseColorTexture(textureModel);
        material.setMetallicFactor(0.0f);
        material.setDoubleSided(true);
        return material;
    }

    public MaterialModelV2 createMaterialWithColor(boolean withNormals, float r, float g, float b) {
        MaterialModelV2 material = new MaterialModelV2();
        material.setRoughnessFactor(0.0f);
        material.setMetallicFactor(0.0f);
        material.setBaseColorFactor(new float[]{r, g, b, 1.0f});
        material.setDoubleSided(true);
        return material;
    }
}

