/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.v2;

import de.javagl.jgltf.impl.v2.Accessor;
import de.javagl.jgltf.impl.v2.AccessorSparse;
import de.javagl.jgltf.impl.v2.AccessorSparseIndices;
import de.javagl.jgltf.impl.v2.AccessorSparseValues;
import de.javagl.jgltf.impl.v2.Animation;
import de.javagl.jgltf.impl.v2.AnimationChannel;
import de.javagl.jgltf.impl.v2.AnimationChannelTarget;
import de.javagl.jgltf.impl.v2.AnimationSampler;
import de.javagl.jgltf.impl.v2.Buffer;
import de.javagl.jgltf.impl.v2.BufferView;
import de.javagl.jgltf.impl.v2.Camera;
import de.javagl.jgltf.impl.v2.CameraOrthographic;
import de.javagl.jgltf.impl.v2.CameraPerspective;
import de.javagl.jgltf.impl.v2.GlTF;
import de.javagl.jgltf.impl.v2.GlTFChildOfRootProperty;
import de.javagl.jgltf.impl.v2.GlTFProperty;
import de.javagl.jgltf.impl.v2.Image;
import de.javagl.jgltf.impl.v2.Material;
import de.javagl.jgltf.impl.v2.MaterialNormalTextureInfo;
import de.javagl.jgltf.impl.v2.MaterialOcclusionTextureInfo;
import de.javagl.jgltf.impl.v2.MaterialPbrMetallicRoughness;
import de.javagl.jgltf.impl.v2.Mesh;
import de.javagl.jgltf.impl.v2.MeshPrimitive;
import de.javagl.jgltf.impl.v2.Node;
import de.javagl.jgltf.impl.v2.Sampler;
import de.javagl.jgltf.impl.v2.Scene;
import de.javagl.jgltf.impl.v2.Skin;
import de.javagl.jgltf.impl.v2.Texture;
import de.javagl.jgltf.impl.v2.TextureInfo;
import de.javagl.jgltf.model.AccessorData;
import de.javagl.jgltf.model.AccessorDatas;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.AnimationModel;
import de.javagl.jgltf.model.ElementType;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.impl.AbstractModelElement;
import de.javagl.jgltf.model.impl.AbstractNamedModelElement;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.impl.DefaultAnimationModel;
import de.javagl.jgltf.model.impl.DefaultBufferModel;
import de.javagl.jgltf.model.impl.DefaultBufferViewModel;
import de.javagl.jgltf.model.impl.DefaultCameraModel;
import de.javagl.jgltf.model.impl.DefaultCameraOrthographicModel;
import de.javagl.jgltf.model.impl.DefaultCameraPerspectiveModel;
import de.javagl.jgltf.model.impl.DefaultGltfModel;
import de.javagl.jgltf.model.impl.DefaultImageModel;
import de.javagl.jgltf.model.impl.DefaultMeshModel;
import de.javagl.jgltf.model.impl.DefaultMeshPrimitiveModel;
import de.javagl.jgltf.model.impl.DefaultNodeModel;
import de.javagl.jgltf.model.impl.DefaultSceneModel;
import de.javagl.jgltf.model.impl.DefaultSkinModel;
import de.javagl.jgltf.model.impl.DefaultTextureModel;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.GltfAsset;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.io.v2.GltfAssetV2;
import de.javagl.jgltf.model.v2.AccessorSparseUtils;
import de.javagl.jgltf.model.v2.MaterialModelV2;
import de.javagl.jgltf.model.v2.gl.Materials;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class GltfModelCreatorV2 {
    private static final Logger logger = Logger.getLogger(GltfModelCreatorV2.class.getName());
    private final GltfAsset gltfAsset;
    private final GlTF gltf;
    private final DefaultGltfModel gltfModel;

    public static DefaultGltfModel create(GltfAssetV2 gltfAsset) {
        DefaultGltfModel gltfModel = new DefaultGltfModel();
        GltfModelCreatorV2 creator = new GltfModelCreatorV2(gltfAsset, gltfModel);
        creator.create();
        return gltfModel;
    }

    GltfModelCreatorV2(GltfAssetV2 gltfAsset, DefaultGltfModel gltfModel) {
        this.gltfAsset = Objects.requireNonNull(gltfAsset, "The gltfAsset may not be null");
        this.gltf = gltfAsset.getGltf();
        this.gltfModel = Objects.requireNonNull(gltfModel, "The gltfModel may not be null");
    }

    void create() {
        GltfModelCreatorV2.transferGltfPropertyElements((GlTFProperty)this.gltf, this.gltfModel);
        this.createAccessorModels();
        this.createAnimationModels();
        this.createBufferModels();
        this.createBufferViewModels();
        this.createCameraModels();
        this.createImageModels();
        this.createMaterialModels();
        this.createMeshModels();
        this.createNodeModels();
        this.createSceneModels();
        this.createSkinModels();
        this.createTextureModels();
        this.initBufferModels();
        this.initBufferViewModels();
        this.initAccessorModels();
        this.initAnimationModels();
        this.initImageModels();
        this.initMeshModels();
        this.initNodeModels();
        this.initSceneModels();
        this.initSkinModels();
        this.initTextureModels();
        this.initMaterialModels();
    }

    private void createAccessorModels() {
        List accessors = Optionals.of(this.gltf.getAccessors());
        for (int i = 0; i < accessors.size(); ++i) {
            Accessor accessor = (Accessor)accessors.get(i);
            Integer componentType = accessor.getComponentType();
            Integer count = accessor.getCount();
            ElementType elementType = ElementType.forString(accessor.getType());
            DefaultAccessorModel accessorModel = new DefaultAccessorModel(componentType, count, elementType);
            this.gltfModel.addAccessorModel(accessorModel);
        }
    }

    private void createAnimationModels() {
        List animations = Optionals.of(this.gltf.getAnimations());
        for (int i = 0; i < animations.size(); ++i) {
            this.gltfModel.addAnimationModel(new DefaultAnimationModel());
        }
    }

    private void createBufferModels() {
        List buffers = Optionals.of(this.gltf.getBuffers());
        for (int i = 0; i < buffers.size(); ++i) {
            Buffer buffer = (Buffer)buffers.get(i);
            DefaultBufferModel bufferModel = new DefaultBufferModel();
            bufferModel.setUri(buffer.getUri());
            this.gltfModel.addBufferModel(bufferModel);
        }
    }

    private void createCameraModels() {
        List cameras = Optionals.of(this.gltf.getCameras());
        for (int i = 0; i < cameras.size(); ++i) {
            DefaultCameraModel cameraModel;
            Camera camera = (Camera)cameras.get(i);
            String type = camera.getType();
            if ("perspective".equals(type)) {
                CameraPerspective cameraPerspective = camera.getPerspective();
                DefaultCameraPerspectiveModel cameraPerspectiveModel = new DefaultCameraPerspectiveModel();
                cameraPerspectiveModel.setAspectRatio(cameraPerspective.getAspectRatio());
                cameraPerspectiveModel.setYfov(cameraPerspective.getYfov());
                cameraPerspectiveModel.setZfar(cameraPerspective.getZfar());
                cameraPerspectiveModel.setZnear(cameraPerspective.getZnear());
                cameraModel = new DefaultCameraModel();
                cameraModel.setCameraPerspectiveModel(cameraPerspectiveModel);
                this.gltfModel.addCameraModel(cameraModel);
                continue;
            }
            if ("orthographic".equals(type)) {
                CameraOrthographic cameraOrthographic = camera.getOrthographic();
                DefaultCameraOrthographicModel cameraOrthographicModel = new DefaultCameraOrthographicModel();
                cameraOrthographicModel.setXmag(cameraOrthographic.getXmag());
                cameraOrthographicModel.setYmag(cameraOrthographic.getYmag());
                cameraOrthographicModel.setZfar(cameraOrthographic.getZfar());
                cameraOrthographicModel.setZnear(cameraOrthographic.getZnear());
                cameraModel = new DefaultCameraModel();
                cameraModel.setCameraOrthographicModel(cameraOrthographicModel);
                this.gltfModel.addCameraModel(cameraModel);
                continue;
            }
            logger.severe("Invalid camera type: " + type);
        }
    }

    private void createBufferViewModels() {
        List bufferViews = Optionals.of(this.gltf.getBufferViews());
        for (int i = 0; i < bufferViews.size(); ++i) {
            BufferView bufferView = (BufferView)bufferViews.get(i);
            DefaultBufferViewModel bufferViewModel = GltfModelCreatorV2.createBufferViewModel(bufferView);
            this.gltfModel.addBufferViewModel(bufferViewModel);
        }
    }

    private static DefaultBufferViewModel createBufferViewModel(BufferView bufferView) {
        int byteOffset = Optionals.of(bufferView.getByteOffset(), 0);
        int byteLength = bufferView.getByteLength();
        Integer byteStride = bufferView.getByteStride();
        Integer target = bufferView.getTarget();
        DefaultBufferViewModel bufferViewModel = new DefaultBufferViewModel(target);
        bufferViewModel.setByteOffset(byteOffset);
        bufferViewModel.setByteLength(byteLength);
        bufferViewModel.setByteStride(byteStride);
        return bufferViewModel;
    }

    private void createImageModels() {
        List images = Optionals.of(this.gltf.getImages());
        for (int i = 0; i < images.size(); ++i) {
            Image image = (Image)images.get(i);
            String mimeType = image.getMimeType();
            DefaultImageModel imageModel = new DefaultImageModel();
            imageModel.setMimeType(mimeType);
            String uri = image.getUri();
            imageModel.setUri(uri);
            this.gltfModel.addImageModel(imageModel);
        }
    }

    private void createMaterialModels() {
        List materials = Optionals.of(this.gltf.getMaterials());
        for (int i = 0; i < materials.size(); ++i) {
            MaterialModelV2 materialModel = new MaterialModelV2();
            this.gltfModel.addMaterialModel(materialModel);
        }
    }

    private void createMeshModels() {
        List meshes = Optionals.of(this.gltf.getMeshes());
        for (int i = 0; i < meshes.size(); ++i) {
            this.gltfModel.addMeshModel(new DefaultMeshModel());
        }
    }

    private void createNodeModels() {
        List nodes = Optionals.of(this.gltf.getNodes());
        for (int i = 0; i < nodes.size(); ++i) {
            this.gltfModel.addNodeModel(new DefaultNodeModel());
        }
    }

    private void createSceneModels() {
        List scenes = Optionals.of(this.gltf.getScenes());
        for (int i = 0; i < scenes.size(); ++i) {
            this.gltfModel.addSceneModel(new DefaultSceneModel());
        }
    }

    private void createSkinModels() {
        List skins = Optionals.of(this.gltf.getSkins());
        for (int i = 0; i < skins.size(); ++i) {
            this.gltfModel.addSkinModel(new DefaultSkinModel());
        }
    }

    private void createTextureModels() {
        List textures = Optionals.of(this.gltf.getTextures());
        List samplers = Optionals.of(this.gltf.getSamplers());
        for (int i = 0; i < textures.size(); ++i) {
            Texture texture = (Texture)textures.get(i);
            Integer samplerIndex = texture.getSampler();
            Integer magFilter = 9729;
            Integer minFilter = 9729;
            Integer wrapS = 10497;
            Integer wrapT = 10497;
            if (samplerIndex != null) {
                Sampler sampler = (Sampler)samplers.get(samplerIndex);
                magFilter = sampler.getMagFilter();
                minFilter = sampler.getMinFilter();
                wrapS = Optionals.of(sampler.getWrapS(), sampler.defaultWrapS());
                wrapT = Optionals.of(sampler.getWrapT(), sampler.defaultWrapT());
            }
            DefaultTextureModel textureModel = new DefaultTextureModel();
            textureModel.setMagFilter(magFilter);
            textureModel.setMinFilter(minFilter);
            textureModel.setWrapS(wrapS);
            textureModel.setWrapT(wrapT);
            this.gltfModel.addTextureModel(textureModel);
        }
    }

    private void initAccessorModels() {
        List accessors = Optionals.of(this.gltf.getAccessors());
        for (int i = 0; i < accessors.size(); ++i) {
            Accessor accessor = (Accessor)accessors.get(i);
            DefaultAccessorModel accessorModel = this.gltfModel.getAccessorModel(i);
            GltfModelCreatorV2.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)accessor, accessorModel);
            int byteOffset = Optionals.of(accessor.getByteOffset(), 0);
            accessorModel.setByteOffset(byteOffset);
            Boolean normalized = accessor.isNormalized();
            accessorModel.setNormalized(Boolean.TRUE.equals(normalized));
            AccessorSparse accessorSparse = accessor.getSparse();
            if (accessorSparse == null) {
                this.initDenseAccessorModel(i, accessor, accessorModel);
                continue;
            }
            this.initSparseAccessorModel(i, accessor, accessorModel);
        }
    }

    private void initDenseAccessorModel(int accessorIndex, Accessor accessor, DefaultAccessorModel accessorModel) {
        Integer bufferViewIndex = accessor.getBufferView();
        if (bufferViewIndex != null) {
            DefaultBufferViewModel bufferViewModel = this.gltfModel.getBufferViewModel(bufferViewIndex);
            accessorModel.setBufferViewModel(bufferViewModel);
            Integer byteStride = bufferViewModel.getByteStride();
            if (byteStride != null) {
                accessorModel.setByteStride(byteStride);
            }
            accessorModel.setAccessorData(AccessorDatas.create(accessorModel));
        } else {
            int count = accessorModel.getCount();
            int elementSizeInBytes = accessorModel.getElementSizeInBytes();
            int byteLength = elementSizeInBytes * count;
            ByteBuffer bufferData = Buffers.create(byteLength);
            String uriString = "buffer_for_accessor" + accessorIndex + ".bin";
            DefaultBufferViewModel bufferViewModel = GltfModelCreatorV2.createBufferViewModel(uriString, bufferData);
            accessorModel.setBufferViewModel(bufferViewModel);
            accessorModel.setAccessorData(AccessorDatas.create(accessorModel));
        }
    }

    private void initSparseAccessorModel(int accessorIndex, Accessor accessor, DefaultAccessorModel accessorModel) {
        int count = accessorModel.getCount();
        int elementSizeInBytes = accessorModel.getElementSizeInBytes();
        int byteLength = elementSizeInBytes * count;
        ByteBuffer bufferData = Buffers.create(byteLength);
        String uriString = "buffer_for_accessor" + accessorIndex + ".bin";
        DefaultBufferViewModel denseBufferViewModel = GltfModelCreatorV2.createBufferViewModel(uriString, bufferData);
        accessorModel.setBufferViewModel(denseBufferViewModel);
        accessorModel.setByteOffset(0);
        Integer bufferViewIndex = accessor.getBufferView();
        if (bufferViewIndex != null) {
            Consumer<ByteBuffer> sparseSubstitutionCallback = denseByteBuffer -> {
                logger.fine("Substituting sparse accessor data, based on existing buffer view");
                DefaultBufferViewModel baseBufferViewModel = this.gltfModel.getBufferViewModel(bufferViewIndex);
                ByteBuffer baseBufferViewData = baseBufferViewModel.getBufferViewData();
                AccessorData baseAccessorData = AccessorDatas.create(accessorModel, baseBufferViewData);
                AccessorData denseAccessorData = AccessorDatas.create(accessorModel, bufferData);
                this.substituteSparseAccessorData(accessor, accessorModel, denseAccessorData, baseAccessorData);
            };
            denseBufferViewModel.setSparseSubstitutionCallback(sparseSubstitutionCallback);
        } else {
            Consumer<ByteBuffer> sparseSubstitutionCallback = denseByteBuffer -> {
                logger.fine("Substituting sparse accessor data, without an existing buffer view");
                AccessorData denseAccessorData = AccessorDatas.create(accessorModel, bufferData);
                this.substituteSparseAccessorData(accessor, accessorModel, denseAccessorData, null);
            };
            denseBufferViewModel.setSparseSubstitutionCallback(sparseSubstitutionCallback);
        }
    }

    private static DefaultBufferViewModel createBufferViewModel(String uriString, ByteBuffer bufferData) {
        DefaultBufferModel bufferModel = new DefaultBufferModel();
        bufferModel.setUri(uriString);
        bufferModel.setBufferData(bufferData);
        DefaultBufferViewModel bufferViewModel = new DefaultBufferViewModel(null);
        bufferViewModel.setByteOffset(0);
        bufferViewModel.setByteLength(bufferData.capacity());
        bufferViewModel.setBufferModel(bufferModel);
        return bufferViewModel;
    }

    private void substituteSparseAccessorData(Accessor accessor, AccessorModel accessorModel, AccessorData denseAccessorData, AccessorData baseAccessorData) {
        AccessorSparse accessorSparse = accessor.getSparse();
        int count = accessorSparse.getCount();
        AccessorSparseIndices accessorSparseIndices = accessorSparse.getIndices();
        AccessorData sparseIndicesAccessorData = this.createSparseIndicesAccessorData(accessorSparseIndices, count);
        AccessorSparseValues accessorSparseValues = accessorSparse.getValues();
        ElementType elementType = accessorModel.getElementType();
        AccessorData sparseValuesAccessorData = this.createSparseValuesAccessorData(accessorSparseValues, accessorModel.getComponentType(), elementType, count);
        AccessorSparseUtils.substituteAccessorData(denseAccessorData, baseAccessorData, sparseIndicesAccessorData, sparseValuesAccessorData);
    }

    private AccessorData createSparseIndicesAccessorData(AccessorSparseIndices accessorSparseIndices, int count) {
        Integer componentType = accessorSparseIndices.getComponentType();
        Integer bufferViewIndex = accessorSparseIndices.getBufferView();
        DefaultBufferViewModel bufferViewModel = this.gltfModel.getBufferViewModel(bufferViewIndex);
        ByteBuffer bufferViewData = bufferViewModel.getBufferViewData();
        int byteOffset = Optionals.of(accessorSparseIndices.getByteOffset(), 0);
        return AccessorDatas.create(componentType, bufferViewData, byteOffset, count, ElementType.SCALAR, null);
    }

    private AccessorData createSparseValuesAccessorData(AccessorSparseValues accessorSparseValues, int componentType, ElementType elementType, int count) {
        Integer bufferViewIndex = accessorSparseValues.getBufferView();
        DefaultBufferViewModel bufferViewModel = this.gltfModel.getBufferViewModel(bufferViewIndex);
        ByteBuffer bufferViewData = bufferViewModel.getBufferViewData();
        int byteOffset = Optionals.of(accessorSparseValues.getByteOffset(), 0);
        return AccessorDatas.create(componentType, bufferViewData, byteOffset, count, elementType, null);
    }

    private void initAnimationModels() {
        List animations = Optionals.of(this.gltf.getAnimations());
        for (int i = 0; i < animations.size(); ++i) {
            Animation animation = (Animation)animations.get(i);
            DefaultAnimationModel animationModel = this.gltfModel.getAnimationModel(i);
            GltfModelCreatorV2.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)animation, animationModel);
            List<AnimationChannel> channels = Optionals.of(animation.getChannels());
            for (AnimationChannel animationChannel : channels) {
                AnimationModel.Channel channel = this.createChannel(animation, animationChannel);
                animationModel.addChannel(channel);
            }
        }
    }

    private AnimationModel.Channel createChannel(Animation animation, AnimationChannel animationChannel) {
        List samplers = Optionals.of(animation.getSamplers());
        int samplerIndex = animationChannel.getSampler();
        AnimationSampler animationSampler = (AnimationSampler)samplers.get(samplerIndex);
        int inputAccessorIndex = animationSampler.getInput();
        DefaultAccessorModel inputAccessorModel = this.gltfModel.getAccessorModel(inputAccessorIndex);
        int outputAccessorIndex = animationSampler.getOutput();
        DefaultAccessorModel outputAccessorModel = this.gltfModel.getAccessorModel(outputAccessorIndex);
        String interpolationString = animationSampler.getInterpolation();
        AnimationModel.Interpolation interpolation = interpolationString == null ? AnimationModel.Interpolation.LINEAR : AnimationModel.Interpolation.valueOf(interpolationString);
        DefaultAnimationModel.DefaultSampler sampler = new DefaultAnimationModel.DefaultSampler(inputAccessorModel, interpolation, outputAccessorModel);
        AnimationChannelTarget animationChannelTarget = animationChannel.getTarget();
        Integer nodeIndex = animationChannelTarget.getNode();
        DefaultNodeModel nodeModel = null;
        if (nodeIndex == null) {
            logger.warning("No node index given for animation channel target");
        } else {
            nodeModel = this.gltfModel.getNodeModel(nodeIndex);
        }
        String path = animationChannelTarget.getPath();
        DefaultAnimationModel.DefaultChannel channel = new DefaultAnimationModel.DefaultChannel(sampler, nodeModel, path);
        return channel;
    }

    private void initBufferModels() {
        List buffers = Optionals.of(this.gltf.getBuffers());
        ByteBuffer binaryData = null;
        ByteBuffer b = this.gltfAsset.getBinaryData();
        if (b != null && b.capacity() > 0) {
            binaryData = b;
        }
        if (buffers.isEmpty() && binaryData != null) {
            logger.warning("Binary data was given, but no buffers");
            return;
        }
        for (int i = 0; i < buffers.size(); ++i) {
            Buffer buffer = (Buffer)buffers.get(i);
            DefaultBufferModel bufferModel = this.gltfModel.getBufferModel(i);
            GltfModelCreatorV2.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)buffer, bufferModel);
            if (i == 0 && binaryData != null) {
                bufferModel.setBufferData(binaryData);
                continue;
            }
            String uri = buffer.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer bufferData = Buffers.create(data);
                bufferModel.setBufferData(bufferData);
                continue;
            }
            if (uri == null) {
                logger.warning("Buffer " + i + " does not have a uri. Binary chunks that are not the main GLB buffer are not supported.");
                continue;
            }
            ByteBuffer bufferData = this.gltfAsset.getReferenceData(uri);
            bufferModel.setBufferData(bufferData);
        }
    }

    private void initBufferViewModels() {
        List bufferViews = Optionals.of(this.gltf.getBufferViews());
        for (int i = 0; i < bufferViews.size(); ++i) {
            BufferView bufferView = (BufferView)bufferViews.get(i);
            DefaultBufferViewModel bufferViewModel = this.gltfModel.getBufferViewModel(i);
            GltfModelCreatorV2.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)bufferView, bufferViewModel);
            int bufferIndex = bufferView.getBuffer();
            DefaultBufferModel bufferModel = this.gltfModel.getBufferModel(bufferIndex);
            bufferViewModel.setBufferModel(bufferModel);
        }
    }

    private void initMeshModels() {
        List meshes = Optionals.of(this.gltf.getMeshes());
        for (int i = 0; i < meshes.size(); ++i) {
            Mesh mesh = (Mesh)meshes.get(i);
            DefaultMeshModel meshModel = this.gltfModel.getMeshModel(i);
            GltfModelCreatorV2.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)mesh, meshModel);
            List<MeshPrimitive> primitives = Optionals.of(mesh.getPrimitives());
            for (MeshPrimitive meshPrimitive : primitives) {
                DefaultMeshPrimitiveModel meshPrimitiveModel = this.createMeshPrimitiveModel(meshPrimitive);
                meshModel.addMeshPrimitiveModel(meshPrimitiveModel);
            }
        }
    }

    private DefaultMeshPrimitiveModel createMeshPrimitiveModel(MeshPrimitive meshPrimitive) {
        Integer mode = Optionals.of(meshPrimitive.getMode(), meshPrimitive.defaultMode());
        DefaultMeshPrimitiveModel meshPrimitiveModel = new DefaultMeshPrimitiveModel(mode);
        GltfModelCreatorV2.transferGltfPropertyElements((GlTFProperty)meshPrimitive, meshPrimitiveModel);
        Integer indicesIndex = meshPrimitive.getIndices();
        if (indicesIndex != null) {
            DefaultAccessorModel indices = this.gltfModel.getAccessorModel(indicesIndex);
            meshPrimitiveModel.setIndices(indices);
        }
        Map attributes = Optionals.of(meshPrimitive.getAttributes());
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            int attributeIndex = (Integer)entry.getValue();
            DefaultAccessorModel attribute = this.gltfModel.getAccessorModel(attributeIndex);
            meshPrimitiveModel.putAttribute(attributeName, attribute);
        }
        List<Map> morphTargets = Optionals.of(meshPrimitive.getTargets());
        for (Map morphTarget : morphTargets) {
            LinkedHashMap<String, DefaultAccessorModel> morphTargetModel = new LinkedHashMap<String, DefaultAccessorModel>();
            for (Map.Entry entry : morphTarget.entrySet()) {
                String attribute = (String)entry.getKey();
                Integer accessorIndex = (Integer)entry.getValue();
                DefaultAccessorModel accessorModel = this.gltfModel.getAccessorModel(accessorIndex);
                morphTargetModel.put(attribute, accessorModel);
            }
            meshPrimitiveModel.addTarget(Collections.unmodifiableMap(morphTargetModel));
        }
        Integer n = meshPrimitive.getMaterial();
        if (n != null) {
            MaterialModelV2 materialModel = (MaterialModelV2)this.gltfModel.getMaterialModel(n);
            meshPrimitiveModel.setMaterialModel(materialModel);
        }
        return meshPrimitiveModel;
    }

    private void initNodeModels() {
        List nodes = Optionals.of(this.gltf.getNodes());
        for (int i = 0; i < nodes.size(); ++i) {
            Integer cameraIndex;
            Integer skinIndex;
            Node node = (Node)nodes.get(i);
            DefaultNodeModel nodeModel = this.gltfModel.getNodeModel(i);
            GltfModelCreatorV2.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)node, nodeModel);
            List<Integer> childIndices = Optionals.of(node.getChildren());
            for (Integer childIndex : childIndices) {
                DefaultNodeModel child = this.gltfModel.getNodeModel(childIndex);
                nodeModel.addChild(child);
            }
            Integer meshIndex = node.getMesh();
            if (meshIndex != null) {
                DefaultMeshModel meshModel = this.gltfModel.getMeshModel(meshIndex);
                nodeModel.addMeshModel(meshModel);
            }
            if ((skinIndex = node.getSkin()) != null) {
                DefaultSkinModel skinModel = this.gltfModel.getSkinModel(skinIndex);
                nodeModel.setSkinModel(skinModel);
            }
            if ((cameraIndex = node.getCamera()) != null) {
                DefaultCameraModel cameraModel = this.gltfModel.getCameraModel(cameraIndex);
                nodeModel.setCameraModel(cameraModel);
            }
            float[] matrix = node.getMatrix();
            float[] translation = node.getTranslation();
            float[] rotation = node.getRotation();
            float[] scale = node.getScale();
            nodeModel.setMatrix(Optionals.clone(matrix));
            nodeModel.setTranslation(Optionals.clone(translation));
            nodeModel.setRotation(Optionals.clone(rotation));
            nodeModel.setScale(Optionals.clone(scale));
            List weights = node.getWeights();
            if (weights == null) continue;
            float[] weightsArray = new float[weights.size()];
            for (int j = 0; j < weights.size(); ++j) {
                weightsArray[j] = ((Float)weights.get(j)).floatValue();
            }
            nodeModel.setWeights(weightsArray);
        }
    }

    private void initSceneModels() {
        List scenes = Optionals.of(this.gltf.getScenes());
        for (int i = 0; i < scenes.size(); ++i) {
            Scene scene = (Scene)scenes.get(i);
            DefaultSceneModel sceneModel = this.gltfModel.getSceneModel(i);
            GltfModelCreatorV2.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)scene, sceneModel);
            List<Integer> nodeIndices = Optionals.of(scene.getNodes());
            for (Integer nodeIndex : nodeIndices) {
                DefaultNodeModel nodeModel = this.gltfModel.getNodeModel(nodeIndex);
                sceneModel.addNode(nodeModel);
            }
        }
    }

    private void initSkinModels() {
        List skins = Optionals.of(this.gltf.getSkins());
        for (int i = 0; i < skins.size(); ++i) {
            Skin skin = (Skin)skins.get(i);
            DefaultSkinModel skinModel = this.gltfModel.getSkinModel(i);
            GltfModelCreatorV2.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)skin, skinModel);
            List jointIndices = skin.getJoints();
            for (Integer jointIndex : jointIndices) {
                DefaultNodeModel jointNodeModel = this.gltfModel.getNodeModel(jointIndex);
                skinModel.addJoint(jointNodeModel);
            }
            Integer inverseBindMatricesIndex = skin.getInverseBindMatrices();
            DefaultAccessorModel inverseBindMatrices = this.gltfModel.getAccessorModel(inverseBindMatricesIndex);
            skinModel.setInverseBindMatrices(inverseBindMatrices);
        }
    }

    private void initTextureModels() {
        List textures = Optionals.of(this.gltf.getTextures());
        for (int i = 0; i < textures.size(); ++i) {
            Texture texture = (Texture)textures.get(i);
            DefaultTextureModel textureModel = this.gltfModel.getTextureModel(i);
            GltfModelCreatorV2.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)texture, textureModel);
            Integer imageIndex = texture.getSource();
            if (imageIndex == null) continue;
            DefaultImageModel imageModel = this.gltfModel.getImageModel(imageIndex);
            textureModel.setImageModel(imageModel);
        }
    }

    private void initImageModels() {
        List images = Optionals.of(this.gltf.getImages());
        for (int i = 0; i < images.size(); ++i) {
            Image image = (Image)images.get(i);
            DefaultImageModel imageModel = this.gltfModel.getImageModel(i);
            GltfModelCreatorV2.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)image, imageModel);
            Integer bufferViewIndex = image.getBufferView();
            if (bufferViewIndex != null) {
                DefaultBufferViewModel bufferViewModel = this.gltfModel.getBufferViewModel(bufferViewIndex);
                imageModel.setBufferViewModel(bufferViewModel);
                continue;
            }
            String uri = image.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer imageData = Buffers.create(data);
                imageModel.setImageData(imageData);
                continue;
            }
            ByteBuffer imageData = this.gltfAsset.getReferenceData(uri);
            imageModel.setImageData(imageData);
        }
    }

    private void initMaterialModels() {
        List materials = Optionals.of(this.gltf.getMaterials());
        for (int i = 0; i < materials.size(); ++i) {
            Material material = (Material)materials.get(i);
            MaterialModelV2 materialModel = (MaterialModelV2)this.gltfModel.getMaterialModel(i);
            GltfModelCreatorV2.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)material, materialModel);
            this.initMaterialModel(materialModel, material);
        }
    }

    private void initMaterialModel(MaterialModelV2 materialModel, Material material) {
        TextureInfo emissiveTextureInfo;
        MaterialOcclusionTextureInfo occlusionTextureInfo;
        String alphaModeString;
        MaterialPbrMetallicRoughness pbrMetallicRoughness = material.getPbrMetallicRoughness();
        if (pbrMetallicRoughness == null) {
            pbrMetallicRoughness = Materials.createDefaultMaterialPbrMetallicRoughness();
        }
        if ((alphaModeString = material.getAlphaMode()) != null) {
            materialModel.setAlphaMode(MaterialModelV2.AlphaMode.valueOf(alphaModeString));
        }
        materialModel.setAlphaCutoff(Optionals.of(material.getAlphaCutoff(), Float.valueOf(0.5f)).floatValue());
        materialModel.setDoubleSided(Boolean.TRUE.equals(material.isDoubleSided()));
        TextureInfo baseColorTextureInfo = pbrMetallicRoughness.getBaseColorTexture();
        if (baseColorTextureInfo != null) {
            int index = baseColorTextureInfo.getIndex();
            DefaultTextureModel textureModel = this.gltfModel.getTextureModel(index);
            materialModel.setBaseColorTexture(textureModel);
            materialModel.setBaseColorTexcoord(baseColorTextureInfo.getTexCoord());
        }
        float[] baseColorFactor = Optionals.of(pbrMetallicRoughness.getBaseColorFactor(), pbrMetallicRoughness.defaultBaseColorFactor());
        materialModel.setBaseColorFactor(baseColorFactor);
        TextureInfo metallicRoughnessTextureInfo = pbrMetallicRoughness.getMetallicRoughnessTexture();
        if (metallicRoughnessTextureInfo != null) {
            int index = metallicRoughnessTextureInfo.getIndex();
            DefaultTextureModel textureModel = this.gltfModel.getTextureModel(index);
            materialModel.setMetallicRoughnessTexture(textureModel);
            materialModel.setMetallicRoughnessTexcoord(metallicRoughnessTextureInfo.getTexCoord());
        }
        float metallicFactor = Optionals.of(pbrMetallicRoughness.getMetallicFactor(), pbrMetallicRoughness.defaultMetallicFactor()).floatValue();
        materialModel.setMetallicFactor(metallicFactor);
        float roughnessFactor = Optionals.of(pbrMetallicRoughness.getRoughnessFactor(), pbrMetallicRoughness.defaultRoughnessFactor()).floatValue();
        materialModel.setRoughnessFactor(roughnessFactor);
        MaterialNormalTextureInfo normalTextureInfo = material.getNormalTexture();
        if (normalTextureInfo != null) {
            int index = normalTextureInfo.getIndex();
            DefaultTextureModel textureModel = this.gltfModel.getTextureModel(index);
            materialModel.setNormalTexture(textureModel);
            materialModel.setNormalTexcoord(normalTextureInfo.getTexCoord());
            float normalScale = Optionals.of(normalTextureInfo.getScale(), normalTextureInfo.defaultScale()).floatValue();
            materialModel.setNormalScale(normalScale);
        }
        if ((occlusionTextureInfo = material.getOcclusionTexture()) != null) {
            int index = occlusionTextureInfo.getIndex();
            DefaultTextureModel textureModel = this.gltfModel.getTextureModel(index);
            materialModel.setOcclusionTexture(textureModel);
            materialModel.setOcclusionTexcoord(occlusionTextureInfo.getTexCoord());
            float occlusionStrength = Optionals.of(occlusionTextureInfo.getStrength(), occlusionTextureInfo.defaultStrength()).floatValue();
            materialModel.setOcclusionStrength(occlusionStrength);
        }
        if ((emissiveTextureInfo = material.getEmissiveTexture()) != null) {
            int index = emissiveTextureInfo.getIndex();
            DefaultTextureModel textureModel = this.gltfModel.getTextureModel(index);
            materialModel.setEmissiveTexture(textureModel);
            materialModel.setEmissiveTexcoord(emissiveTextureInfo.getTexCoord());
        }
        float[] emissiveFactor = Optionals.of(material.getEmissiveFactor(), material.defaultEmissiveFactor());
        materialModel.setEmissiveFactor(emissiveFactor);
    }

    private static void transferGltfPropertyElements(GlTFProperty property, AbstractModelElement modelElement) {
        modelElement.setExtensions(property.getExtensions());
        modelElement.setExtras(property.getExtras());
    }

    private static void transferGltfChildOfRootPropertyElements(GlTFChildOfRootProperty property, AbstractNamedModelElement modelElement) {
        modelElement.setName(property.getName());
        GltfModelCreatorV2.transferGltfPropertyElements((GlTFProperty)property, modelElement);
    }
}

