/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.v1;

import de.javagl.jgltf.impl.v1.Accessor;
import de.javagl.jgltf.impl.v1.Animation;
import de.javagl.jgltf.impl.v1.AnimationChannel;
import de.javagl.jgltf.impl.v1.AnimationChannelTarget;
import de.javagl.jgltf.impl.v1.AnimationSampler;
import de.javagl.jgltf.impl.v1.Buffer;
import de.javagl.jgltf.impl.v1.BufferView;
import de.javagl.jgltf.impl.v1.Camera;
import de.javagl.jgltf.impl.v1.CameraOrthographic;
import de.javagl.jgltf.impl.v1.CameraPerspective;
import de.javagl.jgltf.impl.v1.GlTF;
import de.javagl.jgltf.impl.v1.GlTFChildOfRootProperty;
import de.javagl.jgltf.impl.v1.GlTFProperty;
import de.javagl.jgltf.impl.v1.Image;
import de.javagl.jgltf.impl.v1.Material;
import de.javagl.jgltf.impl.v1.Mesh;
import de.javagl.jgltf.impl.v1.MeshPrimitive;
import de.javagl.jgltf.impl.v1.Node;
import de.javagl.jgltf.impl.v1.Program;
import de.javagl.jgltf.impl.v1.Sampler;
import de.javagl.jgltf.impl.v1.Scene;
import de.javagl.jgltf.impl.v1.Shader;
import de.javagl.jgltf.impl.v1.Skin;
import de.javagl.jgltf.impl.v1.Technique;
import de.javagl.jgltf.impl.v1.TechniqueParameters;
import de.javagl.jgltf.impl.v1.TechniqueStates;
import de.javagl.jgltf.impl.v1.TechniqueStatesFunctions;
import de.javagl.jgltf.impl.v1.Texture;
import de.javagl.jgltf.model.AccessorDatas;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.Accessors;
import de.javagl.jgltf.model.AnimationModel;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.CameraModel;
import de.javagl.jgltf.model.ElementType;
import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.MeshModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.SkinModel;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.gl.ShaderModel;
import de.javagl.jgltf.model.gl.TechniqueModel;
import de.javagl.jgltf.model.gl.TechniqueParametersModel;
import de.javagl.jgltf.model.gl.impl.DefaultProgramModel;
import de.javagl.jgltf.model.gl.impl.DefaultShaderModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueParametersModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueStatesFunctionsModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueStatesModel;
import de.javagl.jgltf.model.impl.AbstractModelElement;
import de.javagl.jgltf.model.impl.AbstractNamedModelElement;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.impl.DefaultAnimationModel;
import de.javagl.jgltf.model.impl.DefaultBufferModel;
import de.javagl.jgltf.model.impl.DefaultBufferViewModel;
import de.javagl.jgltf.model.impl.DefaultCameraModel;
import de.javagl.jgltf.model.impl.DefaultCameraOrthographicModel;
import de.javagl.jgltf.model.impl.DefaultCameraPerspectiveModel;
import de.javagl.jgltf.model.impl.DefaultImageModel;
import de.javagl.jgltf.model.impl.DefaultMeshModel;
import de.javagl.jgltf.model.impl.DefaultMeshPrimitiveModel;
import de.javagl.jgltf.model.impl.DefaultNodeModel;
import de.javagl.jgltf.model.impl.DefaultSceneModel;
import de.javagl.jgltf.model.impl.DefaultSkinModel;
import de.javagl.jgltf.model.impl.DefaultTextureModel;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.GltfAsset;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.io.v1.GltfAssetV1;
import de.javagl.jgltf.model.v1.BinaryGltfV1;
import de.javagl.jgltf.model.v1.GltfModelV1;
import de.javagl.jgltf.model.v1.IndexMappingSet;
import de.javagl.jgltf.model.v1.IndexMappingSets;
import de.javagl.jgltf.model.v1.MaterialModelV1;
import de.javagl.jgltf.model.v1.gl.DefaultModels;
import de.javagl.jgltf.model.v1.gl.GltfDefaults;
import de.javagl.jgltf.model.v1.gl.TechniqueStatesFunctionsModels;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.logging.Logger;

class GltfModelCreatorV1 {
    private static final Logger logger = Logger.getLogger(GltfModelCreatorV1.class.getName());
    private final IndexMappingSet indexMappingSet;
    private final GltfAsset gltfAsset;
    private final GlTF gltf;
    private final GltfModelV1 gltfModel;

    GltfModelCreatorV1(GltfAssetV1 gltfAsset, GltfModelV1 gltfModel) {
        this.gltfAsset = Objects.requireNonNull(gltfAsset, "The gltfAsset may not be null");
        this.gltf = gltfAsset.getGltf();
        this.gltfModel = Objects.requireNonNull(gltfModel, "The gltfModel may not be null");
        this.indexMappingSet = IndexMappingSets.create(gltfAsset.getGltf());
    }

    void create() {
        GltfModelCreatorV1.transferGltfPropertyElements((GlTFProperty)this.gltf, this.gltfModel);
        this.createAccessorModels();
        this.createAnimationModels();
        this.createBufferModels();
        this.createBufferViewModels();
        this.createCameraModels();
        this.createImageModels();
        this.createMaterialModels();
        this.createMeshModels();
        this.createNodeModels();
        this.createSceneModels();
        this.createSkinModels();
        this.createTextureModels();
        this.createShaderModels();
        this.createProgramModels();
        this.createTechniqueModels();
        this.initBufferModels();
        this.initBufferViewModels();
        this.initAccessorModels();
        this.assignBufferViewByteStrides();
        this.initAnimationModels();
        this.initImageModels();
        this.initTechniqueModels();
        this.initMaterialModels();
        this.initMeshModels();
        this.initNodeModels();
        this.initSceneModels();
        this.initSkinModels();
        this.initTextureModels();
        this.initShaderModels();
        this.initProgramModels();
    }

    private void createAccessorModels() {
        Map accessors = Optionals.of(this.gltf.getAccessors());
        for (Accessor accessor : accessors.values()) {
            DefaultAccessorModel accessorModel = GltfModelCreatorV1.createAccessorModel(accessor);
            this.gltfModel.addAccessorModel(accessorModel);
        }
    }

    private static DefaultAccessorModel createAccessorModel(Accessor accessor) {
        Integer componentType = accessor.getComponentType();
        Integer byteOffset = accessor.getByteOffset();
        Integer count = accessor.getCount();
        ElementType elementType = ElementType.forString(accessor.getType());
        Integer byteStride = accessor.getByteStride();
        if (byteStride == null) {
            byteStride = elementType.getNumComponents() * Accessors.getNumBytesForAccessorComponentType(componentType);
        }
        DefaultAccessorModel accessorModel = new DefaultAccessorModel(componentType, count, elementType);
        accessorModel.setByteOffset(byteOffset);
        accessorModel.setByteStride(byteStride);
        return accessorModel;
    }

    private void createAnimationModels() {
        Map animations = Optionals.of(this.gltf.getAnimations());
        for (int i = 0; i < animations.size(); ++i) {
            this.gltfModel.addAnimationModel(new DefaultAnimationModel());
        }
    }

    private void createBufferModels() {
        Map buffers = Optionals.of(this.gltf.getBuffers());
        for (Buffer buffer : buffers.values()) {
            DefaultBufferModel bufferModel = new DefaultBufferModel();
            bufferModel.setUri(buffer.getUri());
            this.gltfModel.addBufferModel(bufferModel);
        }
    }

    private void createBufferViewModels() {
        Map bufferViews = Optionals.of(this.gltf.getBufferViews());
        for (BufferView bufferView : bufferViews.values()) {
            DefaultBufferViewModel bufferViewModel = GltfModelCreatorV1.createBufferViewModel(bufferView);
            this.gltfModel.addBufferViewModel(bufferViewModel);
        }
    }

    private void createCameraModels() {
        Map cameras = Optionals.of(this.gltf.getCameras());
        for (Camera camera : cameras.values()) {
            DefaultCameraModel cameraModel;
            String type = camera.getType();
            if ("perspective".equals(type)) {
                CameraPerspective cameraPerspective = camera.getPerspective();
                DefaultCameraPerspectiveModel cameraPerspectiveModel = new DefaultCameraPerspectiveModel();
                cameraPerspectiveModel.setAspectRatio(cameraPerspective.getAspectRatio());
                cameraPerspectiveModel.setYfov(cameraPerspective.getYfov());
                cameraPerspectiveModel.setZfar(cameraPerspective.getZfar());
                cameraPerspectiveModel.setZnear(cameraPerspective.getZnear());
                cameraModel = new DefaultCameraModel();
                cameraModel.setCameraPerspectiveModel(cameraPerspectiveModel);
                this.gltfModel.addCameraModel(cameraModel);
                continue;
            }
            if ("orthographic".equals(type)) {
                CameraOrthographic cameraOrthographic = camera.getOrthographic();
                DefaultCameraOrthographicModel cameraOrthographicModel = new DefaultCameraOrthographicModel();
                cameraOrthographicModel.setXmag(cameraOrthographic.getXmag());
                cameraOrthographicModel.setYmag(cameraOrthographic.getYmag());
                cameraOrthographicModel.setZfar(cameraOrthographic.getZfar());
                cameraOrthographicModel.setZnear(cameraOrthographic.getZnear());
                cameraModel = new DefaultCameraModel();
                cameraModel.setCameraOrthographicModel(cameraOrthographicModel);
                this.gltfModel.addCameraModel(cameraModel);
                continue;
            }
            logger.severe("Invalid camera type: " + type);
        }
    }

    private static DefaultBufferViewModel createBufferViewModel(BufferView bufferView) {
        int byteOffset = bufferView.getByteOffset();
        Integer byteLength = bufferView.getByteLength();
        if (byteLength == null) {
            logger.warning("No byteLength found in BufferView");
            byteLength = 0;
        }
        Integer target = bufferView.getTarget();
        DefaultBufferViewModel bufferViewModel = new DefaultBufferViewModel(target);
        bufferViewModel.setByteOffset(byteOffset);
        bufferViewModel.setByteLength(byteLength);
        return bufferViewModel;
    }

    private void createImageModels() {
        Map images = Optionals.of(this.gltf.getImages());
        for (Image image : images.values()) {
            DefaultImageModel imageModel = new DefaultImageModel();
            String uri = image.getUri();
            imageModel.setUri(uri);
            this.gltfModel.addImageModel(imageModel);
        }
    }

    private void createMaterialModels() {
        Map materials = Optionals.of(this.gltf.getMaterials());
        for (int i = 0; i < materials.size(); ++i) {
            this.gltfModel.addMaterialModel(new MaterialModelV1());
        }
    }

    private void createMeshModels() {
        Map meshes = Optionals.of(this.gltf.getMeshes());
        for (int i = 0; i < meshes.size(); ++i) {
            this.gltfModel.addMeshModel(new DefaultMeshModel());
        }
    }

    private void createNodeModels() {
        Map nodes = Optionals.of(this.gltf.getNodes());
        for (int i = 0; i < nodes.size(); ++i) {
            this.gltfModel.addNodeModel(new DefaultNodeModel());
        }
    }

    private void createSceneModels() {
        Map scenes = Optionals.of(this.gltf.getScenes());
        for (int i = 0; i < scenes.size(); ++i) {
            this.gltfModel.addSceneModel(new DefaultSceneModel());
        }
    }

    private void createSkinModels() {
        Map skins = Optionals.of(this.gltf.getSkins());
        for (Map.Entry entry : skins.entrySet()) {
            Skin skin = (Skin)entry.getValue();
            float[] bindShapeMatrix = skin.getBindShapeMatrix();
            DefaultSkinModel skinModel = new DefaultSkinModel();
            skinModel.setBindShapeMatrix(bindShapeMatrix);
            this.gltfModel.addSkinModel(skinModel);
        }
    }

    private void createTextureModels() {
        Map textures = Optionals.of(this.gltf.getTextures());
        Map samplers = Optionals.of(this.gltf.getSamplers());
        for (Map.Entry entry : textures.entrySet()) {
            Texture texture = (Texture)entry.getValue();
            String samplerId = texture.getSampler();
            Sampler sampler = (Sampler)samplers.get(samplerId);
            int magFilter = Optionals.of(sampler.getMagFilter(), sampler.defaultMagFilter());
            int minFilter = Optionals.of(sampler.getMinFilter(), sampler.defaultMinFilter());
            int wrapS = Optionals.of(sampler.getWrapS(), sampler.defaultWrapS());
            int wrapT = Optionals.of(sampler.getWrapT(), sampler.defaultWrapT());
            DefaultTextureModel textureModel = new DefaultTextureModel();
            textureModel.setMagFilter(magFilter);
            textureModel.setMinFilter(minFilter);
            textureModel.setWrapS(wrapS);
            textureModel.setWrapT(wrapT);
            this.gltfModel.addTextureModel(textureModel);
        }
    }

    private void createShaderModels() {
        Map shaders = Optionals.of(this.gltf.getShaders());
        for (Map.Entry entry : shaders.entrySet()) {
            Shader shader = (Shader)entry.getValue();
            Integer type = shader.getType();
            ShaderModel.ShaderType shaderType = null;
            shaderType = type == 35633 ? ShaderModel.ShaderType.VERTEX_SHADER : ShaderModel.ShaderType.FRAGMENT_SHADER;
            DefaultShaderModel shaderModel = new DefaultShaderModel(shader.getUri(), shaderType);
            this.gltfModel.addShaderModel(shaderModel);
        }
    }

    private void createProgramModels() {
        Map programs = Optionals.of(this.gltf.getPrograms());
        for (int i = 0; i < programs.size(); ++i) {
            this.gltfModel.addProgramModel(new DefaultProgramModel());
        }
    }

    private void createTechniqueModels() {
        Map techniques = Optionals.of(this.gltf.getTechniques());
        for (int i = 0; i < techniques.size(); ++i) {
            this.gltfModel.addTechniqueModel(new DefaultTechniqueModel());
        }
    }

    private void initAccessorModels() {
        Map accessors = Optionals.of(this.gltf.getAccessors());
        for (Map.Entry entry : accessors.entrySet()) {
            String accessorId = (String)entry.getKey();
            Accessor accessor = (Accessor)entry.getValue();
            String bufferViewId = accessor.getBufferView();
            BufferViewModel bufferViewModel = this.get("bufferViews", bufferViewId, this.gltfModel::getBufferViewModel);
            DefaultAccessorModel accessorModel = this.get("accessors", accessorId, this.gltfModel::getAccessorModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)accessor, accessorModel);
            accessorModel.setBufferViewModel(bufferViewModel);
            accessorModel.setAccessorData(AccessorDatas.create(accessorModel));
        }
    }

    private void initAnimationModels() {
        Map animations = Optionals.of(this.gltf.getAnimations());
        for (Map.Entry entry : animations.entrySet()) {
            String animationId = (String)entry.getKey();
            Animation animation = (Animation)entry.getValue();
            DefaultAnimationModel animationModel = this.get("animations", animationId, this.gltfModel::getAnimationModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)animation, animationModel);
            List<AnimationChannel> channels = Optionals.of(animation.getChannels());
            for (AnimationChannel animationChannel : channels) {
                AnimationModel.Channel channel = this.createChannel(animation, animationChannel);
                animationModel.addChannel(channel);
            }
        }
    }

    private void initImageModels() {
        Map images = Optionals.of(this.gltf.getImages());
        for (Map.Entry entry : images.entrySet()) {
            String imageId = (String)entry.getKey();
            Image image = (Image)entry.getValue();
            DefaultImageModel imageModel = this.get("images", imageId, this.gltfModel::getImageModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)image, imageModel);
            if (BinaryGltfV1.hasBinaryGltfExtension((GlTFProperty)image)) {
                String bufferViewId = BinaryGltfV1.getBinaryGltfBufferViewId((GlTFProperty)image);
                BufferViewModel bufferViewModel = this.get("bufferViews", bufferViewId, this.gltfModel::getBufferViewModel);
                imageModel.setBufferViewModel(bufferViewModel);
                continue;
            }
            String uri = image.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer imageData = Buffers.create(data);
                imageModel.setImageData(imageData);
                continue;
            }
            ByteBuffer imageData = this.gltfAsset.getReferenceData(uri);
            imageModel.setImageData(imageData);
        }
    }

    private AnimationModel.Channel createChannel(Animation animation, AnimationChannel animationChannel) {
        String samplerId;
        Map samplers;
        AnimationSampler animationSampler;
        String inputParameterId;
        Map parameters = Optionals.of(animation.getParameters());
        String inputAccessorId = (String)parameters.get(inputParameterId = (animationSampler = (AnimationSampler)(samplers = Optionals.of(animation.getSamplers())).get(samplerId = animationChannel.getSampler())).getInput());
        if (inputAccessorId == null) {
            logger.warning("Assuming " + inputParameterId + " to be an accessor ID");
            inputAccessorId = inputParameterId;
        }
        AccessorModel inputAccessorModel = this.get("accessors", inputAccessorId, this.gltfModel::getAccessorModel);
        String outputParameterId = animationSampler.getOutput();
        String outputAccessorId = (String)parameters.get(outputParameterId);
        if (outputAccessorId == null) {
            logger.warning("Assuming " + outputParameterId + " to be an accessor ID");
            outputAccessorId = outputParameterId;
        }
        AccessorModel outputAccessorModel = this.get("accessors", outputAccessorId, this.gltfModel::getAccessorModel);
        String interpolationString = animationSampler.getInterpolation();
        AnimationModel.Interpolation interpolation = interpolationString == null ? AnimationModel.Interpolation.LINEAR : AnimationModel.Interpolation.valueOf(interpolationString);
        DefaultAnimationModel.DefaultSampler sampler = new DefaultAnimationModel.DefaultSampler(inputAccessorModel, interpolation, outputAccessorModel);
        AnimationChannelTarget animationChannelTarget = animationChannel.getTarget();
        String nodeId = animationChannelTarget.getId();
        String path = animationChannelTarget.getPath();
        NodeModel nodeModel = this.get("nodes", nodeId, this.gltfModel::getNodeModel);
        DefaultAnimationModel.DefaultChannel channel = new DefaultAnimationModel.DefaultChannel(sampler, nodeModel, path);
        return channel;
    }

    private void initBufferModels() {
        ByteBuffer binaryData = null;
        ByteBuffer b = this.gltfAsset.getBinaryData();
        if (b != null && b.capacity() > 0) {
            binaryData = b;
        }
        Map buffers = Optionals.of(this.gltf.getBuffers());
        for (Map.Entry entry : buffers.entrySet()) {
            String bufferId = (String)entry.getKey();
            Buffer buffer = (Buffer)entry.getValue();
            DefaultBufferModel bufferModel = this.get("buffers", bufferId, this.gltfModel::getBufferModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)buffer, bufferModel);
            if (BinaryGltfV1.isBinaryGltfBufferId(bufferId)) {
                if (binaryData == null) {
                    logger.severe("The glTF contains a buffer with the binary buffer ID, but no binary data has been given");
                    continue;
                }
                bufferModel.setBufferData(binaryData);
                continue;
            }
            String uri = buffer.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer bufferData = Buffers.create(data);
                bufferModel.setBufferData(bufferData);
                continue;
            }
            ByteBuffer bufferData = this.gltfAsset.getReferenceData(uri);
            bufferModel.setBufferData(bufferData);
        }
    }

    private void initBufferViewModels() {
        Map bufferViews = Optionals.of(this.gltf.getBufferViews());
        for (Map.Entry entry : bufferViews.entrySet()) {
            String bufferViewId = (String)entry.getKey();
            BufferView bufferView = (BufferView)entry.getValue();
            String bufferId = bufferView.getBuffer();
            BufferModel bufferModel = this.get("buffers", bufferId, this.gltfModel::getBufferModel);
            DefaultBufferViewModel bufferViewModel = this.get("bufferViews", bufferViewId, this.gltfModel::getBufferViewModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)bufferView, bufferViewModel);
            bufferViewModel.setBufferModel(bufferModel);
        }
    }

    private List<DefaultAccessorModel> computeAccessorModelsOf(BufferViewModel bufferViewModel) {
        ArrayList<DefaultAccessorModel> result = new ArrayList<DefaultAccessorModel>();
        int n = this.gltfModel.getAccessorModels().size();
        for (int i = 0; i < n; ++i) {
            DefaultAccessorModel accessorModel = this.gltfModel.getAccessorModel(i);
            BufferViewModel b = accessorModel.getBufferViewModel();
            if (!bufferViewModel.equals(b)) continue;
            result.add(accessorModel);
        }
        return result;
    }

    private static int computeCommonByteStride(Iterable<? extends AccessorModel> accessorModels) {
        int commonByteStride = -1;
        for (AccessorModel accessorModel : accessorModels) {
            int byteStride = accessorModel.getByteStride();
            if (commonByteStride == -1) {
                commonByteStride = byteStride;
                continue;
            }
            if (commonByteStride == byteStride) continue;
            logger.warning("The accessor models do not have the same byte stride: " + commonByteStride + " and " + byteStride);
        }
        return commonByteStride;
    }

    private void assignBufferViewByteStrides() {
        int n = this.gltfModel.getBufferModels().size();
        for (int i = 0; i < n; ++i) {
            DefaultBufferViewModel bufferViewModel = this.gltfModel.getBufferViewModel(i);
            List<DefaultAccessorModel> accessorModelsOfBufferView = this.computeAccessorModelsOf(bufferViewModel);
            if (accessorModelsOfBufferView.size() <= 1) continue;
            int byteStride = GltfModelCreatorV1.computeCommonByteStride(accessorModelsOfBufferView);
            bufferViewModel.setByteStride(byteStride);
        }
    }

    private void initMeshModels() {
        Map meshes = Optionals.of(this.gltf.getMeshes());
        for (Map.Entry entry : meshes.entrySet()) {
            String meshId = (String)entry.getKey();
            Mesh mesh = (Mesh)entry.getValue();
            List<MeshPrimitive> primitives = Optionals.of(mesh.getPrimitives());
            DefaultMeshModel meshModel = this.get("meshes", meshId, this.gltfModel::getMeshModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)mesh, meshModel);
            for (MeshPrimitive meshPrimitive : primitives) {
                DefaultMeshPrimitiveModel meshPrimitiveModel = this.createMeshPrimitiveModel(meshPrimitive);
                meshModel.addMeshPrimitiveModel(meshPrimitiveModel);
            }
        }
    }

    private DefaultMeshPrimitiveModel createMeshPrimitiveModel(MeshPrimitive meshPrimitive) {
        Integer mode = Optionals.of(meshPrimitive.getMode(), meshPrimitive.defaultMode());
        DefaultMeshPrimitiveModel meshPrimitiveModel = new DefaultMeshPrimitiveModel(mode);
        GltfModelCreatorV1.transferGltfPropertyElements((GlTFProperty)meshPrimitive, meshPrimitiveModel);
        String indicesId = meshPrimitive.getIndices();
        if (indicesId != null) {
            AccessorModel indices = this.get("accessors", indicesId, this.gltfModel::getAccessorModel);
            meshPrimitiveModel.setIndices(indices);
        }
        Map attributes = Optionals.of(meshPrimitive.getAttributes());
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            String attributeId = (String)entry.getValue();
            AccessorModel attribute = this.get("accessors", attributeId, this.gltfModel::getAccessorModel);
            meshPrimitiveModel.putAttribute(attributeName, attribute);
        }
        String materialId = meshPrimitive.getMaterial();
        if (materialId == null || GltfDefaults.isDefaultMaterialId(materialId)) {
            meshPrimitiveModel.setMaterialModel(DefaultModels.getDefaultMaterialModel());
        } else {
            MaterialModel materialModel = this.get("materials", materialId, this.gltfModel::getMaterialModel);
            meshPrimitiveModel.setMaterialModel(materialModel);
        }
        return meshPrimitiveModel;
    }

    private void initNodeModels() {
        Map nodes = Optionals.of(this.gltf.getNodes());
        for (Map.Entry entry : nodes.entrySet()) {
            String cameraId;
            Object childId22;
            String nodeId = (String)entry.getKey();
            Node node = (Node)entry.getValue();
            DefaultNodeModel nodeModel = this.get("nodes", nodeId, this.gltfModel::getNodeModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)node, nodeModel);
            List<Object> childIds = Optionals.of(node.getChildren());
            for (Object childId22 : childIds) {
                DefaultNodeModel child = this.get("nodes", (String)childId22, this.gltfModel::getNodeModel);
                nodeModel.addChild(child);
            }
            List meshIds = Optionals.of(node.getMeshes());
            childId22 = meshIds.iterator();
            while (childId22.hasNext()) {
                String meshId = (String)childId22.next();
                MeshModel meshModel = this.get("meshes", meshId, this.gltfModel::getMeshModel);
                nodeModel.addMeshModel(meshModel);
            }
            String skinId = node.getSkin();
            if (skinId != null) {
                SkinModel skinModel = this.get("skins", skinId, this.gltfModel::getSkinModel);
                nodeModel.setSkinModel(skinModel);
            }
            if ((cameraId = node.getCamera()) != null) {
                CameraModel cameraModel = this.get("cameras", cameraId, this.gltfModel::getCameraModel);
                nodeModel.setCameraModel(cameraModel);
            }
            float[] matrix = node.getMatrix();
            float[] translation = node.getTranslation();
            float[] rotation = node.getRotation();
            float[] scale = node.getScale();
            nodeModel.setMatrix(Optionals.clone(matrix));
            nodeModel.setTranslation(Optionals.clone(translation));
            nodeModel.setRotation(Optionals.clone(rotation));
            nodeModel.setScale(Optionals.clone(scale));
        }
    }

    private void initSceneModels() {
        Map scenes = Optionals.of(this.gltf.getScenes());
        for (Map.Entry entry : scenes.entrySet()) {
            String sceneId = (String)entry.getKey();
            Scene scene = (Scene)entry.getValue();
            DefaultSceneModel sceneModel = this.get("scenes", sceneId, this.gltfModel::getSceneModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)scene, sceneModel);
            List<String> nodes = Optionals.of(scene.getNodes());
            for (String nodeId : nodes) {
                NodeModel nodeModel = this.get("nodes", nodeId, this.gltfModel::getNodeModel);
                sceneModel.addNode(nodeModel);
            }
        }
    }

    private static Map<String, String> computeJointNameToNodeIdMap(GlTF gltf) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Map nodes = Optionals.of(gltf.getNodes());
        for (Map.Entry entry : nodes.entrySet()) {
            String oldNodeId;
            String nodeId = (String)entry.getKey();
            Node node = (Node)entry.getValue();
            if (node.getJointName() == null || (oldNodeId = map.put(node.getJointName(), nodeId)) == null) continue;
            logger.warning("Joint name " + node.getJointName() + " is mapped to nodes with IDs " + nodeId + " and " + oldNodeId);
        }
        return map;
    }

    private void initSkinModels() {
        Map<String, String> jointNameToNodeIdMap = GltfModelCreatorV1.computeJointNameToNodeIdMap(this.gltf);
        Map skins = Optionals.of(this.gltf.getSkins());
        for (Map.Entry entry : skins.entrySet()) {
            String skinId = (String)entry.getKey();
            Skin skin = (Skin)entry.getValue();
            DefaultSkinModel skinModel = this.get("skins", skinId, this.gltfModel::getSkinModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)skin, skinModel);
            List jointNames = skin.getJointNames();
            for (String jointName : jointNames) {
                String nodeId = jointNameToNodeIdMap.get(jointName);
                NodeModel nodeModel = this.get("nodes", nodeId, this.gltfModel::getNodeModel);
                skinModel.addJoint(nodeModel);
            }
            String inverseBindMatricesId = skin.getInverseBindMatrices();
            AccessorModel inverseBindMatrices = this.get("accessors", inverseBindMatricesId, this.gltfModel::getAccessorModel);
            skinModel.setInverseBindMatrices(inverseBindMatrices);
        }
    }

    private void initTextureModels() {
        Map textures = Optionals.of(this.gltf.getTextures());
        for (Map.Entry entry : textures.entrySet()) {
            String textureId = (String)entry.getKey();
            Texture texture = (Texture)entry.getValue();
            DefaultTextureModel textureModel = this.get("textures", textureId, this.gltfModel::getTextureModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)texture, textureModel);
            String imageId = texture.getSource();
            DefaultImageModel imageModel = this.get("images", imageId, this.gltfModel::getImageModel);
            textureModel.setImageModel(imageModel);
        }
    }

    private void initShaderModels() {
        Map shaders = Optionals.of(this.gltf.getShaders());
        for (Map.Entry entry : shaders.entrySet()) {
            String shaderId = (String)entry.getKey();
            Shader shader = (Shader)entry.getValue();
            DefaultShaderModel shaderModel = this.get("shaders", shaderId, this.gltfModel::getShaderModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)shader, shaderModel);
            if (BinaryGltfV1.hasBinaryGltfExtension((GlTFProperty)shader)) {
                String bufferViewId = BinaryGltfV1.getBinaryGltfBufferViewId((GlTFProperty)shader);
                BufferViewModel bufferViewModel = this.get("bufferViews", bufferViewId, this.gltfModel::getBufferViewModel);
                shaderModel.setShaderData(bufferViewModel.getBufferViewData());
                continue;
            }
            String uri = shader.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer shaderData = Buffers.create(data);
                shaderModel.setShaderData(shaderData);
                continue;
            }
            ByteBuffer shaderData = this.gltfAsset.getReferenceData(uri);
            shaderModel.setShaderData(shaderData);
        }
    }

    void initProgramModels() {
        Map programs = Optionals.of(this.gltf.getPrograms());
        for (Map.Entry entry : programs.entrySet()) {
            String programId = (String)entry.getKey();
            Program program = (Program)entry.getValue();
            DefaultProgramModel programModel = this.get("programs", programId, this.gltfModel::getProgramModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)program, programModel);
            String vertexShaderId = program.getVertexShader();
            DefaultShaderModel vertexShaderModel = this.get("shaders", vertexShaderId, this.gltfModel::getShaderModel);
            programModel.setVertexShaderModel(vertexShaderModel);
            String fragmentShaderId = program.getFragmentShader();
            DefaultShaderModel fragmentShaderModel = this.get("shaders", fragmentShaderId, this.gltfModel::getShaderModel);
            programModel.setFragmentShaderModel(fragmentShaderModel);
            List<String> attributes = Optionals.of(program.getAttributes());
            for (String attribute : attributes) {
                programModel.addAttribute(attribute);
            }
        }
    }

    private static void addParameters(Technique technique, DefaultTechniqueModel techniqueModel, Function<? super String, ? extends NodeModel> nodeLookup) {
        Map parameters = Optionals.of(technique.getParameters());
        for (Map.Entry entry : parameters.entrySet()) {
            String parameterName = (String)entry.getKey();
            TechniqueParameters parameter = (TechniqueParameters)entry.getValue();
            int type = parameter.getType();
            int count = Optionals.of(parameter.getCount(), 1);
            String semantic = parameter.getSemantic();
            Object value = parameter.getValue();
            String nodeId = parameter.getNode();
            NodeModel nodeModel = null;
            if (nodeId != null) {
                if (nodeLookup == null) {
                    logger.severe("No lookup function found for the nodes");
                } else {
                    nodeModel = nodeLookup.apply(nodeId);
                }
            }
            DefaultTechniqueParametersModel techniqueParametersModel = new DefaultTechniqueParametersModel(type, count, semantic, value, nodeModel);
            techniqueModel.addParameter(parameterName, techniqueParametersModel);
        }
    }

    private static void addAttributes(Technique technique, DefaultTechniqueModel techniqueModel) {
        Map attributes = Optionals.of(technique.getAttributes());
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            String parameterName = (String)entry.getValue();
            techniqueModel.addAttribute(attributeName, parameterName);
        }
    }

    private static void addUniforms(Technique technique, DefaultTechniqueModel techniqueModel) {
        Map uniforms = Optionals.of(technique.getUniforms());
        for (Map.Entry entry : uniforms.entrySet()) {
            String uniformName = (String)entry.getKey();
            String parameterName = (String)entry.getValue();
            techniqueModel.addUniform(uniformName, parameterName);
        }
    }

    private void initTechniqueModels() {
        Map techniques = Optionals.of(this.gltf.getTechniques());
        for (Map.Entry entry : techniques.entrySet()) {
            String techniqueId = (String)entry.getKey();
            Technique technique = (Technique)entry.getValue();
            DefaultTechniqueModel techniqueModel = this.get("techniques", techniqueId, this.gltfModel::getTechniqueModel);
            String programId = technique.getProgram();
            DefaultProgramModel programModel = this.get("programs", programId, this.gltfModel::getProgramModel);
            techniqueModel.setProgramModel(programModel);
            Function<String, NodeModel> nodeLookup = nodeId -> this.get("nodes", (String)nodeId, this.gltfModel::getNodeModel);
            GltfModelCreatorV1.initTechniqueModel(techniqueModel, technique, nodeLookup);
        }
    }

    public static void initTechniqueModel(DefaultTechniqueModel techniqueModel, Technique technique, Function<? super String, ? extends NodeModel> nodeLookup) {
        GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)technique, techniqueModel);
        GltfModelCreatorV1.addParameters(technique, techniqueModel, nodeLookup);
        GltfModelCreatorV1.addAttributes(technique, techniqueModel);
        GltfModelCreatorV1.addUniforms(technique, techniqueModel);
        ArrayList<Integer> enableModel = null;
        DefaultTechniqueStatesFunctionsModel techniqueStatesFunctionsModel = null;
        TechniqueStates states = technique.getStates();
        if (states != null) {
            TechniqueStatesFunctions functions;
            List enable = states.getEnable();
            if (enable != null) {
                enableModel = new ArrayList<Integer>(enable);
            }
            if ((functions = states.getFunctions()) != null) {
                techniqueStatesFunctionsModel = TechniqueStatesFunctionsModels.create(functions);
            }
            DefaultTechniqueStatesModel techniqueStatesModel = new DefaultTechniqueStatesModel(enableModel, techniqueStatesFunctionsModel);
            techniqueModel.setTechniqueStatesModel(techniqueStatesModel);
        }
    }

    private void initMaterialModels() {
        Map materials = Optionals.of(this.gltf.getMaterials());
        for (Map.Entry entry : materials.entrySet()) {
            String materialId = (String)entry.getKey();
            Material material = (Material)entry.getValue();
            MaterialModelV1 materialModel = (MaterialModelV1)this.get("materials", materialId, this.gltfModel::getMaterialModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements((GlTFChildOfRootProperty)material, materialModel);
            String techniqueId = material.getTechnique();
            TechniqueModel techniqueModel = techniqueId == null || GltfDefaults.isDefaultTechniqueId(techniqueId) ? DefaultModels.getDefaultTechniqueModel() : (TechniqueModel)this.get("techniques", techniqueId, this.gltfModel::getTechniqueModel);
            materialModel.setTechniqueModel(techniqueModel);
            LinkedHashMap<String, Object> modelValues = new LinkedHashMap<String, Object>();
            Map values = Optionals.of(material.getValues());
            for (Map.Entry valueEntry : values.entrySet()) {
                String parameterName = (String)valueEntry.getKey();
                TechniqueParametersModel techniqueParametersModel = techniqueModel.getParameters().get(parameterName);
                if (techniqueParametersModel != null && techniqueParametersModel.getType() == 35678) {
                    TextureModel textureModel = null;
                    Object value = valueEntry.getValue();
                    if (value != null) {
                        String textureId = String.valueOf(value);
                        textureModel = this.get("textures", textureId, this.gltfModel::getTextureModel);
                    }
                    modelValues.put(parameterName, textureModel);
                    continue;
                }
                modelValues.put(parameterName, valueEntry.getValue());
            }
            materialModel.setValues(modelValues);
        }
    }

    private static void transferGltfPropertyElements(GlTFProperty property, AbstractModelElement modelElement) {
        modelElement.setExtensions(property.getExtensions());
        modelElement.setExtras(property.getExtras());
    }

    private static void transferGltfChildOfRootPropertyElements(GlTFChildOfRootProperty property, AbstractNamedModelElement modelElement) {
        modelElement.setName(property.getName());
        GltfModelCreatorV1.transferGltfPropertyElements((GlTFProperty)property, modelElement);
    }

    private <T> T get(String name, String id, IntFunction<? extends T> getter) {
        Integer index = this.indexMappingSet.getIndex(name, id);
        if (index == null) {
            logger.severe("No index found for " + name + " ID " + id);
            return null;
        }
        T element = getter.apply(index);
        return element;
    }
}

