/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io.v2;

import de.javagl.jgltf.impl.v2.Buffer;
import de.javagl.jgltf.impl.v2.BufferView;
import de.javagl.jgltf.impl.v2.GlTF;
import de.javagl.jgltf.impl.v2.Image;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.GltfModel;
import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.MimeTypes;
import de.javagl.jgltf.model.io.v2.GltfAssetV2;
import de.javagl.jgltf.model.io.v2.GltfUtilsV2;
import de.javagl.jgltf.model.v2.GltfCreatorV2;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class BinaryAssetCreatorV2 {
    private static final Logger logger = Logger.getLogger(BinaryAssetCreatorV2.class.getName());

    BinaryAssetCreatorV2() {
    }

    GltfAssetV2 create(GltfModel gltfModel) {
        GlTF outputGltf = GltfCreatorV2.create(gltfModel);
        int binaryGltfBufferSize = BinaryAssetCreatorV2.computeBinaryGltfBufferSize(gltfModel);
        ByteBuffer binaryGltfByteBuffer = Buffers.create(binaryGltfBufferSize);
        Buffer binaryGltfBuffer = new Buffer();
        binaryGltfBuffer.setByteLength(Integer.valueOf(binaryGltfBufferSize));
        outputGltf.setBuffers(Collections.singletonList(binaryGltfBuffer));
        List oldImages = BinaryAssetCreatorV2.copy(outputGltf.getImages());
        List bufferDatas = gltfModel.getBufferModels().stream().map(BufferModel::getBufferData).collect(Collectors.toList());
        Map<Integer, Integer> bufferOffsets = BinaryAssetCreatorV2.concatBuffers(bufferDatas, binaryGltfByteBuffer);
        List imageDatas = gltfModel.getImageModels().stream().map(ImageModel::getImageData).collect(Collectors.toList());
        Map<Integer, Integer> imageOffsets = BinaryAssetCreatorV2.concatBuffers(imageDatas, binaryGltfByteBuffer);
        binaryGltfByteBuffer.position(0);
        List oldBufferViews = BinaryAssetCreatorV2.copy(outputGltf.getBufferViews());
        ArrayList<BufferView> newBufferViews = new ArrayList<BufferView>();
        for (int i = 0; i < oldBufferViews.size(); ++i) {
            BufferView oldBufferView = (BufferView)oldBufferViews.get(i);
            BufferView newBufferView = GltfUtilsV2.copy(oldBufferView);
            newBufferView.setBuffer(Integer.valueOf(0));
            Integer oldBufferIndex = oldBufferView.getBuffer();
            int oldByteOffset = Optionals.of(oldBufferView.getByteOffset(), 0);
            int bufferOffset = bufferOffsets.get(oldBufferIndex);
            int newByteOffset = oldByteOffset + bufferOffset;
            newBufferView.setByteOffset(Integer.valueOf(newByteOffset));
            newBufferViews.add(newBufferView);
        }
        ArrayList<Image> newImages = new ArrayList<Image>();
        for (int i = 0; i < oldImages.size(); ++i) {
            Image oldImage = (Image)oldImages.get(i);
            Image newImage = GltfUtilsV2.copy(oldImage);
            ImageModel imageModel = gltfModel.getImageModels().get(i);
            ByteBuffer imageData = imageModel.getImageData();
            int byteLength = imageData.capacity();
            int byteOffset = imageOffsets.get(i);
            BufferView imageBufferView = new BufferView();
            imageBufferView.setBuffer(Integer.valueOf(0));
            imageBufferView.setByteOffset(Integer.valueOf(byteOffset));
            imageBufferView.setByteLength(Integer.valueOf(byteLength));
            int newBufferViewIndex = newBufferViews.size();
            newImage.setBufferView(Integer.valueOf(newBufferViewIndex));
            newImage.setUri(null);
            String imageMimeTypeString = MimeTypes.guessImageMimeTypeString(oldImage.getUri(), imageData);
            if (imageMimeTypeString == null) {
                logger.warning("Could not detect MIME type of image");
            } else {
                newImage.setMimeType(imageMimeTypeString);
            }
            newBufferViews.add(imageBufferView);
            newImages.add(newImage);
        }
        if (!oldImages.isEmpty()) {
            outputGltf.setImages(newImages);
        }
        if (!newBufferViews.isEmpty()) {
            outputGltf.setBufferViews(newBufferViews);
        }
        return new GltfAssetV2(outputGltf, binaryGltfByteBuffer);
    }

    private static int computeBinaryGltfBufferSize(GltfModel gltfModel) {
        int binaryGltfBufferSize = 0;
        for (BufferModel bufferModel : gltfModel.getBufferModels()) {
            ByteBuffer bufferData = bufferModel.getBufferData();
            binaryGltfBufferSize += bufferData.capacity();
        }
        for (ImageModel imageModel : gltfModel.getImageModels()) {
            ByteBuffer imageData = imageModel.getImageData();
            binaryGltfBufferSize += imageData.capacity();
        }
        return binaryGltfBufferSize;
    }

    private static Map<Integer, Integer> concatBuffers(List<? extends ByteBuffer> buffers, ByteBuffer targetBuffer) {
        LinkedHashMap<Integer, Integer> offsets = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < buffers.size(); ++i) {
            ByteBuffer oldByteBuffer = buffers.get(i);
            int offset = targetBuffer.position();
            offsets.put(i, offset);
            targetBuffer.put(oldByteBuffer.slice());
        }
        return offsets;
    }

    private static <T> List<T> copy(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(list);
    }
}

