/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io.v1;

import de.javagl.jgltf.impl.v1.Buffer;
import de.javagl.jgltf.impl.v1.GlTF;
import de.javagl.jgltf.impl.v1.Image;
import de.javagl.jgltf.impl.v1.Shader;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.GltfException;
import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.gl.ShaderModel;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.io.MimeTypes;
import de.javagl.jgltf.model.io.v1.GltfAssetV1;
import de.javagl.jgltf.model.io.v1.GltfUtilsV1;
import de.javagl.jgltf.model.v1.BinaryGltfV1;
import de.javagl.jgltf.model.v1.GltfCreatorV1;
import de.javagl.jgltf.model.v1.GltfModelV1;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import java.util.function.Function;

final class EmbeddedAssetCreatorV1 {
    EmbeddedAssetCreatorV1() {
    }

    GltfAssetV1 create(GltfModelV1 gltfModel) {
        GlTF outputGltf = GltfCreatorV1.create(gltfModel);
        Map bufferIdToBuffer = GltfUtilsV1.createMap(outputGltf.getBuffers(), gltfModel.getBufferModels());
        Map imageIdToImage = GltfUtilsV1.createMap(outputGltf.getImages(), gltfModel.getImageModels());
        Map shaderIdToShader = GltfUtilsV1.createMap(outputGltf.getShaders(), gltfModel.getShaderModels());
        Optionals.of(outputGltf.getBuffers()).forEach((id, value) -> EmbeddedAssetCreatorV1.convertBufferToEmbedded(gltfModel, id, value, bufferIdToBuffer::get));
        Optionals.of(outputGltf.getImages()).forEach((id, value) -> EmbeddedAssetCreatorV1.convertImageToEmbedded(gltfModel, id, value, imageIdToImage::get));
        Optionals.of(outputGltf.getShaders()).forEach((id, value) -> EmbeddedAssetCreatorV1.convertShaderToEmbedded(gltfModel, id, value, shaderIdToShader::get));
        return new GltfAssetV1(outputGltf, null);
    }

    private static void convertBufferToEmbedded(GltfModelV1 gltfModel, String id, Buffer buffer, Function<? super String, ? extends BufferModel> lookup) {
        String uriString = buffer.getUri();
        if (IO.isDataUriString(uriString)) {
            return;
        }
        BufferModel bufferModel = lookup.apply(id);
        ByteBuffer bufferData = bufferModel.getBufferData();
        byte[] data = new byte[bufferData.capacity()];
        bufferData.slice().get(data);
        String encodedData = Base64.getEncoder().encodeToString(data);
        String dataUriString = "data:application/gltf-buffer;base64," + encodedData;
        buffer.setUri(dataUriString);
    }

    private static void convertImageToEmbedded(GltfModelV1 gltfModel, String id, Image image, Function<? super String, ? extends ImageModel> lookup) {
        String uriString = image.getUri();
        if (IO.isDataUriString(uriString)) {
            return;
        }
        ImageModel imageModel = lookup.apply(id);
        ByteBuffer imageData = imageModel.getImageData();
        String uri = image.getUri();
        String imageMimeTypeString = MimeTypes.guessImageMimeTypeString(uri, imageData);
        if (imageMimeTypeString == null) {
            throw new GltfException("Could not detect MIME type of image " + id);
        }
        byte[] data = new byte[imageData.capacity()];
        imageData.slice().get(data);
        String encodedData = Base64.getEncoder().encodeToString(data);
        String dataUriString = "data:" + imageMimeTypeString + ";base64," + encodedData;
        image.removeExtensions(BinaryGltfV1.getBinaryGltfExtensionName());
        image.setUri(dataUriString);
    }

    private static void convertShaderToEmbedded(GltfModelV1 gltfModel, String id, Shader shader, Function<? super String, ? extends ShaderModel> lookup) {
        String uriString = shader.getUri();
        if (IO.isDataUriString(uriString)) {
            return;
        }
        ShaderModel shaderModel = lookup.apply(id);
        ByteBuffer shaderData = shaderModel.getShaderData();
        byte[] data = new byte[shaderData.capacity()];
        shaderData.slice().get(data);
        String encodedData = Base64.getEncoder().encodeToString(data);
        String dataUriString = "data:text/plain;base64," + encodedData;
        shader.removeExtensions(BinaryGltfV1.getBinaryGltfExtensionName());
        shader.setUri(dataUriString);
    }
}

