/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.v2;

import de.javagl.jgltf.impl.v2.Material;
import de.javagl.jgltf.impl.v2.MaterialNormalTextureInfo;
import de.javagl.jgltf.impl.v2.MaterialOcclusionTextureInfo;
import de.javagl.jgltf.impl.v2.MaterialPbrMetallicRoughness;
import de.javagl.jgltf.impl.v2.TextureInfo;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.gl.ProgramModel;
import de.javagl.jgltf.model.gl.ShaderModel;
import de.javagl.jgltf.model.gl.TechniqueModel;
import de.javagl.jgltf.model.gl.TechniqueStatesModel;
import de.javagl.jgltf.model.gl.impl.DefaultProgramModel;
import de.javagl.jgltf.model.gl.impl.DefaultShaderModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueParametersModel;
import de.javagl.jgltf.model.gl.impl.TechniqueStatesModels;
import de.javagl.jgltf.model.impl.DefaultMaterialModel;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.v2.MaterialStructure;
import de.javagl.jgltf.model.v2.gl.Materials;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class MaterialModelHandler {
    private static final Logger logger = Logger.getLogger(MaterialModelHandler.class.getName());
    private final Map<Integer, ShaderModel> vertexShaderModels = new LinkedHashMap<Integer, ShaderModel>();
    private ShaderModel fragmentShaderModel;
    private final Map<Integer, ProgramModel> programModels = new LinkedHashMap<Integer, ProgramModel>();
    private final Map<MaterialStructure, TechniqueModel> techniqueModels = new LinkedHashMap<MaterialStructure, TechniqueModel>();

    MaterialModelHandler() {
    }

    private ShaderModel obtainVertexShaderModel(int numJoints) {
        ShaderModel shaderModel = this.vertexShaderModels.get(numJoints);
        if (shaderModel == null) {
            shaderModel = this.createVertexShaderModel(numJoints);
            this.vertexShaderModels.put(numJoints, shaderModel);
        }
        return shaderModel;
    }

    private ShaderModel createVertexShaderModel(int numJoints) {
        String vertexShaderDefines = "";
        if (numJoints > 0) {
            vertexShaderDefines = vertexShaderDefines + "#define NUM_JOINTS " + numJoints + "\n";
        }
        DefaultShaderModel vertexShaderModel = MaterialModelHandler.createDefaultShaderModel("pbr.vert", "pbr" + numJoints + ".vert", ShaderModel.ShaderType.VERTEX_SHADER, vertexShaderDefines);
        return vertexShaderModel;
    }

    private ShaderModel obtainFragmentShaderModel() {
        if (this.fragmentShaderModel == null) {
            this.fragmentShaderModel = MaterialModelHandler.createDefaultShaderModel("pbr.frag", "pbr.frag", ShaderModel.ShaderType.FRAGMENT_SHADER, null);
        }
        return this.fragmentShaderModel;
    }

    private ProgramModel obtainProgramModel(int numJoints) {
        ProgramModel programModel = this.programModels.get(numJoints);
        if (programModel == null) {
            programModel = this.createProgramModel(numJoints);
            this.programModels.put(numJoints, programModel);
        }
        return programModel;
    }

    private ProgramModel createProgramModel(int numJoints) {
        ShaderModel vertexShaderModel = this.obtainVertexShaderModel(numJoints);
        ShaderModel fragmentShaderModel = this.obtainFragmentShaderModel();
        DefaultProgramModel programModel = new DefaultProgramModel();
        programModel.setVertexShaderModel(vertexShaderModel);
        programModel.setFragmentShaderModel(fragmentShaderModel);
        return programModel;
    }

    private TechniqueModel obtainTechniqueModel(MaterialStructure materialStructure) {
        TechniqueModel techniqueModel = this.techniqueModels.get(materialStructure);
        if (techniqueModel == null) {
            techniqueModel = this.createTechniqueModel(materialStructure);
            this.techniqueModels.put(materialStructure, techniqueModel);
        }
        return techniqueModel;
    }

    private TechniqueModel createTechniqueModel(MaterialStructure materialStructure) {
        ProgramModel programModel = this.obtainProgramModel(materialStructure.getNumJoints());
        DefaultTechniqueModel techniqueModel = new DefaultTechniqueModel();
        techniqueModel.setProgramModel(programModel);
        MaterialModelHandler.addParametersForPbrTechnique(techniqueModel, materialStructure);
        TechniqueStatesModel techniqueStatesModel = TechniqueStatesModels.createDefault();
        techniqueModel.setTechniqueStatesModel(techniqueStatesModel);
        return techniqueModel;
    }

    DefaultMaterialModel createMaterialModel(Material material, int numJoints) {
        DefaultMaterialModel materialModel = new DefaultMaterialModel();
        MaterialStructure materialStructure = new MaterialStructure(material, numJoints);
        TechniqueModel techniqueModel = this.obtainTechniqueModel(materialStructure);
        materialModel.setTechniqueModel(techniqueModel);
        MaterialPbrMetallicRoughness pbrMetallicRoughness = material.getPbrMetallicRoughness();
        if (pbrMetallicRoughness == null) {
            pbrMetallicRoughness = Materials.createDefaultMaterialPbrMetallicRoughness();
        }
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        if (Boolean.TRUE.equals(material.isDoubleSided())) {
            values.put("isDoubleSided", 1);
        } else {
            values.put("isDoubleSided", 0);
        }
        TextureInfo baseColorTextureInfo = pbrMetallicRoughness.getBaseColorTexture();
        if (baseColorTextureInfo != null) {
            values.put("hasBaseColorTexture", 1);
            values.put("baseColorTexCoord", materialStructure.getBaseColorTexCoordSemantic());
            values.put("baseColorTexture", baseColorTextureInfo.getIndex());
        } else {
            values.put("hasBaseColorTexture", 0);
        }
        float[] baseColorFactor = Optionals.of(pbrMetallicRoughness.getBaseColorFactor(), pbrMetallicRoughness.defaultBaseColorFactor());
        values.put("baseColorFactor", baseColorFactor);
        TextureInfo metallicRoughnessTextureInfo = pbrMetallicRoughness.getMetallicRoughnessTexture();
        if (metallicRoughnessTextureInfo != null) {
            values.put("hasMetallicRoughnessTexture", 1);
            values.put("metallicRoughnessTexCoord", materialStructure.getMetallicRoughnessTexCoordSemantic());
            values.put("metallicRoughnessTexture", metallicRoughnessTextureInfo.getIndex());
        } else {
            values.put("hasMetallicRoughnessTexture", 0);
        }
        float metallicFactor = Optionals.of(pbrMetallicRoughness.getMetallicFactor(), pbrMetallicRoughness.defaultMetallicFactor()).floatValue();
        values.put("metallicFactor", Float.valueOf(metallicFactor));
        float roughnessFactor = Optionals.of(pbrMetallicRoughness.getRoughnessFactor(), pbrMetallicRoughness.defaultRoughnessFactor()).floatValue();
        values.put("roughnessFactor", Float.valueOf(roughnessFactor));
        MaterialNormalTextureInfo normalTextureInfo = material.getNormalTexture();
        if (normalTextureInfo != null) {
            values.put("hasNormalTexture", 1);
            values.put("normalTexCoord", materialStructure.getNormalTexCoordSemantic());
            values.put("normalTexture", normalTextureInfo.getIndex());
            float normalScale = Optionals.of(normalTextureInfo.getScale(), normalTextureInfo.defaultScale()).floatValue();
            values.put("normalScale", Float.valueOf(normalScale));
        } else {
            values.put("hasNormalTexture", 0);
            values.put("normalScale", 1.0);
        }
        MaterialOcclusionTextureInfo occlusionTextureInfo = material.getOcclusionTexture();
        if (occlusionTextureInfo != null) {
            values.put("hasOcclusionTexture", 1);
            values.put("occlusionTexCoord", materialStructure.getOcclusionTexCoordSemantic());
            values.put("occlusionTexture", occlusionTextureInfo.getIndex());
            float occlusionStrength = Optionals.of(occlusionTextureInfo.getStrength(), occlusionTextureInfo.defaultStrength()).floatValue();
            values.put("occlusionStrength", Float.valueOf(occlusionStrength));
        } else {
            values.put("hasOcclusionTexture", 0);
            values.put("occlusionStrength", 0.0);
        }
        TextureInfo emissiveTextureInfo = material.getEmissiveTexture();
        if (emissiveTextureInfo != null) {
            values.put("hasEmissiveTexture", 1);
            values.put("emissiveTexCoord", materialStructure.getEmissiveTexCoordSemantic());
            values.put("emissiveTexture", emissiveTextureInfo.getIndex());
        } else {
            values.put("hasEmissiveTexture", 0);
        }
        float[] emissiveFactor = Optionals.of(material.getEmissiveFactor(), material.defaultEmissiveFactor());
        values.put("emissiveFactor", emissiveFactor);
        float[] lightPosition = new float[]{-800.0f, 500.0f, 500.0f};
        values.put("lightPosition", lightPosition);
        materialModel.setValues(values);
        return materialModel;
    }

    private static DefaultShaderModel createDefaultShaderModel(String resourceName, String uriString, ShaderModel.ShaderType shaderType, String defines) {
        DefaultShaderModel shaderModel = new DefaultShaderModel(uriString, shaderType);
        try (InputStream inputStream = MaterialModelHandler.class.getResourceAsStream("/" + resourceName);){
            String basicShaderString;
            byte[] data = IO.readStream(inputStream);
            String fullShaderString = basicShaderString = new String(data);
            if (defines != null) {
                fullShaderString = defines + "\n" + basicShaderString;
            }
            ByteBuffer shaderData = Buffers.create(fullShaderString.getBytes());
            shaderModel.setShaderData(shaderData);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Could not read shader source code", e);
        }
        return shaderModel;
    }

    private static void addParametersForPbrTechnique(DefaultTechniqueModel techniqueModel, MaterialStructure materialStructure) {
        MaterialModelHandler.addAttributeParameters(techniqueModel, "a_position", "position", 35666, 1, "POSITION");
        MaterialModelHandler.addAttributeParameters(techniqueModel, "a_normal", "normal", 35666, 1, "NORMAL");
        MaterialModelHandler.addAttributeParameters(techniqueModel, "a_tangent", "tangent", 35666, 1, "TANGENT");
        MaterialModelHandler.addAttributeParameters(techniqueModel, "a_baseColorTexCoord", "baseColorTexCoord", 35664, 1, materialStructure.getBaseColorTexCoordSemantic());
        MaterialModelHandler.addAttributeParameters(techniqueModel, "a_metallicRoughnessTexCoord", "metallicRoughnessTexCoord", 35664, 1, materialStructure.getMetallicRoughnessTexCoordSemantic());
        MaterialModelHandler.addAttributeParameters(techniqueModel, "a_normalTexCoord", "normalTexCoord", 35664, 1, materialStructure.getNormalTexCoordSemantic());
        MaterialModelHandler.addAttributeParameters(techniqueModel, "a_occlusionTexCoord", "occlusionTexCoord", 35664, 1, materialStructure.getOcclusionTexCoordSemantic());
        MaterialModelHandler.addAttributeParameters(techniqueModel, "a_emissiveTexCoord", "emissiveTexCoord", 35664, 1, materialStructure.getEmissiveTexCoordSemantic());
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_modelViewMatrix", "modelViewMatrix", 35676, 1, "MODELVIEW");
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_projectionMatrix", "projectionMatrix", 35676, 1, "PROJECTION");
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_normalMatrix", "normalMatrix", 35675, 1, "MODELVIEWINVERSETRANSPOSE");
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_isDoubleSided", "isDoubleSided", 5124, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_baseColorTexture", "baseColorTexture", 35678, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_metallicRoughnessTexture", "metallicRoughnessTexture", 35678, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_normalTexture", "normalTexture", 35678, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_occlusionTexture", "occlusionTexture", 35678, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_emissiveTexture", "emissiveTexture", 35678, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_hasBaseColorTexture", "hasBaseColorTexture", 5124, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_hasMetallicRoughnessTexture", "hasMetallicRoughnessTexture", 5124, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_hasNormalTexture", "hasNormalTexture", 5124, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_hasOcclusionTexture", "hasOcclusionTexture", 5124, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_hasEmissiveTexture", "hasEmissiveTexture", 5124, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_baseColorFactor", "baseColorFactor", 35666, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_metallicFactor", "metallicFactor", 5126, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_roughnessFactor", "roughnessFactor", 5126, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_normalScale", "normalScale", 5126, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_occlusionStrength", "occlusionStrength", 5126, 1, null);
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_emissiveFactor", "emissiveFactor", 35665, 1, null);
        MaterialModelHandler.addAttributeParameters(techniqueModel, "a_joint", "joint", 35666, 1, "JOINTS_0");
        MaterialModelHandler.addAttributeParameters(techniqueModel, "a_weight", "weight", 35666, 1, "WEIGHTS_0");
        if (materialStructure.getNumJoints() > 0) {
            MaterialModelHandler.addUniformParameters(techniqueModel, "u_jointMat", "jointMat", 35676, materialStructure.getNumJoints(), "JOINTMATRIX");
        }
        MaterialModelHandler.addUniformParameters(techniqueModel, "u_lightPosition", "lightPosition", 35665, 1, null);
    }

    private static void addAttributeParameters(DefaultTechniqueModel techniqueModel, String attributeName, String parameterName, int type, int count, String semantic) {
        techniqueModel.addAttribute(attributeName, parameterName);
        MaterialModelHandler.addParameters(techniqueModel, parameterName, type, count, semantic);
    }

    private static void addUniformParameters(DefaultTechniqueModel techniqueModel, String uniformName, String parameterName, int type, int count, String semantic) {
        techniqueModel.addUniform(uniformName, parameterName);
        MaterialModelHandler.addParameters(techniqueModel, parameterName, type, count, semantic);
    }

    private static void addParameters(DefaultTechniqueModel techniqueModel, String parameterName, int type, int count, String semantic) {
        Object value = null;
        NodeModel nodeModel = null;
        DefaultTechniqueParametersModel techniqueParametersModel = new DefaultTechniqueParametersModel(type, count, semantic, value, nodeModel);
        techniqueModel.addParameter(parameterName, techniqueParametersModel);
    }
}

