/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.v2;

import de.javagl.jgltf.impl.v2.Camera;
import de.javagl.jgltf.impl.v2.CameraOrthographic;
import de.javagl.jgltf.impl.v2.CameraPerspective;
import de.javagl.jgltf.model.MathUtils;
import de.javagl.jgltf.model.Utils;
import java.util.logging.Logger;

class CamerasV2 {
    private static final Logger logger = Logger.getLogger(CamerasV2.class.getName());

    static float[] computeProjectionMatrix(Camera camera, Float aspectRatio, float[] result) {
        float[] localResult = Utils.validate(result, 16);
        String cameraType = camera.getType();
        if ("perspective".equals(cameraType)) {
            CameraPerspective cameraPerspective = camera.getPerspective();
            float fovRad = cameraPerspective.getYfov().floatValue();
            float fovDeg = (float)Math.toDegrees(fovRad);
            float localAspectRatio = 1.0f;
            if (aspectRatio != null) {
                localAspectRatio = aspectRatio.floatValue();
            } else if (cameraPerspective.getAspectRatio() != null) {
                localAspectRatio = cameraPerspective.getAspectRatio().floatValue();
            }
            float zNear = cameraPerspective.getZnear().floatValue();
            Float zFar = cameraPerspective.getZfar();
            if (zFar == null) {
                MathUtils.infinitePerspective4x4(fovDeg, localAspectRatio, zNear, localResult);
            } else {
                MathUtils.perspective4x4(fovDeg, localAspectRatio, zNear, zFar.floatValue(), localResult);
            }
        } else if ("orthographic".equals(cameraType)) {
            CameraOrthographic cameraOrthographic = camera.getOrthographic();
            float xMag = cameraOrthographic.getXmag().floatValue();
            float yMag = cameraOrthographic.getYmag().floatValue();
            float zNear = cameraOrthographic.getZnear().floatValue();
            float zFar = cameraOrthographic.getZfar().floatValue();
            MathUtils.setIdentity4x4(localResult);
            localResult[0] = 1.0f / xMag;
            localResult[5] = 1.0f / yMag;
            localResult[10] = 2.0f / (zNear - zFar);
            localResult[14] = (zFar + zNear) / (zNear - zFar);
        } else {
            logger.severe("Invalid camera type: " + cameraType);
            MathUtils.setIdentity4x4(localResult);
        }
        return localResult;
    }

    private CamerasV2() {
    }
}

