/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.v2;

import de.javagl.jgltf.model.AccessorByteData;
import de.javagl.jgltf.model.AccessorData;
import de.javagl.jgltf.model.AccessorFloatData;
import de.javagl.jgltf.model.AccessorIntData;
import de.javagl.jgltf.model.AccessorShortData;
import java.util.logging.Logger;

class AccessorSparseUtils {
    private static final Logger logger = Logger.getLogger(AccessorSparseUtils.class.getName());

    private static int[] extractIndices(AccessorData accessorData) {
        if (accessorData.getComponentType() == Byte.TYPE) {
            AccessorByteData accessorByteData = (AccessorByteData)accessorData;
            int numElements = accessorByteData.getNumElements();
            int[] indices = new int[numElements];
            for (int i = 0; i < numElements; ++i) {
                indices[i] = accessorByteData.getInt(i, 0);
            }
            return indices;
        }
        if (accessorData.getComponentType() == Short.TYPE) {
            AccessorShortData accessorShortData = (AccessorShortData)accessorData;
            int numElements = accessorShortData.getNumElements();
            int[] indices = new int[numElements];
            for (int i = 0; i < numElements; ++i) {
                indices[i] = accessorShortData.getInt(i, 0);
            }
            return indices;
        }
        if (accessorData.getComponentType() == Integer.TYPE) {
            AccessorIntData accessorIntData = (AccessorIntData)accessorData;
            int numElements = accessorIntData.getNumElements();
            int[] indices = new int[numElements];
            for (int i = 0; i < numElements; ++i) {
                indices[i] = accessorIntData.get(i, 0);
            }
            return indices;
        }
        throw new IllegalArgumentException("Invalid type for indices: " + accessorData.getComponentType());
    }

    static void substituteAccessorData(AccessorData denseAccessorData, AccessorData baseAccessorData, AccessorData sparseIndicesAccessorData, AccessorData sparseValuesAccessorData) {
        Class<?> componentType = denseAccessorData.getComponentType();
        if (componentType == Byte.TYPE) {
            AccessorByteData sparseValuesAccessorByteData = (AccessorByteData)sparseValuesAccessorData;
            AccessorByteData baseAccessorByteData = (AccessorByteData)baseAccessorData;
            AccessorByteData denseAccessorByteData = (AccessorByteData)denseAccessorData;
            AccessorSparseUtils.substituteByteAccessorData(denseAccessorByteData, baseAccessorByteData, sparseIndicesAccessorData, sparseValuesAccessorByteData);
        } else if (componentType == Short.TYPE) {
            AccessorShortData sparseValuesAccessorShortData = (AccessorShortData)sparseValuesAccessorData;
            AccessorShortData baseAccessorShortData = (AccessorShortData)baseAccessorData;
            AccessorShortData denseAccessorShortData = (AccessorShortData)denseAccessorData;
            AccessorSparseUtils.substituteShortAccessorData(denseAccessorShortData, baseAccessorShortData, sparseIndicesAccessorData, sparseValuesAccessorShortData);
        } else if (componentType == Integer.TYPE) {
            AccessorIntData sparseValuesAccessorIntData = (AccessorIntData)sparseValuesAccessorData;
            AccessorIntData baseAccessorIntData = (AccessorIntData)baseAccessorData;
            AccessorIntData denseAccessorIntData = (AccessorIntData)denseAccessorData;
            AccessorSparseUtils.substituteIntAccessorData(denseAccessorIntData, baseAccessorIntData, sparseIndicesAccessorData, sparseValuesAccessorIntData);
        } else if (componentType == Float.TYPE) {
            AccessorFloatData sparseValuesAccessorFloatData = (AccessorFloatData)sparseValuesAccessorData;
            AccessorFloatData baseAccessorFloatData = (AccessorFloatData)baseAccessorData;
            AccessorFloatData denseAccessorFloatData = (AccessorFloatData)denseAccessorData;
            AccessorSparseUtils.substituteFloatAccessorData(denseAccessorFloatData, baseAccessorFloatData, sparseIndicesAccessorData, sparseValuesAccessorFloatData);
        } else {
            logger.warning("Invalid component type for accessor: " + componentType);
        }
    }

    private static void substituteByteAccessorData(AccessorByteData denseAccessorData, AccessorByteData baseAccessorData, AccessorData sparseIndicesAccessorData, AccessorByteData sparseValuesAccessorData) {
        int numElements = denseAccessorData.getNumElements();
        int numComponentsPerElement = denseAccessorData.getNumComponentsPerElement();
        if (baseAccessorData != null) {
            for (int e = 0; e < numElements; ++e) {
                for (int c = 0; c < numComponentsPerElement; ++c) {
                    byte value = baseAccessorData.get(e, c);
                    denseAccessorData.set(e, c, value);
                }
            }
        }
        int[] indices = AccessorSparseUtils.extractIndices(sparseIndicesAccessorData);
        for (int i = 0; i < indices.length; ++i) {
            int targetElementIndex = indices[i];
            for (int c = 0; c < numComponentsPerElement; ++c) {
                byte substitution = sparseValuesAccessorData.get(i, c);
                denseAccessorData.set(targetElementIndex, c, substitution);
            }
        }
    }

    private static void substituteShortAccessorData(AccessorShortData denseAccessorData, AccessorShortData baseAccessorData, AccessorData sparseIndicesAccessorData, AccessorShortData sparseValuesAccessorData) {
        int numElements = denseAccessorData.getNumElements();
        int numComponentsPerElement = denseAccessorData.getNumComponentsPerElement();
        if (baseAccessorData != null) {
            for (int e = 0; e < numElements; ++e) {
                for (int c = 0; c < numComponentsPerElement; ++c) {
                    short value = baseAccessorData.get(e, c);
                    denseAccessorData.set(e, c, value);
                }
            }
        }
        int[] indices = AccessorSparseUtils.extractIndices(sparseIndicesAccessorData);
        for (int i = 0; i < indices.length; ++i) {
            int targetElementIndex = indices[i];
            for (int c = 0; c < numComponentsPerElement; ++c) {
                short substitution = sparseValuesAccessorData.get(i, c);
                denseAccessorData.set(targetElementIndex, c, substitution);
            }
        }
    }

    private static void substituteIntAccessorData(AccessorIntData denseAccessorData, AccessorIntData baseAccessorData, AccessorData sparseIndicesAccessorData, AccessorIntData sparseValuesAccessorData) {
        int numElements = denseAccessorData.getNumElements();
        int numComponentsPerElement = denseAccessorData.getNumComponentsPerElement();
        if (baseAccessorData != null) {
            for (int e = 0; e < numElements; ++e) {
                for (int c = 0; c < numComponentsPerElement; ++c) {
                    int value = baseAccessorData.get(e, c);
                    denseAccessorData.set(e, c, value);
                }
            }
        }
        int[] indices = AccessorSparseUtils.extractIndices(sparseIndicesAccessorData);
        for (int i = 0; i < indices.length; ++i) {
            int targetElementIndex = indices[i];
            for (int c = 0; c < numComponentsPerElement; ++c) {
                int substitution = sparseValuesAccessorData.get(i, c);
                denseAccessorData.set(targetElementIndex, c, substitution);
            }
        }
    }

    private static void substituteFloatAccessorData(AccessorFloatData denseAccessorData, AccessorFloatData baseAccessorData, AccessorData sparseIndicesAccessorData, AccessorFloatData sparseValuesAccessorData) {
        int numElements = denseAccessorData.getNumElements();
        int numComponentsPerElement = denseAccessorData.getNumComponentsPerElement();
        if (baseAccessorData != null) {
            for (int e = 0; e < numElements; ++e) {
                for (int c = 0; c < numComponentsPerElement; ++c) {
                    float value = baseAccessorData.get(e, c);
                    denseAccessorData.set(e, c, value);
                }
            }
        }
        int[] indices = AccessorSparseUtils.extractIndices(sparseIndicesAccessorData);
        for (int i = 0; i < indices.length; ++i) {
            int targetElementIndex = indices[i];
            for (int c = 0; c < numComponentsPerElement; ++c) {
                float substitution = sparseValuesAccessorData.get(i, c);
                denseAccessorData.set(targetElementIndex, c, substitution);
            }
        }
    }

    private AccessorSparseUtils() {
    }
}

