/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.v1.gl;

import de.javagl.jgltf.impl.v1.Material;
import de.javagl.jgltf.impl.v1.Shader;
import de.javagl.jgltf.impl.v1.Technique;
import de.javagl.jgltf.impl.v1.TechniqueParameters;
import de.javagl.jgltf.impl.v1.TechniqueStates;
import de.javagl.jgltf.impl.v1.TechniqueStatesFunctions;
import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.gl.ShaderModel;
import de.javagl.jgltf.model.gl.TechniqueModel;
import de.javagl.jgltf.model.gl.impl.DefaultProgramModel;
import de.javagl.jgltf.model.gl.impl.DefaultShaderModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueParametersModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueStatesModel;
import de.javagl.jgltf.model.gl.impl.v1.DefaultTechniqueStatesFunctionsModelV1;
import de.javagl.jgltf.model.impl.DefaultMaterialModel;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.v1.gl.GltfDefaults;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DefaultModels {
    private static final Logger logger = Logger.getLogger(DefaultModels.class.getName());
    private static final DefaultShaderModel DEFAULT_VERTEX_SHADER_MODEL;
    private static final DefaultShaderModel DEFAULT_FRAGMENT_SHADER_MODEL;
    private static final DefaultProgramModel DEFAULT_PROGRAM_MODEL;
    private static final DefaultTechniqueModel DEFAULT_TECHNIQUE_MODEL;
    private static final DefaultMaterialModel DEFAULT_MATERIAL_MODEL;

    public static MaterialModel getDefaultMaterialModel() {
        return DEFAULT_MATERIAL_MODEL;
    }

    private static void initShaderData(DefaultShaderModel shaderModel) {
        try {
            URI uri = new URI(shaderModel.getUri());
            byte[] data = IO.read(uri);
            ByteBuffer shaderData = Buffers.create(data);
            shaderModel.setShaderData(shaderData);
        }
        catch (IOException | URISyntaxException e) {
            logger.severe("Failed to initialize shader data");
        }
    }

    public static TechniqueModel getDefaultTechniqueModel() {
        return DEFAULT_TECHNIQUE_MODEL;
    }

    private static void addParametersForDefaultTechnique(Technique technique, DefaultTechniqueModel techniqueModel) {
        Map parameters = Optionals.of(technique.getParameters());
        for (Map.Entry entry : parameters.entrySet()) {
            String parameterName = (String)entry.getKey();
            TechniqueParameters parameter = (TechniqueParameters)entry.getValue();
            int type = parameter.getType();
            int count = Optionals.of(parameter.getCount(), 1);
            String semantic = parameter.getSemantic();
            Object value = parameter.getValue();
            NodeModel nodeModel = null;
            DefaultTechniqueParametersModel techniqueParametersModel = new DefaultTechniqueParametersModel(type, count, semantic, value, nodeModel);
            techniqueModel.addParameter(parameterName, techniqueParametersModel);
        }
    }

    private static void addAttributes(Technique technique, DefaultTechniqueModel techniqueModel) {
        Map attributes = Optionals.of(technique.getAttributes());
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            String parameterName = (String)entry.getValue();
            techniqueModel.addAttribute(attributeName, parameterName);
        }
    }

    private static void addUniforms(Technique technique, DefaultTechniqueModel techniqueModel) {
        Map uniforms = Optionals.of(technique.getUniforms());
        for (Map.Entry entry : uniforms.entrySet()) {
            String uniformName = (String)entry.getKey();
            String parameterName = (String)entry.getValue();
            techniqueModel.addUniform(uniformName, parameterName);
        }
    }

    private DefaultModels() {
    }

    static {
        Shader vertexShader = GltfDefaults.getDefaultVertexShader();
        DEFAULT_VERTEX_SHADER_MODEL = new DefaultShaderModel(vertexShader.getUri(), ShaderModel.ShaderType.VERTEX_SHADER);
        DefaultModels.initShaderData(DEFAULT_VERTEX_SHADER_MODEL);
        Shader fragmentShader = GltfDefaults.getDefaultFragmentShader();
        DEFAULT_FRAGMENT_SHADER_MODEL = new DefaultShaderModel(fragmentShader.getUri(), ShaderModel.ShaderType.FRAGMENT_SHADER);
        DefaultModels.initShaderData(DEFAULT_FRAGMENT_SHADER_MODEL);
        DEFAULT_PROGRAM_MODEL = new DefaultProgramModel();
        DEFAULT_PROGRAM_MODEL.setVertexShaderModel(DEFAULT_VERTEX_SHADER_MODEL);
        DEFAULT_PROGRAM_MODEL.setFragmentShaderModel(DEFAULT_FRAGMENT_SHADER_MODEL);
        Technique technique = GltfDefaults.getDefaultTechnique();
        DEFAULT_TECHNIQUE_MODEL = new DefaultTechniqueModel();
        DEFAULT_TECHNIQUE_MODEL.setProgramModel(DEFAULT_PROGRAM_MODEL);
        DefaultModels.addParametersForDefaultTechnique(technique, DEFAULT_TECHNIQUE_MODEL);
        DefaultModels.addAttributes(technique, DEFAULT_TECHNIQUE_MODEL);
        DefaultModels.addUniforms(technique, DEFAULT_TECHNIQUE_MODEL);
        TechniqueStates states = technique.getStates();
        List enable = Optionals.of(states.getEnable(), states.defaultEnable());
        TechniqueStatesFunctions functions = states.getFunctions();
        DefaultTechniqueStatesFunctionsModelV1 techniqueStatesFunctionsModel = new DefaultTechniqueStatesFunctionsModelV1(functions);
        DefaultTechniqueStatesModel techniqueStatesModel = new DefaultTechniqueStatesModel(enable, techniqueStatesFunctionsModel);
        DEFAULT_TECHNIQUE_MODEL.setTechniqueStatesModel(techniqueStatesModel);
        Material material = GltfDefaults.getDefaultMaterial();
        DEFAULT_MATERIAL_MODEL = new DefaultMaterialModel();
        DEFAULT_MATERIAL_MODEL.setValues(material.getValues());
        DEFAULT_MATERIAL_MODEL.setTechniqueModel(DEFAULT_TECHNIQUE_MODEL);
    }
}

