/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.v1;

import de.javagl.jgltf.impl.v1.Accessor;
import de.javagl.jgltf.impl.v1.Animation;
import de.javagl.jgltf.impl.v1.AnimationChannel;
import de.javagl.jgltf.impl.v1.AnimationChannelTarget;
import de.javagl.jgltf.impl.v1.AnimationSampler;
import de.javagl.jgltf.impl.v1.Buffer;
import de.javagl.jgltf.impl.v1.BufferView;
import de.javagl.jgltf.impl.v1.Camera;
import de.javagl.jgltf.impl.v1.GlTF;
import de.javagl.jgltf.impl.v1.GlTFProperty;
import de.javagl.jgltf.impl.v1.Image;
import de.javagl.jgltf.impl.v1.Material;
import de.javagl.jgltf.impl.v1.Mesh;
import de.javagl.jgltf.impl.v1.MeshPrimitive;
import de.javagl.jgltf.impl.v1.Node;
import de.javagl.jgltf.impl.v1.Program;
import de.javagl.jgltf.impl.v1.Sampler;
import de.javagl.jgltf.impl.v1.Scene;
import de.javagl.jgltf.impl.v1.Shader;
import de.javagl.jgltf.impl.v1.Skin;
import de.javagl.jgltf.impl.v1.Technique;
import de.javagl.jgltf.impl.v1.TechniqueParameters;
import de.javagl.jgltf.impl.v1.TechniqueStatesFunctions;
import de.javagl.jgltf.impl.v1.Texture;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.Accessors;
import de.javagl.jgltf.model.AnimationModel;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.CameraModel;
import de.javagl.jgltf.model.ElementType;
import de.javagl.jgltf.model.GltfModel;
import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.MathUtils;
import de.javagl.jgltf.model.MeshModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.SceneModel;
import de.javagl.jgltf.model.SkinModel;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.Utils;
import de.javagl.jgltf.model.gl.ShaderModel;
import de.javagl.jgltf.model.gl.impl.DefaultProgramModel;
import de.javagl.jgltf.model.gl.impl.DefaultShaderModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueParametersModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueStatesModel;
import de.javagl.jgltf.model.gl.impl.v1.DefaultTechniqueStatesFunctionsModelV1;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.impl.DefaultAnimationModel;
import de.javagl.jgltf.model.impl.DefaultBufferModel;
import de.javagl.jgltf.model.impl.DefaultBufferViewModel;
import de.javagl.jgltf.model.impl.DefaultCameraModel;
import de.javagl.jgltf.model.impl.DefaultImageModel;
import de.javagl.jgltf.model.impl.DefaultMaterialModel;
import de.javagl.jgltf.model.impl.DefaultMeshModel;
import de.javagl.jgltf.model.impl.DefaultMeshPrimitiveModel;
import de.javagl.jgltf.model.impl.DefaultNodeModel;
import de.javagl.jgltf.model.impl.DefaultSceneModel;
import de.javagl.jgltf.model.impl.DefaultSkinModel;
import de.javagl.jgltf.model.impl.DefaultTextureModel;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.io.v1.GltfAssetV1;
import de.javagl.jgltf.model.v1.BinaryGltfV1;
import de.javagl.jgltf.model.v1.CamerasV1;
import de.javagl.jgltf.model.v1.IndexMappingSet;
import de.javagl.jgltf.model.v1.IndexMappingSets;
import de.javagl.jgltf.model.v1.gl.DefaultModels;
import de.javagl.jgltf.model.v1.gl.GltfDefaults;
import de.javagl.jgltf.model.v1.gl.Techniques;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Logger;

public final class GltfModelV1
implements GltfModel {
    private static final Logger logger = Logger.getLogger(GltfModelV1.class.getName());
    private final GltfAssetV1 gltfAsset;
    private final GlTF gltf;
    private final ByteBuffer binaryData;
    private final IndexMappingSet indexMappingSet;
    private final List<DefaultAccessorModel> accessorModels;
    private final List<DefaultAnimationModel> animationModels;
    private final List<DefaultBufferModel> bufferModels;
    private final List<DefaultBufferViewModel> bufferViewModels;
    private final List<DefaultCameraModel> cameraModels;
    private final List<DefaultImageModel> imageModels;
    private final List<DefaultMaterialModel> materialModels;
    private final List<DefaultMeshModel> meshModels;
    private final List<DefaultNodeModel> nodeModels;
    private final List<DefaultSceneModel> sceneModels;
    private final List<DefaultSkinModel> skinModels;
    private final List<DefaultTextureModel> textureModels;
    private final List<DefaultShaderModel> shaderModels;
    private final List<DefaultProgramModel> programModels;
    private final List<DefaultTechniqueModel> techniqueModels;

    public GltfModelV1(GltfAssetV1 gltfAsset) {
        this.gltfAsset = Objects.requireNonNull(gltfAsset, "The gltf may not be null");
        this.gltf = gltfAsset.getGltf();
        ByteBuffer binaryData = gltfAsset.getBinaryData();
        this.binaryData = binaryData != null && binaryData.capacity() > 0 ? binaryData : null;
        this.indexMappingSet = IndexMappingSets.create(this.gltf);
        this.accessorModels = new ArrayList<DefaultAccessorModel>();
        this.animationModels = new ArrayList<DefaultAnimationModel>();
        this.bufferModels = new ArrayList<DefaultBufferModel>();
        this.bufferViewModels = new ArrayList<DefaultBufferViewModel>();
        this.cameraModels = new ArrayList<DefaultCameraModel>();
        this.imageModels = new ArrayList<DefaultImageModel>();
        this.materialModels = new ArrayList<DefaultMaterialModel>();
        this.meshModels = new ArrayList<DefaultMeshModel>();
        this.nodeModels = new ArrayList<DefaultNodeModel>();
        this.sceneModels = new ArrayList<DefaultSceneModel>();
        this.skinModels = new ArrayList<DefaultSkinModel>();
        this.textureModels = new ArrayList<DefaultTextureModel>();
        this.shaderModels = new ArrayList<DefaultShaderModel>();
        this.programModels = new ArrayList<DefaultProgramModel>();
        this.techniqueModels = new ArrayList<DefaultTechniqueModel>();
        this.createAccessorModels();
        this.createAnimationModels();
        this.createBufferModels();
        this.createBufferViewModels();
        this.createImageModels();
        this.createMaterialModels();
        this.createMeshModels();
        this.createNodeModels();
        this.createSceneModels();
        this.createSkinModels();
        this.createTextureModels();
        this.createShaderModels();
        this.createProgramModels();
        this.createTechniqueModels();
        this.initBufferModels();
        this.initBufferViewModels();
        this.initAccessorModels();
        this.assignBufferViewByteStrides();
        this.initAnimationModels();
        this.initImageModels();
        this.initMaterialModels();
        this.initMeshModels();
        this.initNodeModels();
        this.initSceneModels();
        this.initSkinModels();
        this.initTextureModels();
        this.initShaderModels();
        this.initProgramModels();
        this.initTechniqueModels();
        this.instantiateCameraModels();
    }

    public BufferModel getBufferModelById(String bufferId) {
        return this.get("buffers", bufferId, this.bufferModels);
    }

    public ShaderModel getShaderModelById(String shaderId) {
        return this.get("shaders", shaderId, this.shaderModels);
    }

    public ImageModel getImageModelById(String imageId) {
        return this.get("images", imageId, this.imageModels);
    }

    public TextureModel getTextureModelById(String textureId) {
        return this.get("textures", textureId, this.textureModels);
    }

    public AccessorModel getAccessorModelById(String accessorId) {
        return this.get("accessors", accessorId, this.accessorModels);
    }

    private BufferViewModel getBufferViewModelById(String bufferViewId) {
        return this.get("bufferViews", bufferViewId, this.bufferViewModels);
    }

    private void createAccessorModels() {
        Map accessors = Optionals.of(this.gltf.getAccessors());
        for (Accessor accessor : accessors.values()) {
            DefaultAccessorModel accessorModel = GltfModelV1.createAccessorModel(accessor);
            this.accessorModels.add(accessorModel);
        }
    }

    private static DefaultAccessorModel createAccessorModel(Accessor accessor) {
        Integer componentType = accessor.getComponentType();
        Integer byteOffset = accessor.getByteOffset();
        Integer count = accessor.getCount();
        ElementType elementType = ElementType.forString(accessor.getType());
        Integer byteStride = accessor.getByteStride();
        if (byteStride == null) {
            byteStride = elementType.getNumComponents() * Accessors.getNumBytesForAccessorComponentType(componentType);
        }
        DefaultAccessorModel accessorModel = new DefaultAccessorModel(componentType, count, elementType);
        accessorModel.setByteOffset(byteOffset);
        accessorModel.setByteStride(byteStride);
        return accessorModel;
    }

    private void createAnimationModels() {
        Map animations = Optionals.of(this.gltf.getAnimations());
        for (int i = 0; i < animations.size(); ++i) {
            this.animationModels.add(new DefaultAnimationModel());
        }
    }

    private void createBufferModels() {
        Map buffers = Optionals.of(this.gltf.getBuffers());
        for (Buffer buffer : buffers.values()) {
            DefaultBufferModel bufferModel = new DefaultBufferModel();
            bufferModel.setUri(buffer.getUri());
            this.bufferModels.add(bufferModel);
        }
    }

    private void createBufferViewModels() {
        Map bufferViews = Optionals.of(this.gltf.getBufferViews());
        for (BufferView bufferView : bufferViews.values()) {
            DefaultBufferViewModel bufferViewModel = GltfModelV1.createBufferViewModel(bufferView);
            this.bufferViewModels.add(bufferViewModel);
        }
    }

    private static DefaultBufferViewModel createBufferViewModel(BufferView bufferView) {
        int byteOffset = bufferView.getByteOffset();
        Integer byteLength = bufferView.getByteLength();
        if (byteLength == null) {
            logger.warning("No byteLength found in BufferView");
            byteLength = 0;
        }
        Integer target = bufferView.getTarget();
        DefaultBufferViewModel bufferViewModel = new DefaultBufferViewModel(target);
        bufferViewModel.setByteOffset(byteOffset);
        bufferViewModel.setByteLength(byteLength);
        return bufferViewModel;
    }

    private void createImageModels() {
        Map images = Optionals.of(this.gltf.getImages());
        for (Image image : images.values()) {
            DefaultImageModel imageModel = new DefaultImageModel(null, null);
            String uri = image.getUri();
            imageModel.setUri(uri);
            this.imageModels.add(imageModel);
        }
    }

    private void createMaterialModels() {
        Map materials = Optionals.of(this.gltf.getMaterials());
        for (int i = 0; i < materials.size(); ++i) {
            this.materialModels.add(new DefaultMaterialModel());
        }
    }

    private void createMeshModels() {
        Map meshes = Optionals.of(this.gltf.getMeshes());
        for (int i = 0; i < meshes.size(); ++i) {
            this.meshModels.add(new DefaultMeshModel());
        }
    }

    private void createNodeModels() {
        Map nodes = Optionals.of(this.gltf.getNodes());
        for (int i = 0; i < nodes.size(); ++i) {
            this.nodeModels.add(new DefaultNodeModel());
        }
    }

    private void createSceneModels() {
        Map scenes = Optionals.of(this.gltf.getScenes());
        for (int i = 0; i < scenes.size(); ++i) {
            this.sceneModels.add(new DefaultSceneModel());
        }
    }

    private void createSkinModels() {
        Map skins = Optionals.of(this.gltf.getSkins());
        for (Map.Entry entry : skins.entrySet()) {
            Skin skin = (Skin)entry.getValue();
            float[] bindShapeMatrix = skin.getBindShapeMatrix();
            this.skinModels.add(new DefaultSkinModel(bindShapeMatrix));
        }
    }

    private void createTextureModels() {
        Map textures = Optionals.of(this.gltf.getTextures());
        Map samplers = Optionals.of(this.gltf.getSamplers());
        for (Map.Entry entry : textures.entrySet()) {
            Texture texture = (Texture)entry.getValue();
            String samplerId = texture.getSampler();
            Sampler sampler = (Sampler)samplers.get(samplerId);
            int magFilter = Optionals.of(sampler.getMagFilter(), sampler.defaultMagFilter());
            int minFilter = Optionals.of(sampler.getMinFilter(), sampler.defaultMinFilter());
            int wrapS = Optionals.of(sampler.getWrapS(), sampler.defaultWrapS());
            int wrapT = Optionals.of(sampler.getWrapT(), sampler.defaultWrapT());
            this.textureModels.add(new DefaultTextureModel(magFilter, minFilter, wrapS, wrapT));
        }
    }

    private void createShaderModels() {
        Map shaders = Optionals.of(this.gltf.getShaders());
        for (Map.Entry entry : shaders.entrySet()) {
            Shader shader = (Shader)entry.getValue();
            Integer type = shader.getType();
            ShaderModel.ShaderType shaderType = null;
            shaderType = type == 35633 ? ShaderModel.ShaderType.VERTEX_SHADER : ShaderModel.ShaderType.FRAGMENT_SHADER;
            DefaultShaderModel shaderModel = new DefaultShaderModel(shader.getUri(), shaderType);
            this.shaderModels.add(shaderModel);
        }
    }

    private void createProgramModels() {
        Map programs = Optionals.of(this.gltf.getPrograms());
        for (int i = 0; i < programs.size(); ++i) {
            this.programModels.add(new DefaultProgramModel());
        }
    }

    private void createTechniqueModels() {
        Map techniques = Optionals.of(this.gltf.getTechniques());
        for (int i = 0; i < techniques.size(); ++i) {
            this.techniqueModels.add(new DefaultTechniqueModel());
        }
    }

    private void initAccessorModels() {
        Map accessors = Optionals.of(this.gltf.getAccessors());
        for (Map.Entry entry : accessors.entrySet()) {
            String accessorId = (String)entry.getKey();
            Accessor accessor = (Accessor)entry.getValue();
            String bufferViewId = accessor.getBufferView();
            BufferViewModel bufferViewModel = this.get("bufferViews", bufferViewId, this.bufferViewModels);
            DefaultAccessorModel accessorModel = this.get("accessors", accessorId, this.accessorModels);
            accessorModel.setName(accessor.getName());
            accessorModel.setBufferViewModel(bufferViewModel);
        }
    }

    private void initAnimationModels() {
        Map animations = Optionals.of(this.gltf.getAnimations());
        for (Map.Entry entry : animations.entrySet()) {
            String animationId = (String)entry.getKey();
            Animation animation = (Animation)entry.getValue();
            DefaultAnimationModel animationModel = this.get("animations", animationId, this.animationModels);
            animationModel.setName(animation.getName());
            List<AnimationChannel> channels = Optionals.of(animation.getChannels());
            for (AnimationChannel animationChannel : channels) {
                AnimationModel.Channel channel = this.createChannel(animation, animationChannel);
                animationModel.addChannel(channel);
            }
        }
    }

    private void initImageModels() {
        Map images = Optionals.of(this.gltf.getImages());
        for (Map.Entry entry : images.entrySet()) {
            String imageId = (String)entry.getKey();
            Image image = (Image)entry.getValue();
            DefaultImageModel imageModel = this.get("images", imageId, this.imageModels);
            imageModel.setName(image.getName());
            if (BinaryGltfV1.hasBinaryGltfExtension((GlTFProperty)image)) {
                String bufferViewId = BinaryGltfV1.getBinaryGltfBufferViewId((GlTFProperty)image);
                BufferViewModel bufferViewModel = this.getBufferViewModelById(bufferViewId);
                imageModel.setBufferViewModel(bufferViewModel);
                continue;
            }
            String uri = image.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer imageData = Buffers.create(data);
                imageModel.setImageData(imageData);
                continue;
            }
            ByteBuffer imageData = this.gltfAsset.getReferenceData(uri);
            imageModel.setImageData(imageData);
        }
    }

    private AnimationModel.Channel createChannel(Animation animation, AnimationChannel animationChannel) {
        String samplerId;
        Map samplers;
        AnimationSampler animationSampler;
        String inputParameterId;
        Map parameters = Optionals.of(animation.getParameters());
        String inputAccessorId = (String)parameters.get(inputParameterId = (animationSampler = (AnimationSampler)(samplers = Optionals.of(animation.getSamplers())).get(samplerId = animationChannel.getSampler())).getInput());
        if (inputAccessorId == null) {
            logger.warning("Assuming " + inputParameterId + " to be an accessor ID");
            inputAccessorId = inputParameterId;
        }
        DefaultAccessorModel inputAccessorModel = this.get("accessors", inputAccessorId, this.accessorModels);
        String outputParameterId = animationSampler.getOutput();
        String outputAccessorId = (String)parameters.get(outputParameterId);
        if (outputAccessorId == null) {
            logger.warning("Assuming " + outputParameterId + " to be an accessor ID");
            outputAccessorId = outputParameterId;
        }
        DefaultAccessorModel outputAccessorModel = this.get("accessors", outputAccessorId, this.accessorModels);
        String interpolationString = animationSampler.getInterpolation();
        AnimationModel.Interpolation interpolation = interpolationString == null ? AnimationModel.Interpolation.LINEAR : AnimationModel.Interpolation.valueOf(interpolationString);
        DefaultAnimationModel.DefaultSampler sampler = new DefaultAnimationModel.DefaultSampler(inputAccessorModel, interpolation, outputAccessorModel);
        AnimationChannelTarget animationChannelTarget = animationChannel.getTarget();
        String nodeId = animationChannelTarget.getId();
        String path = animationChannelTarget.getPath();
        NodeModel nodeModel = this.get("nodes", nodeId, this.nodeModels);
        DefaultAnimationModel.DefaultChannel channel = new DefaultAnimationModel.DefaultChannel(sampler, nodeModel, path);
        return channel;
    }

    private void initBufferModels() {
        Map buffers = Optionals.of(this.gltf.getBuffers());
        for (Map.Entry entry : buffers.entrySet()) {
            String bufferId = (String)entry.getKey();
            Buffer buffer = (Buffer)entry.getValue();
            DefaultBufferModel bufferModel = this.get("buffers", bufferId, this.bufferModels);
            bufferModel.setName(buffer.getName());
            if (BinaryGltfV1.isBinaryGltfBufferId(bufferId)) {
                if (this.binaryData == null) {
                    logger.severe("The glTF contains a buffer with the binary buffer ID, but no binary data has been given");
                    continue;
                }
                bufferModel.setBufferData(this.binaryData);
                continue;
            }
            String uri = buffer.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer bufferData = Buffers.create(data);
                bufferModel.setBufferData(bufferData);
                continue;
            }
            ByteBuffer bufferData = this.gltfAsset.getReferenceData(uri);
            bufferModel.setBufferData(bufferData);
        }
    }

    private void initBufferViewModels() {
        Map bufferViews = Optionals.of(this.gltf.getBufferViews());
        for (Map.Entry entry : bufferViews.entrySet()) {
            String bufferViewId = (String)entry.getKey();
            BufferView bufferView = (BufferView)entry.getValue();
            String bufferId = bufferView.getBuffer();
            BufferModel bufferModel = this.get("buffers", bufferId, this.bufferModels);
            DefaultBufferViewModel bufferViewModel = this.get("bufferViews", bufferViewId, this.bufferViewModels);
            bufferViewModel.setName(bufferView.getName());
            bufferViewModel.setBufferModel(bufferModel);
        }
    }

    private List<DefaultAccessorModel> computeAccessorModelsOf(BufferViewModel bufferViewModel) {
        ArrayList<DefaultAccessorModel> result = new ArrayList<DefaultAccessorModel>();
        for (DefaultAccessorModel accessorModel : this.accessorModels) {
            BufferViewModel b = accessorModel.getBufferViewModel();
            if (!bufferViewModel.equals(b)) continue;
            result.add(accessorModel);
        }
        return result;
    }

    private static int computeCommonByteStride(Iterable<? extends AccessorModel> accessorModels) {
        int commonByteStride = -1;
        for (AccessorModel accessorModel : accessorModels) {
            int byteStride = accessorModel.getByteStride();
            if (commonByteStride == -1) {
                commonByteStride = byteStride;
                continue;
            }
            if (commonByteStride == byteStride) continue;
            logger.warning("The accessor models do not have the same byte stride: " + commonByteStride + " and " + byteStride);
        }
        return commonByteStride;
    }

    private void assignBufferViewByteStrides() {
        for (DefaultBufferViewModel bufferViewModel : this.bufferViewModels) {
            List<DefaultAccessorModel> accessorModelsOfBufferView = this.computeAccessorModelsOf(bufferViewModel);
            if (accessorModelsOfBufferView.size() <= 1) continue;
            int byteStride = GltfModelV1.computeCommonByteStride(accessorModelsOfBufferView);
            bufferViewModel.setByteStride(byteStride);
        }
    }

    private void initMeshModels() {
        Map meshes = Optionals.of(this.gltf.getMeshes());
        for (Map.Entry entry : meshes.entrySet()) {
            String meshId = (String)entry.getKey();
            Mesh mesh = (Mesh)entry.getValue();
            List<MeshPrimitive> primitives = Optionals.of(mesh.getPrimitives());
            DefaultMeshModel meshModel = this.get("meshes", meshId, this.meshModels);
            meshModel.setName(mesh.getName());
            for (MeshPrimitive meshPrimitive : primitives) {
                DefaultMeshPrimitiveModel meshPrimitiveModel = this.createMeshPrimitiveModel(meshPrimitive);
                meshModel.addMeshPrimitiveModel(meshPrimitiveModel);
            }
        }
    }

    private DefaultMeshPrimitiveModel createMeshPrimitiveModel(MeshPrimitive meshPrimitive) {
        Integer mode = meshPrimitive.getMode();
        if (mode == null) {
            mode = meshPrimitive.defaultMode();
        }
        DefaultMeshPrimitiveModel meshPrimitiveModel = new DefaultMeshPrimitiveModel(mode);
        String indicesId = meshPrimitive.getIndices();
        if (indicesId != null) {
            AccessorModel indices = this.get("accessors", indicesId, this.accessorModels);
            meshPrimitiveModel.setIndices(indices);
        }
        Map attributes = Optionals.of(meshPrimitive.getAttributes());
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            String attributeId = (String)entry.getValue();
            AccessorModel attribute = this.get("accessors", attributeId, this.accessorModels);
            meshPrimitiveModel.putAttribute(attributeName, attribute);
        }
        String materialId = meshPrimitive.getMaterial();
        if (materialId == null || GltfDefaults.isDefaultMaterialId(materialId)) {
            meshPrimitiveModel.setMaterialModel(DefaultModels.getDefaultMaterialModel());
        } else {
            MaterialModel materialModel = this.get("materials", materialId, this.materialModels);
            meshPrimitiveModel.setMaterialModel(materialModel);
        }
        return meshPrimitiveModel;
    }

    private void initNodeModels() {
        Map nodes = Optionals.of(this.gltf.getNodes());
        for (Map.Entry entry : nodes.entrySet()) {
            Object childId22;
            String nodeId = (String)entry.getKey();
            Node node = (Node)entry.getValue();
            DefaultNodeModel nodeModel = this.get("nodes", nodeId, this.nodeModels);
            nodeModel.setName(node.getName());
            List<Object> childIds = Optionals.of(node.getChildren());
            for (Object childId22 : childIds) {
                DefaultNodeModel child = this.get("nodes", (String)childId22, this.nodeModels);
                nodeModel.addChild(child);
            }
            List meshIds = Optionals.of(node.getMeshes());
            childId22 = meshIds.iterator();
            while (childId22.hasNext()) {
                String meshId = (String)childId22.next();
                MeshModel meshModel = this.get("meshes", meshId, this.meshModels);
                nodeModel.addMeshModel(meshModel);
            }
            String skinId = node.getSkin();
            if (skinId != null) {
                SkinModel skinModel = this.get("skins", skinId, this.skinModels);
                nodeModel.setSkinModel(skinModel);
            }
            float[] matrix = node.getMatrix();
            float[] translation = node.getTranslation();
            float[] rotation = node.getRotation();
            float[] scale = node.getScale();
            nodeModel.setMatrix(matrix == null ? null : (float[])matrix.clone());
            nodeModel.setTranslation(translation == null ? null : (float[])translation.clone());
            nodeModel.setRotation(rotation == null ? null : (float[])rotation.clone());
            nodeModel.setScale(scale == null ? null : (float[])scale.clone());
        }
    }

    private void initSceneModels() {
        Map scenes = Optionals.of(this.gltf.getScenes());
        for (Map.Entry entry : scenes.entrySet()) {
            String sceneId = (String)entry.getKey();
            Scene scene = (Scene)entry.getValue();
            DefaultSceneModel sceneModel = this.get("scenes", sceneId, this.sceneModels);
            sceneModel.setName(scene.getName());
            List<String> nodes = Optionals.of(scene.getNodes());
            for (String nodeId : nodes) {
                NodeModel nodeModel = this.get("nodes", nodeId, this.nodeModels);
                sceneModel.addNode(nodeModel);
            }
        }
    }

    private static Map<String, String> computeJointNameToNodeIdMap(GlTF gltf) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Map nodes = Optionals.of(gltf.getNodes());
        for (Map.Entry entry : nodes.entrySet()) {
            String oldNodeId;
            String nodeId = (String)entry.getKey();
            Node node = (Node)entry.getValue();
            if (node.getJointName() == null || (oldNodeId = map.put(node.getJointName(), nodeId)) == null) continue;
            logger.warning("Joint name " + node.getJointName() + " is mapped to nodes with IDs " + nodeId + " and " + oldNodeId);
        }
        return map;
    }

    private void initSkinModels() {
        Map<String, String> jointNameToNodeIdMap = GltfModelV1.computeJointNameToNodeIdMap(this.gltf);
        Map skins = Optionals.of(this.gltf.getSkins());
        for (Map.Entry entry : skins.entrySet()) {
            String skinId = (String)entry.getKey();
            Skin skin = (Skin)entry.getValue();
            DefaultSkinModel skinModel = this.get("skins", skinId, this.skinModels);
            skinModel.setName(skin.getName());
            List jointNames = skin.getJointNames();
            for (String jointName : jointNames) {
                String nodeId = jointNameToNodeIdMap.get(jointName);
                NodeModel nodeModel = this.get("nodes", nodeId, this.nodeModels);
                skinModel.addJoint(nodeModel);
            }
            String inverseBindMatricesId = skin.getInverseBindMatrices();
            DefaultAccessorModel inverseBindMatrices = this.get("accessors", inverseBindMatricesId, this.accessorModels);
            skinModel.setInverseBindMatrices(inverseBindMatrices);
        }
    }

    private void initTextureModels() {
        Map textures = Optionals.of(this.gltf.getTextures());
        for (Map.Entry entry : textures.entrySet()) {
            String textureId = (String)entry.getKey();
            Texture texture = (Texture)entry.getValue();
            DefaultTextureModel textureModel = this.get("textures", textureId, this.textureModels);
            textureModel.setName(texture.getName());
            String imageId = texture.getSource();
            DefaultImageModel imageModel = this.get("images", imageId, this.imageModels);
            textureModel.setImageModel(imageModel);
        }
    }

    private void initShaderModels() {
        Map shaders = Optionals.of(this.gltf.getShaders());
        for (Map.Entry entry : shaders.entrySet()) {
            String shaderId = (String)entry.getKey();
            Shader shader = (Shader)entry.getValue();
            DefaultShaderModel shaderModel = this.get("shaders", shaderId, this.shaderModels);
            shaderModel.setName(shader.getName());
            if (BinaryGltfV1.hasBinaryGltfExtension((GlTFProperty)shader)) {
                String bufferViewId = BinaryGltfV1.getBinaryGltfBufferViewId((GlTFProperty)shader);
                BufferViewModel bufferViewModel = this.getBufferViewModelById(bufferViewId);
                shaderModel.setShaderData(bufferViewModel.getBufferViewData());
                continue;
            }
            String uri = shader.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer shaderData = Buffers.create(data);
                shaderModel.setShaderData(shaderData);
                continue;
            }
            ByteBuffer shaderData = this.gltfAsset.getReferenceData(uri);
            shaderModel.setShaderData(shaderData);
        }
    }

    void initProgramModels() {
        Map programs = Optionals.of(this.gltf.getPrograms());
        for (Map.Entry entry : programs.entrySet()) {
            String programId = (String)entry.getKey();
            Program program = (Program)entry.getValue();
            DefaultProgramModel programModel = this.get("programs", programId, this.programModels);
            programModel.setName(program.getName());
            String vertexShaderId = program.getVertexShader();
            DefaultShaderModel vertexShaderModel = this.get("shaders", vertexShaderId, this.shaderModels);
            programModel.setVertexShaderModel(vertexShaderModel);
            String fragmentShaderId = program.getFragmentShader();
            DefaultShaderModel fragmentShaderModel = this.get("shaders", fragmentShaderId, this.shaderModels);
            programModel.setFragmentShaderModel(fragmentShaderModel);
        }
    }

    private void addParameters(Technique technique, DefaultTechniqueModel techniqueModel) {
        Map parameters = Optionals.of(technique.getParameters());
        for (Map.Entry entry : parameters.entrySet()) {
            String parameterName = (String)entry.getKey();
            TechniqueParameters parameter = (TechniqueParameters)entry.getValue();
            int type = parameter.getType();
            int count = Optionals.of(parameter.getCount(), 1);
            String semantic = parameter.getSemantic();
            Object value = parameter.getValue();
            String nodeId = parameter.getNode();
            NodeModel nodeModel = null;
            if (nodeId != null) {
                nodeModel = this.get("nodes", nodeId, this.nodeModels);
            }
            DefaultTechniqueParametersModel techniqueParametersModel = new DefaultTechniqueParametersModel(type, count, semantic, value, nodeModel);
            techniqueModel.addParameter(parameterName, techniqueParametersModel);
        }
    }

    private static void addAttributes(Technique technique, DefaultTechniqueModel techniqueModel) {
        Map attributes = Optionals.of(technique.getAttributes());
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            String parameterName = (String)entry.getValue();
            techniqueModel.addAttribute(attributeName, parameterName);
        }
    }

    private static void addUniforms(Technique technique, DefaultTechniqueModel techniqueModel) {
        Map uniforms = Optionals.of(technique.getUniforms());
        for (Map.Entry entry : uniforms.entrySet()) {
            String uniformName = (String)entry.getKey();
            String parameterName = (String)entry.getValue();
            techniqueModel.addUniform(uniformName, parameterName);
        }
    }

    private void initTechniqueModels() {
        Map techniques = Optionals.of(this.gltf.getTechniques());
        for (Map.Entry entry : techniques.entrySet()) {
            String techniqueId = (String)entry.getKey();
            Technique technique = (Technique)entry.getValue();
            DefaultTechniqueModel techniqueModel = this.get("techniques", techniqueId, this.techniqueModels);
            techniqueModel.setName(technique.getName());
            String programId = technique.getProgram();
            DefaultProgramModel programModel = this.get("programs", programId, this.programModels);
            techniqueModel.setProgramModel(programModel);
            this.addParameters(technique, techniqueModel);
            GltfModelV1.addAttributes(technique, techniqueModel);
            GltfModelV1.addUniforms(technique, techniqueModel);
            List<Integer> enable = Techniques.obtainEnabledStates(technique);
            TechniqueStatesFunctions functions = Techniques.obtainTechniqueStatesFunctions(technique);
            DefaultTechniqueStatesFunctionsModelV1 techniqueStatesFunctionsModel = new DefaultTechniqueStatesFunctionsModelV1(functions);
            DefaultTechniqueStatesModel techniqueStatesModel = new DefaultTechniqueStatesModel(enable, techniqueStatesFunctionsModel);
            techniqueModel.setTechniqueStatesModel(techniqueStatesModel);
        }
    }

    private void initMaterialModels() {
        Map materials = Optionals.of(this.gltf.getMaterials());
        for (Map.Entry entry : materials.entrySet()) {
            String materialId = (String)entry.getKey();
            Material material = (Material)entry.getValue();
            DefaultMaterialModel materialModel = this.get("materials", materialId, this.materialModels);
            materialModel.setValues(material.getValues());
            materialModel.setName(material.getName());
            String techniqueId = material.getTechnique();
            if (techniqueId == null || GltfDefaults.isDefaultTechniqueId(techniqueId)) {
                materialModel.setTechniqueModel(DefaultModels.getDefaultTechniqueModel());
                continue;
            }
            DefaultTechniqueModel techniqueModel = this.get("techniques", techniqueId, this.techniqueModels);
            materialModel.setTechniqueModel(techniqueModel);
        }
    }

    private void instantiateCameraModels() {
        Map nodes = Optionals.of(this.gltf.getNodes());
        Map cameras = Optionals.of(this.gltf.getCameras());
        for (Map.Entry entry : nodes.entrySet()) {
            String nodeId = (String)entry.getKey();
            Node node = (Node)entry.getValue();
            String cameraId = node.getCamera();
            if (cameraId == null) continue;
            Camera camera = (Camera)cameras.get(cameraId);
            NodeModel nodeModel = this.get("nodes", nodeId, this.nodeModels);
            Function<float[], float[]> viewMatrixComputer = result -> {
                float[] localResult = Utils.validate(result, 16);
                nodeModel.computeGlobalTransform(localResult);
                MathUtils.invert4x4(localResult, localResult);
                return localResult;
            };
            BiFunction<float[], Float, float[]> projectionMatrixComputer = (result, aspectRatio) -> {
                float[] localResult = Utils.validate(result, 16);
                CamerasV1.computeProjectionMatrix(camera, aspectRatio, localResult);
                return localResult;
            };
            DefaultCameraModel cameraModel = new DefaultCameraModel(viewMatrixComputer, projectionMatrixComputer);
            cameraModel.setName(camera.getName());
            cameraModel.setNodeModel(nodeModel);
            String nodeName = Optionals.of(node.getName(), nodeId);
            String cameraName = Optionals.of(camera.getName(), cameraId);
            String instanceName = nodeName + "." + cameraName;
            cameraModel.setInstanceName(instanceName);
            this.cameraModels.add(cameraModel);
        }
    }

    @Override
    public List<AccessorModel> getAccessorModels() {
        return Collections.unmodifiableList(this.accessorModels);
    }

    @Override
    public List<AnimationModel> getAnimationModels() {
        return Collections.unmodifiableList(this.animationModels);
    }

    @Override
    public List<BufferModel> getBufferModels() {
        return Collections.unmodifiableList(this.bufferModels);
    }

    @Override
    public List<BufferViewModel> getBufferViewModels() {
        return Collections.unmodifiableList(this.bufferViewModels);
    }

    @Override
    public List<CameraModel> getCameraModels() {
        return Collections.unmodifiableList(this.cameraModels);
    }

    @Override
    public List<ImageModel> getImageModels() {
        return Collections.unmodifiableList(this.imageModels);
    }

    @Override
    public List<MaterialModel> getMaterialModels() {
        return Collections.unmodifiableList(this.materialModels);
    }

    @Override
    public List<NodeModel> getNodeModels() {
        return Collections.unmodifiableList(this.nodeModels);
    }

    @Override
    public List<SceneModel> getSceneModels() {
        return Collections.unmodifiableList(this.sceneModels);
    }

    @Override
    public List<TextureModel> getTextureModels() {
        return Collections.unmodifiableList(this.textureModels);
    }

    public List<ShaderModel> getShaderModels() {
        return Collections.unmodifiableList(this.shaderModels);
    }

    public GlTF getGltf() {
        return this.gltf;
    }

    private <T> T get(String name, String id, List<T> list) {
        Integer index = this.indexMappingSet.getIndex(name, id);
        if (index == null) {
            logger.severe("No index found for " + name + " ID " + id);
            return null;
        }
        if (index < 0 || index >= list.size()) {
            logger.severe("Index for " + name + " ID " + id + " is " + index + ", but must be in [0, " + list.size() + ")");
            return null;
        }
        T element = list.get(index);
        return element;
    }
}

