/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.v1;

import de.javagl.jgltf.impl.v1.GlTFProperty;
import de.javagl.jgltf.impl.v1.Image;
import de.javagl.jgltf.model.GltfException;
import de.javagl.jgltf.model.io.ImageReaders;
import de.javagl.jgltf.model.v1.GltfExtensionsV1;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageReader;

public class BinaryGltfV1 {
    private static final String KHRONOS_BINARY_GLTF_EXTENSION_NAME = "KHR_binary_glTF";
    private static final String BINARY_GLTF_BUFFER_ID = "binary_glTF";

    public static boolean hasBinaryGltfExtension(GlTFProperty gltfProperty) {
        return GltfExtensionsV1.hasExtension(gltfProperty, KHRONOS_BINARY_GLTF_EXTENSION_NAME);
    }

    static String getBinaryGltfBufferViewId(GlTFProperty gltfProperty) {
        return GltfExtensionsV1.getExtensionPropertyValueAsString(gltfProperty, KHRONOS_BINARY_GLTF_EXTENSION_NAME, "bufferView");
    }

    public static void setBinaryGltfBufferViewId(GlTFProperty gltfProperty, String bufferViewId) {
        GltfExtensionsV1.setExtensionPropertyValue(gltfProperty, KHRONOS_BINARY_GLTF_EXTENSION_NAME, "bufferView", bufferViewId);
    }

    public static void setBinaryGltfImageProperties(Image image, ByteBuffer imageData) {
        ImageReader imageReader = null;
        try {
            imageReader = ImageReaders.findImageReader(imageData);
            int width = imageReader.getWidth(0);
            int height = imageReader.getHeight(0);
            String mimeType = "image/" + imageReader.getFormatName();
            GltfExtensionsV1.setExtensionPropertyValue((GlTFProperty)image, KHRONOS_BINARY_GLTF_EXTENSION_NAME, "width", width);
            GltfExtensionsV1.setExtensionPropertyValue((GlTFProperty)image, KHRONOS_BINARY_GLTF_EXTENSION_NAME, "height", height);
            GltfExtensionsV1.setExtensionPropertyValue((GlTFProperty)image, KHRONOS_BINARY_GLTF_EXTENSION_NAME, "mimeType", mimeType);
        }
        catch (IOException e) {
            throw new GltfException("Could not derive image properties for binary glTF", e);
        }
        finally {
            if (imageReader != null) {
                imageReader.dispose();
            }
        }
    }

    public static String getBinaryGltfExtensionName() {
        return KHRONOS_BINARY_GLTF_EXTENSION_NAME;
    }

    public static String getBinaryGltfBufferId() {
        return BINARY_GLTF_BUFFER_ID;
    }

    public static boolean isBinaryGltfBufferId(String id) {
        return BINARY_GLTF_BUFFER_ID.equals(id);
    }

    private BinaryGltfV1() {
    }
}

