/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io.v2;

import de.javagl.jgltf.impl.v2.Buffer;
import de.javagl.jgltf.impl.v2.GlTF;
import de.javagl.jgltf.impl.v2.Image;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.GltfException;
import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.io.MimeTypes;
import de.javagl.jgltf.model.io.v2.GltfAssetV2;
import de.javagl.jgltf.model.io.v2.GltfUtilsV2;
import de.javagl.jgltf.model.v2.GltfModelV2;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;

final class EmbeddedAssetCreatorV2 {
    EmbeddedAssetCreatorV2() {
    }

    GltfAssetV2 create(GltfModelV2 gltfModel) {
        GlTF inputGltf = gltfModel.getGltf();
        GlTF outputGltf = GltfUtilsV2.copy(inputGltf);
        List buffers = Optionals.of(outputGltf.getBuffers());
        for (int i = 0; i < buffers.size(); ++i) {
            Buffer buffer = (Buffer)buffers.get(i);
            EmbeddedAssetCreatorV2.convertBufferToEmbedded(gltfModel, i, buffer);
        }
        List images = Optionals.of(outputGltf.getImages());
        for (int i = 0; i < images.size(); ++i) {
            Image image = (Image)images.get(i);
            EmbeddedAssetCreatorV2.convertImageToEmbedded(gltfModel, i, image);
        }
        return new GltfAssetV2(outputGltf, null);
    }

    private static void convertBufferToEmbedded(GltfModelV2 gltfModel, int index, Buffer buffer) {
        String uriString = buffer.getUri();
        if (IO.isDataUriString(uriString)) {
            return;
        }
        BufferModel bufferModel = gltfModel.getBufferModels().get(index);
        ByteBuffer bufferData = bufferModel.getBufferData();
        byte[] data = new byte[bufferData.capacity()];
        bufferData.slice().get(data);
        String encodedData = Base64.getEncoder().encodeToString(data);
        String dataUriString = "data:application/gltf-buffer;base64," + encodedData;
        buffer.setUri(dataUriString);
    }

    private static void convertImageToEmbedded(GltfModelV2 gltfModel, int index, Image image) {
        String uriString = image.getUri();
        if (IO.isDataUriString(uriString)) {
            return;
        }
        ImageModel imageModel = gltfModel.getImageModels().get(index);
        ByteBuffer imageData = imageModel.getImageData();
        String uri = image.getUri();
        String imageMimeTypeString = MimeTypes.guessImageMimeTypeString(uri, imageData);
        if (imageMimeTypeString == null) {
            throw new GltfException("Could not detect MIME type of image " + index);
        }
        byte[] data = new byte[imageData.capacity()];
        imageData.slice().get(data);
        String encodedData = Base64.getEncoder().encodeToString(data);
        String dataUriString = "data:" + imageMimeTypeString + ";base64," + encodedData;
        image.setUri(dataUriString);
    }
}

