/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io.v1;

import de.javagl.jgltf.impl.v1.Buffer;
import de.javagl.jgltf.impl.v1.GlTF;
import de.javagl.jgltf.impl.v1.GlTFProperty;
import de.javagl.jgltf.impl.v1.Image;
import de.javagl.jgltf.impl.v1.Shader;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.GltfAsset;
import de.javagl.jgltf.model.io.GltfReference;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.v1.BinaryGltfV1;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public final class GltfAssetV1
implements GltfAsset {
    private final GlTF gltf;
    private final ByteBuffer binaryData;
    private final Map<String, ByteBuffer> referenceDatas;

    public GltfAssetV1(GlTF gltf, ByteBuffer binaryData) {
        this.gltf = Objects.requireNonNull(gltf, "The gltf may not be null");
        this.binaryData = binaryData;
        this.referenceDatas = new ConcurrentHashMap<String, ByteBuffer>();
    }

    void putReferenceData(String uriString, ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            this.referenceDatas.remove(uriString);
        } else {
            this.referenceDatas.put(uriString, byteBuffer);
        }
    }

    public GlTF getGltf() {
        return this.gltf;
    }

    @Override
    public ByteBuffer getBinaryData() {
        return Buffers.createSlice(this.binaryData);
    }

    @Override
    public List<GltfReference> getReferences() {
        ArrayList<GltfReference> references = new ArrayList<GltfReference>();
        references.addAll(this.getBufferReferences());
        references.addAll(this.getImageReferences());
        references.addAll(this.getShaderReferences());
        return references;
    }

    public List<GltfReference> getBufferReferences() {
        ArrayList<GltfReference> references = new ArrayList<GltfReference>();
        Map buffers = Optionals.of(this.gltf.getBuffers());
        for (Map.Entry entry : buffers.entrySet()) {
            Buffer buffer;
            String uri;
            String bufferId = (String)entry.getKey();
            if (BinaryGltfV1.isBinaryGltfBufferId(bufferId) || IO.isDataUriString(uri = (buffer = (Buffer)buffers.get(bufferId)).getUri())) continue;
            Consumer<ByteBuffer> target = byteBuffer -> this.putReferenceData(uri, (ByteBuffer)byteBuffer);
            GltfReference reference = new GltfReference(bufferId, uri, target);
            references.add(reference);
        }
        return references;
    }

    public List<GltfReference> getImageReferences() {
        ArrayList<GltfReference> references = new ArrayList<GltfReference>();
        Map images = Optionals.of(this.gltf.getImages());
        for (Map.Entry entry : images.entrySet()) {
            String uri;
            String imageId = (String)entry.getKey();
            Image image = (Image)entry.getValue();
            if (BinaryGltfV1.hasBinaryGltfExtension((GlTFProperty)image) || IO.isDataUriString(uri = image.getUri())) continue;
            Consumer<ByteBuffer> target = byteBuffer -> this.putReferenceData(uri, (ByteBuffer)byteBuffer);
            GltfReference reference = new GltfReference(imageId, uri, target);
            references.add(reference);
        }
        return references;
    }

    public List<GltfReference> getShaderReferences() {
        ArrayList<GltfReference> references = new ArrayList<GltfReference>();
        Map shaders = Optionals.of(this.gltf.getShaders());
        for (Map.Entry entry : shaders.entrySet()) {
            String uri;
            String shaderId = (String)entry.getKey();
            Shader shader = (Shader)entry.getValue();
            if (BinaryGltfV1.hasBinaryGltfExtension((GlTFProperty)shader) || IO.isDataUriString(uri = shader.getUri())) continue;
            Consumer<ByteBuffer> target = byteBuffer -> this.putReferenceData(uri, (ByteBuffer)byteBuffer);
            GltfReference reference = new GltfReference(shaderId, uri, target);
            references.add(reference);
        }
        return references;
    }

    @Override
    public ByteBuffer getReferenceData(String uriString) {
        return Buffers.createSlice(this.referenceDatas.get(uriString));
    }

    @Override
    public Map<String, ByteBuffer> getReferenceDatas() {
        return Collections.unmodifiableMap(this.referenceDatas);
    }
}

