/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.impl.creation;

import de.javagl.jgltf.impl.v1.Accessor;
import de.javagl.jgltf.impl.v1.Buffer;
import de.javagl.jgltf.impl.v1.BufferView;
import de.javagl.jgltf.model.AccessorData;
import de.javagl.jgltf.model.AccessorDatas;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.impl.creation.BufferStructure;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BufferStructureGltfV1 {
    public static Map<String, Accessor> createAccessors(BufferStructure bufferStructure) {
        List<AccessorModel> accessorModels = bufferStructure.getAccessorModels();
        LinkedHashMap<String, Accessor> accessors = new LinkedHashMap<String, Accessor>();
        for (AccessorModel accessorModel : accessorModels) {
            BufferViewModel bufferViewModel = accessorModel.getBufferViewModel();
            String bufferViewId = bufferStructure.getBufferViewId(bufferViewModel);
            String accessorId = bufferStructure.getAccessorId(accessorModel);
            Accessor accessor = BufferStructureGltfV1.createAccessor(accessorModel, bufferViewId);
            accessors.put(accessorId, accessor);
        }
        return accessors;
    }

    private static Accessor createAccessor(AccessorModel accessorModel, String bufferViewId) {
        Accessor accessor = new Accessor();
        accessor.setBufferView(bufferViewId);
        accessor.setByteOffset(Integer.valueOf(accessorModel.getByteOffset()));
        accessor.setComponentType(Integer.valueOf(accessorModel.getComponentType()));
        accessor.setCount(Integer.valueOf(accessorModel.getCount()));
        accessor.setType(accessorModel.getElementType().toString());
        accessor.setByteStride(Integer.valueOf(accessorModel.getByteStride()));
        AccessorData accessorData = accessorModel.getAccessorData();
        accessor.setMax(AccessorDatas.computeMax(accessorData));
        accessor.setMin(AccessorDatas.computeMin(accessorData));
        return accessor;
    }

    public static Map<String, BufferView> createBufferViews(BufferStructure bufferStructure) {
        List<BufferViewModel> bufferViewModels = bufferStructure.getBufferViewModels();
        LinkedHashMap<String, BufferView> bufferViews = new LinkedHashMap<String, BufferView>();
        for (BufferViewModel bufferViewModel : bufferViewModels) {
            BufferModel bufferModel = bufferViewModel.getBufferModel();
            String bufferId = bufferStructure.getBufferId(bufferModel);
            String bufferViewId = bufferStructure.getBufferViewId(bufferViewModel);
            BufferView bufferView = BufferStructureGltfV1.createBufferView(bufferViewModel, bufferId);
            bufferViews.put(bufferViewId, bufferView);
        }
        return bufferViews;
    }

    private static BufferView createBufferView(BufferViewModel bufferViewModel, String bufferId) {
        BufferView bufferView = new BufferView();
        bufferView.setBuffer(bufferId);
        bufferView.setByteOffset(Integer.valueOf(bufferViewModel.getByteOffset()));
        bufferView.setByteLength(Integer.valueOf(bufferViewModel.getByteLength()));
        bufferView.setTarget(bufferViewModel.getTarget());
        return bufferView;
    }

    public static Map<String, Buffer> createBuffers(BufferStructure bufferStructure) {
        List<BufferModel> bufferModels = bufferStructure.getBufferModels();
        LinkedHashMap<String, Buffer> buffers = new LinkedHashMap<String, Buffer>();
        for (BufferModel bufferModel : bufferModels) {
            String bufferId = bufferStructure.getBufferId(bufferModel);
            Buffer buffer = BufferStructureGltfV1.createBuffer(bufferModel);
            buffers.put(bufferId, buffer);
        }
        return buffers;
    }

    private static Buffer createBuffer(BufferModel bufferModel) {
        Buffer buffer = new Buffer();
        buffer.setUri(bufferModel.getUri());
        buffer.setByteLength(Integer.valueOf(bufferModel.getByteLength()));
        return buffer;
    }

    private BufferStructureGltfV1() {
    }
}

