/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.creation;

import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.creation.ImageModels;
import de.javagl.jgltf.model.impl.DefaultImageModel;
import de.javagl.jgltf.model.impl.DefaultTextureModel;
import de.javagl.jgltf.model.v2.MaterialModelV2;

public class MaterialBuilder {
    private MaterialModelV2 materialModel = new MaterialModelV2();

    public static MaterialBuilder create() {
        return new MaterialBuilder();
    }

    private MaterialBuilder() {
    }

    public MaterialBuilder setBaseColorFactor(float r, float g, float b, float a) {
        this.materialModel.setBaseColorFactor(new float[]{r, g, b, a});
        return this;
    }

    public MaterialBuilder setBaseColorTexture(String fileName, String uri, Integer texCoord) {
        DefaultImageModel imageModel = ImageModels.create(fileName, uri);
        DefaultTextureModel textureModel = new DefaultTextureModel();
        textureModel.setImageModel((ImageModel)imageModel);
        return this.setBaseColorTexture((TextureModel)textureModel, texCoord);
    }

    public MaterialBuilder setBaseColorTexture(TextureModel baseColorTexture, Integer texCoord) {
        this.materialModel.setBaseColorTexture(baseColorTexture);
        this.materialModel.setBaseColorTexcoord(texCoord);
        return this;
    }

    public MaterialBuilder setMetallicRoughnessFactors(float metallicFactor, float roughnessFactor) {
        this.materialModel.setMetallicFactor(metallicFactor);
        this.materialModel.setRoughnessFactor(roughnessFactor);
        return this;
    }

    public MaterialBuilder setMetallicRoughnessTexture(String fileName, String uri, Integer texCoord) {
        DefaultImageModel imageModel = ImageModels.create(fileName, uri);
        DefaultTextureModel textureModel = new DefaultTextureModel();
        textureModel.setImageModel((ImageModel)imageModel);
        return this.setMetallicRoughnessTexture((TextureModel)textureModel, texCoord);
    }

    public MaterialBuilder setMetallicRoughnessTexture(TextureModel metallicRoughnessTexture, Integer texCoord) {
        this.materialModel.setMetallicRoughnessTexture(metallicRoughnessTexture);
        this.materialModel.setMetallicRoughnessTexcoord(texCoord);
        return this;
    }

    public MaterialBuilder setNormalTexture(String fileName, String uri, float scale, Integer texCoord) {
        DefaultImageModel imageModel = ImageModels.create(fileName, uri);
        DefaultTextureModel textureModel = new DefaultTextureModel();
        textureModel.setImageModel((ImageModel)imageModel);
        return this.setNormalTexture((TextureModel)textureModel, scale, texCoord);
    }

    public MaterialBuilder setNormalTexture(TextureModel normalTexture, float scale, Integer texCoord) {
        this.materialModel.setNormalTexture(normalTexture);
        this.materialModel.setNormalScale(scale);
        this.materialModel.setNormalTexcoord(texCoord);
        return this;
    }

    public MaterialBuilder setOcclusionTexture(String fileName, String uri, float strength, Integer texCoord) {
        DefaultImageModel imageModel = ImageModels.create(fileName, uri);
        DefaultTextureModel textureModel = new DefaultTextureModel();
        textureModel.setImageModel((ImageModel)imageModel);
        return this.setOcclusionTexture((TextureModel)textureModel, strength, texCoord);
    }

    public MaterialBuilder setOcclusionTexture(TextureModel occlusionTexture, float strength, Integer texCoord) {
        this.materialModel.setOcclusionTexture(occlusionTexture);
        this.materialModel.setOcclusionStrength(strength);
        this.materialModel.setOcclusionTexcoord(texCoord);
        return this;
    }

    public MaterialBuilder setEmissiveTexture(String fileName, String uri, float r, float g, float b, Integer texCoord) {
        DefaultImageModel imageModel = ImageModels.create(fileName, uri);
        DefaultTextureModel textureModel = new DefaultTextureModel();
        textureModel.setImageModel((ImageModel)imageModel);
        return this.setEmissiveTexture((TextureModel)textureModel, r, g, b, texCoord);
    }

    public MaterialBuilder setEmissiveTexture(TextureModel emissiveTexture, float r, float g, float b, Integer texCoord) {
        this.materialModel.setEmissiveTexture(emissiveTexture);
        this.materialModel.setEmissiveFactor(new float[]{r, g, b});
        this.materialModel.setEmissiveTexcoord(texCoord);
        return this;
    }

    public MaterialBuilder setAlphaMode(MaterialModelV2.AlphaMode alphaMode) {
        this.materialModel.setAlphaMode(alphaMode);
        return this;
    }

    public MaterialBuilder setAlphaCutoff(float alphaCutoff) {
        this.materialModel.setAlphaCutoff(alphaCutoff);
        return this;
    }

    public MaterialBuilder setDoubleSided(boolean doubleSided) {
        this.materialModel.setDoubleSided(doubleSided);
        return this;
    }

    public MaterialModelV2 build() {
        MaterialModelV2 result = this.materialModel;
        this.materialModel = new MaterialModelV2();
        return result;
    }
}

