/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.creation;

import de.javagl.jgltf.model.image.ImageUtils;
import de.javagl.jgltf.model.image.PixelData;
import de.javagl.jgltf.model.image.PixelDatas;
import de.javagl.jgltf.model.impl.DefaultImageModel;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.io.MimeTypes;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImageModels {
    private static final Logger logger = Logger.getLogger(ImageModels.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DefaultImageModel create(String fileName, String uri, String mimeType) {
        try (FileInputStream inputStream = new FileInputStream(fileName);){
            byte[] data = IO.readStream((InputStream)inputStream);
            PixelData pixelData = PixelDatas.create((ByteBuffer)ByteBuffer.wrap(data));
            DefaultImageModel defaultImageModel = ImageModels.create(uri, mimeType, pixelData);
            return defaultImageModel;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            return null;
        }
    }

    public static DefaultImageModel create(String uri, String mimeType, PixelData pixelData) {
        ByteBuffer imageData = ImageUtils.createImageDataBuffer((PixelData)pixelData, (String)mimeType);
        DefaultImageModel imageModel = new DefaultImageModel();
        imageModel.setImageData(imageData);
        imageModel.setUri(uri);
        imageModel.setMimeType(mimeType);
        return imageModel;
    }

    public static DefaultImageModel create(String inputUri, String uri) {
        byte[] data = null;
        try {
            URI localInputUri = URI.create(inputUri);
            if (!localInputUri.isAbsolute()) {
                localInputUri = Paths.get(inputUri, new String[0]).toUri().normalize();
            }
            data = IO.read((URI)localInputUri);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            return null;
        }
        ByteBuffer imageData = Buffers.create((byte[])data);
        String mimeType = MimeTypes.guessImageMimeTypeString((String)inputUri, (ByteBuffer)imageData);
        if (mimeType == null) {
            logger.severe("Could not detect MIME type of " + inputUri);
            return null;
        }
        DefaultImageModel imageModel = new DefaultImageModel();
        imageModel.setImageData(imageData);
        imageModel.setUri(uri);
        imageModel.setMimeType(mimeType);
        return imageModel;
    }

    private ImageModels() {
    }
}

