/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.creation;

import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.AnimationModel;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.CameraModel;
import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.MeshModel;
import de.javagl.jgltf.model.MeshPrimitiveModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.SceneModel;
import de.javagl.jgltf.model.SkinModel;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.creation.DefaultBufferBuilderStrategy;
import de.javagl.jgltf.model.gl.ProgramModel;
import de.javagl.jgltf.model.gl.ShaderModel;
import de.javagl.jgltf.model.gl.TechniqueModel;
import de.javagl.jgltf.model.gl.impl.DefaultProgramModel;
import de.javagl.jgltf.model.gl.impl.DefaultShaderModel;
import de.javagl.jgltf.model.gl.impl.DefaultTechniqueModel;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.impl.DefaultAnimationModel;
import de.javagl.jgltf.model.impl.DefaultBufferModel;
import de.javagl.jgltf.model.impl.DefaultBufferViewModel;
import de.javagl.jgltf.model.impl.DefaultCameraModel;
import de.javagl.jgltf.model.impl.DefaultGltfModel;
import de.javagl.jgltf.model.impl.DefaultImageModel;
import de.javagl.jgltf.model.impl.DefaultMeshModel;
import de.javagl.jgltf.model.impl.DefaultNodeModel;
import de.javagl.jgltf.model.impl.DefaultSceneModel;
import de.javagl.jgltf.model.impl.DefaultSkinModel;
import de.javagl.jgltf.model.impl.DefaultTextureModel;
import de.javagl.jgltf.model.v1.GltfModelV1;
import de.javagl.jgltf.model.v1.MaterialModelV1;
import de.javagl.jgltf.model.v2.MaterialModelV2;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GltfModelBuilder {
    private final Set<DefaultAnimationModel> animationModelsSet = new LinkedHashSet<DefaultAnimationModel>();
    private final Set<DefaultCameraModel> cameraModelsSet = new LinkedHashSet<DefaultCameraModel>();
    private final Set<DefaultImageModel> imageModelsSet = new LinkedHashSet<DefaultImageModel>();
    private final Set<MaterialModel> materialModelsSet = new LinkedHashSet<MaterialModel>();
    private final Set<DefaultMeshModel> meshModelsSet = new LinkedHashSet<DefaultMeshModel>();
    private final Set<DefaultNodeModel> nodeModelsSet = new LinkedHashSet<DefaultNodeModel>();
    private final Set<DefaultSceneModel> sceneModelsSet = new LinkedHashSet<DefaultSceneModel>();
    private final Set<DefaultSkinModel> skinModelsSet = new LinkedHashSet<DefaultSkinModel>();
    private final Set<DefaultTextureModel> textureModelsSet = new LinkedHashSet<DefaultTextureModel>();
    private final Set<DefaultTechniqueModel> techniqueModelsSet = new LinkedHashSet<DefaultTechniqueModel>();
    private final Set<DefaultProgramModel> programModelsSet = new LinkedHashSet<DefaultProgramModel>();
    private final Set<DefaultShaderModel> shaderModelsSet = new LinkedHashSet<DefaultShaderModel>();
    private final Set<DefaultAccessorModel> accessorModelsSet = new LinkedHashSet<DefaultAccessorModel>();
    private final Set<DefaultBufferViewModel> bufferViewModelsSet = new LinkedHashSet<DefaultBufferViewModel>();
    private final Set<DefaultBufferModel> bufferModelsSet = new LinkedHashSet<DefaultBufferModel>();

    public static GltfModelBuilder create() {
        return new GltfModelBuilder();
    }

    private GltfModelBuilder() {
    }

    public DefaultGltfModel buildV1() {
        GltfModelV1 gltfModel = new GltfModelV1();
        this.fill((DefaultGltfModel)gltfModel);
        gltfModel.addTechniqueModels(this.techniqueModelsSet);
        gltfModel.addProgramModels(this.programModelsSet);
        gltfModel.addShaderModels(this.shaderModelsSet);
        return gltfModel;
    }

    public DefaultGltfModel build() {
        DefaultGltfModel gltfModel = new DefaultGltfModel();
        this.fill(gltfModel);
        return gltfModel;
    }

    private void fill(DefaultGltfModel gltfModel) {
        DefaultBufferBuilderStrategy bufferBuilderStrategy = new DefaultBufferBuilderStrategy();
        bufferBuilderStrategy.processMeshModels(this.meshModelsSet);
        bufferBuilderStrategy.processImageModels(this.imageModelsSet);
        bufferBuilderStrategy.processAnimationModels(this.animationModelsSet);
        bufferBuilderStrategy.processSkinModels(this.skinModelsSet);
        bufferBuilderStrategy.commitBuffer("buffer.bin");
        bufferBuilderStrategy.finish();
        gltfModel.addAnimationModels(this.animationModelsSet);
        gltfModel.addCameraModels(this.cameraModelsSet);
        gltfModel.addImageModels(this.imageModelsSet);
        gltfModel.addMaterialModels(this.materialModelsSet);
        gltfModel.addMeshModels(this.meshModelsSet);
        gltfModel.addNodeModels(this.nodeModelsSet);
        gltfModel.addSceneModels(this.sceneModelsSet);
        gltfModel.addSkinModels(this.skinModelsSet);
        gltfModel.addTextureModels(this.textureModelsSet);
        gltfModel.addAccessorModels(bufferBuilderStrategy.getAccessorModels());
        gltfModel.addBufferViewModels(bufferBuilderStrategy.getBufferViewModels());
        gltfModel.addBufferModels(bufferBuilderStrategy.getBufferModels());
        gltfModel.addAccessorModels(this.accessorModelsSet);
        gltfModel.addBufferViewModels(this.bufferViewModelsSet);
        gltfModel.addBufferModels(this.bufferModelsSet);
    }

    public void addAnimationModel(AnimationModel animationModel) {
        if (animationModel == null) {
            return;
        }
        DefaultAnimationModel defaultAnimationModel = (DefaultAnimationModel)animationModel;
        boolean added = this.animationModelsSet.add(defaultAnimationModel);
        if (added) {
            for (AnimationModel.Channel channel : animationModel.getChannels()) {
                this.addNodeModel(channel.getNodeModel());
            }
        }
    }

    public void addAnimationModels(Collection<? extends AnimationModel> animationModels) {
        for (AnimationModel animationModel : animationModels) {
            this.addAnimationModel(animationModel);
        }
    }

    public void addCameraModel(CameraModel cameraModel) {
        if (cameraModel == null) {
            return;
        }
        DefaultCameraModel defaultCameraModel = (DefaultCameraModel)cameraModel;
        this.cameraModelsSet.add(defaultCameraModel);
    }

    public void addCameraModels(Collection<? extends CameraModel> cameraModels) {
        for (CameraModel cameraModel : cameraModels) {
            this.addCameraModel(cameraModel);
        }
    }

    public void addImageModel(ImageModel imageModel) {
        if (imageModel == null) {
            return;
        }
        DefaultImageModel defaultImageModel = (DefaultImageModel)imageModel;
        this.imageModelsSet.add(defaultImageModel);
    }

    public void addImageModels(Collection<? extends ImageModel> imageModels) {
        for (ImageModel imageModel : imageModels) {
            this.addImageModel(imageModel);
        }
    }

    public void addMaterialModel(MaterialModel materialModel) {
        if (materialModel == null) {
            return;
        }
        boolean added = this.materialModelsSet.add(materialModel);
        if (added) {
            if (materialModel instanceof MaterialModelV1) {
                MaterialModelV1 materialModelV1 = (MaterialModelV1)materialModel;
                this.addTechniqueModel(materialModelV1.getTechniqueModel());
                Map values = materialModelV1.getValues();
                for (Object value : values.values()) {
                    if (!(value instanceof TextureModel)) continue;
                    TextureModel textureModel = (TextureModel)value;
                    this.addTextureModel(textureModel);
                }
            }
            if (materialModel instanceof MaterialModelV2) {
                MaterialModelV2 materialModelV2 = (MaterialModelV2)materialModel;
                this.addTextureModel(materialModelV2.getBaseColorTexture());
                this.addTextureModel(materialModelV2.getOcclusionTexture());
                this.addTextureModel(materialModelV2.getMetallicRoughnessTexture());
                this.addTextureModel(materialModelV2.getEmissiveTexture());
            }
        }
    }

    public void addMaterialModels(Collection<? extends MaterialModel> materialModels) {
        for (MaterialModel materialModel : materialModels) {
            this.addMaterialModel(materialModel);
        }
    }

    public void addMeshModel(MeshModel meshModel) {
        if (meshModel == null) {
            return;
        }
        DefaultMeshModel defaultMeshModel = (DefaultMeshModel)meshModel;
        boolean added = this.meshModelsSet.add(defaultMeshModel);
        if (added) {
            List meshPrimitives = meshModel.getMeshPrimitiveModels();
            for (MeshPrimitiveModel meshPrimitive : meshPrimitives) {
                this.addMaterialModel(meshPrimitive.getMaterialModel());
            }
        }
    }

    public void addMeshModels(Collection<? extends MeshModel> meshModels) {
        for (MeshModel meshModel : meshModels) {
            this.addMeshModel(meshModel);
        }
    }

    public void addNodeModel(NodeModel nodeModel) {
        if (nodeModel == null) {
            return;
        }
        DefaultNodeModel defaultNodeModel = (DefaultNodeModel)nodeModel;
        boolean added = this.nodeModelsSet.add(defaultNodeModel);
        if (added) {
            this.addCameraModel(nodeModel.getCameraModel());
            this.addMeshModels(nodeModel.getMeshModels());
            this.addNodeModels(nodeModel.getChildren());
            this.addSkinModel(nodeModel.getSkinModel());
        }
    }

    public void addNodeModels(Collection<? extends NodeModel> nodeModels) {
        for (NodeModel nodeModel : nodeModels) {
            this.addNodeModel(nodeModel);
        }
    }

    public void addSceneModel(SceneModel sceneModel) {
        if (sceneModel == null) {
            return;
        }
        DefaultSceneModel defaultSceneModel = (DefaultSceneModel)sceneModel;
        boolean added = this.sceneModelsSet.add(defaultSceneModel);
        if (added) {
            this.addNodeModels(sceneModel.getNodeModels());
        }
    }

    public void addSceneModels(Collection<? extends SceneModel> sceneModels) {
        for (SceneModel sceneModel : sceneModels) {
            this.addSceneModel(sceneModel);
        }
    }

    public void addSkinModel(SkinModel skinModel) {
        if (skinModel == null) {
            return;
        }
        DefaultSkinModel defaultSkinModel = (DefaultSkinModel)skinModel;
        boolean added = this.skinModelsSet.add(defaultSkinModel);
        if (added) {
            this.addNodeModels(skinModel.getJoints());
            this.addNodeModel(skinModel.getSkeleton());
        }
    }

    public void addSkinModels(Collection<? extends SkinModel> skinModels) {
        for (SkinModel skinModel : skinModels) {
            this.addSkinModel(skinModel);
        }
    }

    public void addTextureModel(TextureModel textureModel) {
        if (textureModel == null) {
            return;
        }
        DefaultTextureModel defaultTextureModel = (DefaultTextureModel)textureModel;
        boolean added = this.textureModelsSet.add(defaultTextureModel);
        if (added) {
            this.addImageModel(textureModel.getImageModel());
        }
    }

    public void addTextureModels(Collection<? extends TextureModel> textureModels) {
        for (TextureModel textureModel : textureModels) {
            this.addTextureModel(textureModel);
        }
    }

    public void addTechniqueModel(TechniqueModel techniqueModel) {
        if (techniqueModel == null) {
            return;
        }
        DefaultTechniqueModel defaultTechniqueModel = (DefaultTechniqueModel)techniqueModel;
        boolean added = this.techniqueModelsSet.add(defaultTechniqueModel);
        if (added) {
            this.addProgramModel(techniqueModel.getProgramModel());
        }
    }

    public void addTechniqueModels(Collection<? extends TechniqueModel> techniqueModels) {
        for (TechniqueModel techniqueModel : techniqueModels) {
            this.addTechniqueModel(techniqueModel);
        }
    }

    public void addProgramModel(ProgramModel programModel) {
        if (programModel == null) {
            return;
        }
        DefaultProgramModel defaultProgramModel = (DefaultProgramModel)programModel;
        boolean added = this.programModelsSet.add(defaultProgramModel);
        if (added) {
            this.addShaderModel(programModel.getVertexShaderModel());
            this.addShaderModel(programModel.getFragmentShaderModel());
        }
    }

    public void addProgramModels(Collection<? extends ProgramModel> programModels) {
        for (ProgramModel programModel : programModels) {
            this.addProgramModel(programModel);
        }
    }

    public void addShaderModel(ShaderModel shaderModel) {
        if (shaderModel == null) {
            return;
        }
        DefaultShaderModel defaultShaderModel = (DefaultShaderModel)shaderModel;
        this.shaderModelsSet.add(defaultShaderModel);
    }

    public void addShaderModels(Collection<? extends ShaderModel> shaderModels) {
        for (ShaderModel shaderModel : shaderModels) {
            this.addShaderModel(shaderModel);
        }
    }

    public void addAccessorModel(AccessorModel accessorModel) {
        DefaultAccessorModel defaultAccessorModel = (DefaultAccessorModel)accessorModel;
        this.accessorModelsSet.add(defaultAccessorModel);
    }

    public void addAccessorModels(Collection<? extends AccessorModel> accessorModels) {
        for (AccessorModel accessorModel : accessorModels) {
            this.addAccessorModel(accessorModel);
        }
    }

    public void addBufferViewModel(BufferViewModel bufferViewModel) {
        DefaultBufferViewModel defaultBufferViewModel = (DefaultBufferViewModel)bufferViewModel;
        this.bufferViewModelsSet.add(defaultBufferViewModel);
    }

    public void addBufferViewModels(Collection<? extends BufferViewModel> bufferViewModels) {
        for (BufferViewModel bufferViewModel : bufferViewModels) {
            this.addBufferViewModel(bufferViewModel);
        }
    }

    public void addBufferModel(BufferModel bufferModel) {
        DefaultBufferModel defaultBufferModel = (DefaultBufferModel)bufferModel;
        this.bufferModelsSet.add(defaultBufferModel);
    }

    public void addBufferModels(Collection<? extends BufferModel> bufferModels) {
        for (BufferModel bufferModel : bufferModels) {
            this.addBufferModel(bufferModel);
        }
    }
}

