/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.creation;

import de.javagl.jgltf.model.AccessorData;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.ElementType;
import de.javagl.jgltf.model.creation.AccessorModels;
import de.javagl.jgltf.model.creation.BufferStructure;
import de.javagl.jgltf.model.creation.Utils;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.impl.DefaultBufferModel;
import de.javagl.jgltf.model.impl.DefaultBufferViewModel;
import de.javagl.jgltf.model.io.Buffers;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public final class BufferStructureBuilder {
    private static final Logger logger = Logger.getLogger(BufferStructureBuilder.class.getName());
    private final BufferStructure bufferStructure = new BufferStructure();
    private final List<DefaultAccessorModel> currentAccessorModels = new ArrayList<DefaultAccessorModel>();
    private final List<DefaultBufferViewModel> currentBufferViewModels = new ArrayList<DefaultBufferViewModel>();

    public int getNumAccessorModels() {
        return this.bufferStructure.getAccessorModels().size();
    }

    public int getNumBufferViewModels() {
        return this.bufferStructure.getBufferViewModels().size();
    }

    public int getNumBufferModels() {
        return this.bufferStructure.getBufferModels().size();
    }

    public AccessorModel createAccessorModel(String idPrefix, float[] data, String type) {
        ElementType elementType = ElementType.valueOf((String)type);
        int numComponents = elementType.getNumComponents();
        if (data.length % numComponents != 0) {
            throw new IllegalArgumentException("Invalid data for type " + type + ". The data.length is not divisble by " + numComponents);
        }
        int componentType = 5126;
        ByteBuffer byteBuffer = Buffers.createByteBufferFrom((FloatBuffer)FloatBuffer.wrap(data));
        return this.createAccessorModel(idPrefix, componentType, type, byteBuffer);
    }

    public AccessorModel createAccessorModel(String idPrefix, int[] data, String type) {
        ElementType elementType = ElementType.valueOf((String)type);
        int numComponents = elementType.getNumComponents();
        if (data.length % numComponents != 0) {
            throw new IllegalArgumentException("Invalid data for type " + type + ". The data.length is not divisble by " + numComponents);
        }
        int componentType = 5125;
        ByteBuffer byteBuffer = Buffers.createByteBufferFrom((IntBuffer)IntBuffer.wrap(data));
        return this.createAccessorModel(idPrefix, componentType, type, byteBuffer);
    }

    public AccessorModel createAccessorModel(String idPrefix, short[] data, String type) {
        ElementType elementType = ElementType.valueOf((String)type);
        int numComponents = elementType.getNumComponents();
        if (data.length % numComponents != 0) {
            throw new IllegalArgumentException("Invalid data for type " + type + ". The data.length is not divisble by " + numComponents);
        }
        int componentType = 5123;
        ByteBuffer byteBuffer = Buffers.createByteBufferFrom((ShortBuffer)ShortBuffer.wrap(data));
        return this.createAccessorModel(idPrefix, componentType, type, byteBuffer);
    }

    public AccessorModel createAccessorModel(String idPrefix, byte[] data, String type) {
        ElementType elementType = ElementType.valueOf((String)type);
        int numComponents = elementType.getNumComponents();
        if (data.length % numComponents != 0) {
            throw new IllegalArgumentException("Invalid data for type " + type + ". The data.length is not divisble by " + numComponents);
        }
        int componentType = 5121;
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        return this.createAccessorModel(idPrefix, componentType, type, byteBuffer);
    }

    public AccessorModel createAccessorModel(String idPrefix, int componentType, String type, ByteBuffer byteBuffer) {
        DefaultAccessorModel accessorModel = AccessorModels.create(componentType, type, false, byteBuffer);
        this.addAccessorModel(idPrefix, accessorModel);
        return accessorModel;
    }

    public void addAccessorModel(String idPrefix, DefaultAccessorModel accessorModel) {
        this.bufferStructure.addAccessorModel(accessorModel, idPrefix);
        this.currentAccessorModels.add(accessorModel);
    }

    public BufferViewModel createArrayBufferViewModel(String idPrefix) {
        return this.createBufferViewModel(idPrefix, 34962);
    }

    public BufferViewModel createArrayElementBufferViewModel(String idPrefix) {
        return this.createBufferViewModel(idPrefix, 34963);
    }

    public BufferViewModel createBufferViewModel(String idPrefix, Integer target) {
        DefaultBufferViewModel bufferViewModel = new DefaultBufferViewModel(target);
        this.addBufferViewModel(idPrefix, bufferViewModel);
        return bufferViewModel;
    }

    public void addBufferViewModel(String idPrefix, DefaultBufferViewModel bufferViewModel) {
        for (DefaultAccessorModel accessorModel : this.currentAccessorModels) {
            accessorModel.setBufferViewModel((BufferViewModel)bufferViewModel);
        }
        this.bufferStructure.addBufferViewModel(bufferViewModel, idPrefix, this.currentAccessorModels);
        this.currentBufferViewModels.add(bufferViewModel);
        this.currentAccessorModels.clear();
    }

    public BufferModel createBufferModel(String idPrefix, String uri) {
        if (this.currentBufferViewModels.isEmpty()) {
            return null;
        }
        DefaultBufferModel bufferModel = new DefaultBufferModel();
        bufferModel.setUri(uri);
        this.addBufferModel(idPrefix, bufferModel);
        return bufferModel;
    }

    public void addBufferModel(String idPrefix, DefaultBufferModel bufferModel) {
        for (DefaultBufferViewModel bufferViewModel : this.currentBufferViewModels) {
            bufferViewModel.setBufferModel((BufferModel)bufferModel);
        }
        this.bufferStructure.addBufferModel(bufferModel, idPrefix, this.currentBufferViewModels);
        this.currentBufferViewModels.clear();
    }

    public BufferStructure build() {
        if (!this.currentBufferViewModels.isEmpty()) {
            throw new IllegalStateException("There are " + this.currentBufferViewModels.size() + " buffer views for which no buffer has been created yet. The 'createBufferModel' method must be called before building the buffer structure");
        }
        this.buildDefault();
        return this.bufferStructure;
    }

    private void buildDefault() {
        List<DefaultBufferModel> bufferModels = this.bufferStructure.getBufferModels();
        for (DefaultBufferModel bufferModel : bufferModels) {
            this.processBufferModel(bufferModel);
        }
    }

    private void processBufferModel(DefaultBufferModel bufferModel) {
        LinkedHashMap<DefaultAccessorModel, ByteBuffer> rawAccessorModelByteBuffers = new LinkedHashMap<DefaultAccessorModel, ByteBuffer>();
        for (DefaultAccessorModel accessorModel : this.bufferStructure.getAccessorModels()) {
            AccessorData accessorData = accessorModel.getAccessorData();
            ByteBuffer byteBuffer = accessorData.createByteBuffer();
            rawAccessorModelByteBuffers.put(accessorModel, byteBuffer);
        }
        ArrayList<ByteBuffer> bufferElements = new ArrayList<ByteBuffer>();
        List<DefaultBufferViewModel> bufferViewModels = this.bufferStructure.getBufferViewModels((BufferModel)bufferModel);
        int accumulatedBufferBytes = 0;
        for (DefaultBufferViewModel bufferViewModel : bufferViewModels) {
            List<DefaultAccessorModel> accessorModels = this.bufferStructure.getAccessorModels((BufferViewModel)bufferViewModel);
            int bufferViewAlignmnentBytes = AccessorModels.computeAlignmentBytes(accessorModels);
            int paddingBytesForBuffer = Utils.computePadding(accumulatedBufferBytes, bufferViewAlignmnentBytes);
            this.bufferStructure.addPaddingByteIndices(bufferModel, accumulatedBufferBytes, paddingBytesForBuffer);
            bufferElements.add(ByteBuffer.allocate(paddingBytesForBuffer));
            bufferViewModel.setByteOffset(accumulatedBufferBytes += paddingBytesForBuffer);
            Integer commonByteStride = null;
            Integer target = bufferViewModel.getTarget();
            boolean targetIsVertexAttribute = Objects.equals(34962, target);
            if (targetIsVertexAttribute) {
                commonByteStride = AccessorModels.computeCommonVertexAttributeByteStride(accessorModels);
                for (DefaultAccessorModel accessorModel : accessorModels) {
                    int oldByteStride = accessorModel.getByteStride();
                    if (oldByteStride == commonByteStride) continue;
                    accessorModel.setByteStride(commonByteStride.intValue());
                    bufferViewModel.setByteStride(commonByteStride);
                }
                if (accessorModels.size() > 1) {
                    bufferViewModel.setByteStride(commonByteStride);
                }
            }
            int accumulatedBufferViewBytes = 0;
            for (DefaultAccessorModel accessorModel : accessorModels) {
                ByteBuffer rawAccessorByteBuffer;
                int accessorAlignmentBytes = AccessorModels.computeAlignmentBytes((AccessorModel)accessorModel);
                int paddingBytesForBufferView = Utils.computePadding(accumulatedBufferViewBytes, accessorAlignmentBytes);
                if (paddingBytesForBufferView != 0) {
                    logger.warning("Inserting " + paddingBytesForBufferView + " padding bytes for buffer view, due to accessor " + accessorModel);
                }
                this.bufferStructure.addPaddingByteIndices(bufferModel, accumulatedBufferBytes, paddingBytesForBufferView);
                accessorModel.setByteOffset(accumulatedBufferViewBytes += paddingBytesForBufferView);
                ByteBuffer accessorByteBuffer = rawAccessorByteBuffer = (ByteBuffer)rawAccessorModelByteBuffers.get(accessorModel);
                if (commonByteStride != null) {
                    int elementSizeInBytes = accessorModel.getElementSizeInBytes();
                    if (elementSizeInBytes != commonByteStride) {
                        accessorByteBuffer = BufferStructureBuilder.applyByteStride(rawAccessorByteBuffer, elementSizeInBytes, commonByteStride);
                    }
                } else {
                    int elementSize = accessorModel.getElementSizeInBytes();
                    accessorModel.setByteStride(elementSize);
                }
                accumulatedBufferViewBytes += accessorByteBuffer.capacity();
                accumulatedBufferBytes += paddingBytesForBufferView;
                bufferElements.add(ByteBuffer.allocate(paddingBytesForBufferView));
                accumulatedBufferBytes += accessorByteBuffer.capacity();
                bufferElements.add(accessorByteBuffer);
            }
            bufferViewModel.setByteLength(accumulatedBufferViewBytes);
        }
        this.validatePadding((BufferModel)bufferModel);
        ByteBuffer bufferData = Buffers.concat(bufferElements);
        bufferModel.setBufferData(bufferData);
    }

    private static ByteBuffer applyByteStride(ByteBuffer oldByteBuffer, int oldByteStride, int newByteStride) {
        int count = oldByteBuffer.capacity() / oldByteStride;
        ByteBuffer newByteBuffer = ByteBuffer.allocate(count * newByteStride);
        for (int i = 0; i < count; ++i) {
            int srcPos = i * oldByteStride;
            int dstPos = i * newByteStride;
            Buffers.bufferCopy((ByteBuffer)oldByteBuffer, (int)srcPos, (ByteBuffer)newByteBuffer, (int)dstPos, (int)oldByteStride);
        }
        return newByteBuffer;
    }

    private void validatePadding(BufferModel bufferModel) {
        List<DefaultBufferViewModel> bufferViewModels = this.bufferStructure.getBufferViewModels();
        for (BufferViewModel bufferViewModel : bufferViewModels) {
            List<DefaultAccessorModel> accessorModels = this.bufferStructure.getAccessorModels(bufferViewModel);
            for (AccessorModel accessorModel : accessorModels) {
                this.validatePadding(bufferViewModel, accessorModel);
            }
        }
    }

    private void validatePadding(BufferViewModel bufferViewModel, AccessorModel accessorModel) {
        int alignmentBytes = AccessorModels.computeAlignmentBytes(accessorModel);
        int bufferViewByteOffset = bufferViewModel.getByteOffset();
        int accessorByteOffset = accessorModel.getByteOffset();
        int totalByteOffset = bufferViewByteOffset + accessorByteOffset;
        if (accessorByteOffset % alignmentBytes != 0) {
            logger.severe("Error: accessor.byteOffset is " + accessorByteOffset + " for alignment " + alignmentBytes + " in accessor " + accessorModel);
        }
        if (totalByteOffset % alignmentBytes != 0) {
            logger.severe("Error: bufferView.byteOffset+accessor.byteOffset is " + totalByteOffset + " for alignment " + alignmentBytes + " in accessor " + accessorModel);
        }
    }
}

