/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.creation;

import de.javagl.jgltf.model.AccessorDatas;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.Accessors;
import de.javagl.jgltf.model.ElementType;
import de.javagl.jgltf.model.creation.Utils;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.io.Buffers;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class AccessorModels {
    public static DefaultAccessorModel createUnsignedIntScalar(IntBuffer data) {
        return AccessorModels.create(5125, "SCALAR", false, Buffers.createByteBufferFrom((IntBuffer)data));
    }

    public static DefaultAccessorModel createIntScalar(IntBuffer data) {
        return AccessorModels.create(5124, "SCALAR", false, Buffers.createByteBufferFrom((IntBuffer)data));
    }

    public static DefaultAccessorModel createUnsignedByteScalar(IntBuffer data) {
        return AccessorModels.create(5121, "SCALAR", false, Buffers.castToByteBuffer((IntBuffer)data));
    }

    public static DefaultAccessorModel createUnsignedByteScalar(ByteBuffer data) {
        return AccessorModels.create(5121, "SCALAR", false, data);
    }

    public static DefaultAccessorModel createByteScalar(IntBuffer data) {
        return AccessorModels.create(5120, "SCALAR", false, Buffers.castToByteBuffer((IntBuffer)data));
    }

    public static DefaultAccessorModel createByteScalar(ByteBuffer data) {
        return AccessorModels.create(5120, "SCALAR", false, data);
    }

    public static DefaultAccessorModel createUnsignedShortScalar(IntBuffer data) {
        return AccessorModels.create(5123, "SCALAR", false, Buffers.castToShortByteBuffer((IntBuffer)data));
    }

    public static DefaultAccessorModel createUnsignedShortScalar(ShortBuffer data) {
        return AccessorModels.create(5123, "SCALAR", false, Buffers.createByteBufferFrom((ShortBuffer)data));
    }

    public static DefaultAccessorModel createShortScalar(IntBuffer data) {
        return AccessorModels.create(5122, "SCALAR", false, Buffers.castToShortByteBuffer((IntBuffer)data));
    }

    public static DefaultAccessorModel createShortScalar(ShortBuffer data) {
        return AccessorModels.create(5122, "SCALAR", false, Buffers.createByteBufferFrom((ShortBuffer)data));
    }

    public static DefaultAccessorModel createFloat2D(FloatBuffer data) {
        return AccessorModels.create(5126, "VEC2", false, Buffers.createByteBufferFrom((FloatBuffer)data));
    }

    public static DefaultAccessorModel createFloat3D(FloatBuffer data) {
        return AccessorModels.create(5126, "VEC3", false, Buffers.createByteBufferFrom((FloatBuffer)data));
    }

    public static DefaultAccessorModel createFloat4D(FloatBuffer data) {
        return AccessorModels.create(5126, "VEC4", false, Buffers.createByteBufferFrom((FloatBuffer)data));
    }

    public static DefaultAccessorModel create(int componentType, String type, boolean normalized, ByteBuffer byteBuffer) {
        ElementType elementType = ElementType.valueOf((String)type);
        int numBytesPerElement = elementType.getByteStride(componentType);
        if (byteBuffer.capacity() % numBytesPerElement != 0) {
            throw new IllegalArgumentException("Invalid data for type " + type + " accessor with " + Accessors.getDataTypeForAccessorComponentType((int)componentType) + "components: The data length is " + byteBuffer.capacity() + " which is not divisble by " + numBytesPerElement);
        }
        int count = byteBuffer.capacity() / numBytesPerElement;
        DefaultAccessorModel accessorModel = new DefaultAccessorModel(componentType, count, elementType);
        accessorModel.setNormalized(normalized);
        accessorModel.setAccessorData(AccessorDatas.create((AccessorModel)accessorModel, (ByteBuffer)byteBuffer));
        return accessorModel;
    }

    static int computeAlignmentBytes(AccessorModel accessorModel) {
        return accessorModel.getComponentSizeInBytes();
    }

    static int computeAlignmentBytes(Iterable<? extends AccessorModel> accessorModels) {
        int alignmentBytes = 1;
        for (AccessorModel accessorModel : accessorModels) {
            alignmentBytes = Utils.computeLeastCommonMultiple(alignmentBytes, AccessorModels.computeAlignmentBytes(accessorModel));
        }
        return alignmentBytes;
    }

    private static int computeCommonByteStride(Iterable<? extends AccessorModel> accessorModels) {
        int commonByteStride = 1;
        for (AccessorModel accessorModel : accessorModels) {
            int elementSize = accessorModel.getElementSizeInBytes();
            commonByteStride = Math.max(commonByteStride, elementSize);
            int byteStride = accessorModel.getByteStride();
            commonByteStride = Math.max(commonByteStride, byteStride);
        }
        return commonByteStride;
    }

    static int computeCommonVertexAttributeByteStride(Iterable<? extends AccessorModel> accessorModels) {
        int commonByteStride = AccessorModels.computeCommonByteStride(accessorModels);
        return Utils.pad(commonByteStride, 4);
    }

    private AccessorModels() {
    }
}

