/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.creation;

import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.GltfConstants;
import de.javagl.jgltf.model.creation.AccessorModels;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.impl.DefaultMeshPrimitiveModel;
import de.javagl.jgltf.model.io.Buffers;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MeshPrimitiveBuilder {
    private int mode = 4;
    private DefaultAccessorModel indicesAccessorModel;
    private final Map<String, DefaultAccessorModel> attributeAccessorModels = new LinkedHashMap<String, DefaultAccessorModel>();

    public static MeshPrimitiveBuilder create() {
        return new MeshPrimitiveBuilder();
    }

    private MeshPrimitiveBuilder() {
    }

    public MeshPrimitiveBuilder setTriangles() {
        this.mode = 4;
        return this;
    }

    public MeshPrimitiveBuilder setLines() {
        this.mode = 1;
        return this;
    }

    public MeshPrimitiveBuilder setPoints() {
        this.mode = 0;
        return this;
    }

    public MeshPrimitiveBuilder setIntIndices(IntBuffer indices) {
        return this.setIndicesInternal(5125, "SCALAR", Buffers.createByteBufferFrom((IntBuffer)indices));
    }

    public MeshPrimitiveBuilder setIntIndicesAsShort(IntBuffer indices) {
        return this.setIndicesInternal(5123, "SCALAR", Buffers.castToShortByteBuffer((IntBuffer)indices));
    }

    public MeshPrimitiveBuilder setIntIndicesAsByte(IntBuffer indices) {
        return this.setIndicesInternal(5121, "SCALAR", Buffers.castToByteBuffer((IntBuffer)indices));
    }

    public MeshPrimitiveBuilder setShortIndices(ShortBuffer indices) {
        return this.setIndicesInternal(5123, "SCALAR", Buffers.createByteBufferFrom((ShortBuffer)indices));
    }

    public MeshPrimitiveBuilder setByteIndices(ByteBuffer indices) {
        return this.setIndicesInternal(5121, "SCALAR", Buffers.copyOf((ByteBuffer)indices, (int)indices.capacity()));
    }

    public MeshPrimitiveBuilder setIndicesAs(IntBuffer indices, int componentType) {
        switch (componentType) {
            case 5121: {
                return this.setIntIndicesAsByte(indices);
            }
            case 5123: {
                return this.setIntIndicesAsShort(indices);
            }
            case 5125: {
                return this.setIntIndices(indices);
            }
        }
        throw new IllegalArgumentException("The component type must be GL_UNSIGNED_BYTE,GL_UNSIGNED_SHORT or GL_UNSIGNED_INT, but is " + GltfConstants.stringFor((int)componentType));
    }

    private MeshPrimitiveBuilder setIndicesInternal(int componentType, String type, ByteBuffer byteBuffer) {
        DefaultAccessorModel indices = AccessorModels.create(componentType, type, false, byteBuffer);
        return this.setIndices(indices);
    }

    public MeshPrimitiveBuilder setIndices(DefaultAccessorModel indices) {
        this.indicesAccessorModel = indices;
        return this;
    }

    public MeshPrimitiveBuilder addPositions3D(FloatBuffer data) {
        return this.addAttributeInternal("POSITION", 3, data);
    }

    public MeshPrimitiveBuilder addPositions4D(FloatBuffer data) {
        return this.addAttributeInternal("POSITION", 4, data);
    }

    public MeshPrimitiveBuilder addNormals3D(FloatBuffer data) {
        return this.addAttributeInternal("NORMAL", 3, data);
    }

    public MeshPrimitiveBuilder addNormals4D(FloatBuffer data) {
        return this.addAttributeInternal("NORMAL", 4, data);
    }

    public MeshPrimitiveBuilder addTexCoords02D(FloatBuffer data) {
        return this.addAttributeInternal("TEXCOORD_0", 2, data);
    }

    public MeshPrimitiveBuilder addTangents3D(FloatBuffer data) {
        return this.addAttributeInternal("TANGENT", 3, data);
    }

    public MeshPrimitiveBuilder addTangents4D(FloatBuffer data) {
        return this.addAttributeInternal("TANGENT", 4, data);
    }

    private MeshPrimitiveBuilder addAttributeInternal(String attributeName, int dimensions, FloatBuffer data) {
        DefaultAccessorModel accessorModel = AccessorModels.create(5126, "VEC" + dimensions, false, Buffers.createByteBufferFrom((FloatBuffer)data));
        return this.addAttribute(attributeName, accessorModel);
    }

    public MeshPrimitiveBuilder addAttribute(String attributeName, DefaultAccessorModel attribute) {
        this.attributeAccessorModels.put(attributeName, attribute);
        return this;
    }

    public DefaultMeshPrimitiveModel build() {
        DefaultMeshPrimitiveModel result = new DefaultMeshPrimitiveModel(this.mode);
        if (this.indicesAccessorModel != null) {
            result.setIndices((AccessorModel)this.indicesAccessorModel);
            this.indicesAccessorModel = null;
        }
        if (!this.attributeAccessorModels.isEmpty()) {
            for (Map.Entry<String, DefaultAccessorModel> entry : this.attributeAccessorModels.entrySet()) {
                String name = entry.getKey();
                DefaultAccessorModel accessorModel = entry.getValue();
                result.putAttribute(name, (AccessorModel)accessorModel);
            }
            this.attributeAccessorModels.clear();
        }
        return result;
    }
}

