/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.creation;

import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.AnimationModel;
import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.MeshModel;
import de.javagl.jgltf.model.MeshPrimitiveModel;
import de.javagl.jgltf.model.SkinModel;
import de.javagl.jgltf.model.creation.BufferBuilderStrategy;
import de.javagl.jgltf.model.creation.BufferStructure;
import de.javagl.jgltf.model.creation.BufferStructureBuilder;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.impl.DefaultAnimationModel;
import de.javagl.jgltf.model.impl.DefaultBufferModel;
import de.javagl.jgltf.model.impl.DefaultBufferViewModel;
import de.javagl.jgltf.model.impl.DefaultImageModel;
import de.javagl.jgltf.model.impl.DefaultMeshModel;
import de.javagl.jgltf.model.impl.DefaultSkinModel;
import java.util.Collection;
import java.util.List;

class DefaultBufferBuilderStrategy
implements BufferBuilderStrategy {
    private final BufferStructureBuilder bufferStructureBuilder = new BufferStructureBuilder();
    private BufferStructure bufferStructure;
    private final boolean useSingleVertexAttributesBufferView = false;

    DefaultBufferBuilderStrategy() {
    }

    @Override
    public void processMeshModels(Collection<? extends DefaultMeshModel> meshModels) {
        for (DefaultMeshModel defaultMeshModel : meshModels) {
            this.processMeshModel((MeshModel)defaultMeshModel);
        }
    }

    private void processMeshModel(MeshModel meshModel) {
        List meshPrimitives = meshModel.getMeshPrimitiveModels();
        for (MeshPrimitiveModel meshPrimitiveModel : meshPrimitives) {
            this.processMeshPrimitiveModel(meshPrimitiveModel);
        }
    }

    private void processMeshPrimitiveModel(MeshPrimitiveModel meshPrimitiveModel) {
        AccessorModel indices = meshPrimitiveModel.getIndices();
        if (indices != null) {
            this.bufferStructureBuilder.addAccessorModel("indices", (DefaultAccessorModel)indices);
            this.bufferStructureBuilder.createArrayElementBufferViewModel("indices");
        }
        Collection attributes = meshPrimitiveModel.getAttributes().values();
        for (AccessorModel attribute : attributes) {
            this.bufferStructureBuilder.addAccessorModel("attribute", (DefaultAccessorModel)attribute);
            this.bufferStructureBuilder.createArrayBufferViewModel("attribute");
        }
    }

    @Override
    public void processImageModels(Collection<? extends DefaultImageModel> imageModels) {
        for (DefaultImageModel defaultImageModel : imageModels) {
            this.processImageModel((ImageModel)defaultImageModel);
        }
    }

    private void processImageModel(ImageModel imageModel) {
    }

    @Override
    public void processAnimationModels(Collection<? extends DefaultAnimationModel> animationModels) {
        for (DefaultAnimationModel defaultAnimationModel : animationModels) {
            this.processAnimationModel((AnimationModel)defaultAnimationModel);
        }
    }

    private void processAnimationModel(AnimationModel animationModel) {
        for (AnimationModel.Channel channel : animationModel.getChannels()) {
            AnimationModel.Sampler sampler = channel.getSampler();
            AccessorModel input = sampler.getInput();
            AccessorModel output = sampler.getOutput();
            this.bufferStructureBuilder.addAccessorModel("animation input", (DefaultAccessorModel)input);
            this.bufferStructureBuilder.addAccessorModel("animation output", (DefaultAccessorModel)output);
        }
        if (!animationModel.getChannels().isEmpty()) {
            this.bufferStructureBuilder.createArrayBufferViewModel("animation");
        }
    }

    @Override
    public void processSkinModels(Collection<? extends DefaultSkinModel> skinModels) {
        for (DefaultSkinModel defaultSkinModel : skinModels) {
            this.processSkinModel((SkinModel)defaultSkinModel);
        }
    }

    private void processSkinModel(SkinModel skinModel) {
        AccessorModel ibm = skinModel.getInverseBindMatrices();
        this.bufferStructureBuilder.addAccessorModel("inverse bind matrices", (DefaultAccessorModel)ibm);
        this.bufferStructureBuilder.createArrayBufferViewModel("skin");
    }

    @Override
    public void processAccessorModels(Collection<? extends DefaultAccessorModel> accessorModels) {
        for (DefaultAccessorModel defaultAccessorModel : accessorModels) {
            this.bufferStructureBuilder.addAccessorModel("additional", defaultAccessorModel);
            this.bufferStructureBuilder.createArrayBufferViewModel("additional");
        }
    }

    @Override
    public void commitBuffer(String uri) {
        this.bufferStructureBuilder.createBufferModel("buffer", uri);
    }

    @Override
    public void finish() {
        this.bufferStructure = this.bufferStructureBuilder.build();
    }

    @Override
    public List<DefaultAccessorModel> getAccessorModels() {
        return this.bufferStructure.getAccessorModels();
    }

    @Override
    public List<DefaultBufferViewModel> getBufferViewModels() {
        return this.bufferStructure.getBufferViewModels();
    }

    @Override
    public List<DefaultBufferModel> getBufferModels() {
        return this.bufferStructure.getBufferModels();
    }
}

