/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.creation;

import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.impl.DefaultBufferModel;
import de.javagl.jgltf.model.impl.DefaultBufferViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BufferStructure {
    private final Map<DefaultAccessorModel, String> accessorIds = new LinkedHashMap<DefaultAccessorModel, String>();
    private final Map<DefaultAccessorModel, Integer> accessorIndices = new LinkedHashMap<DefaultAccessorModel, Integer>();
    private final List<DefaultBufferViewModel> bufferViewModels = new ArrayList<DefaultBufferViewModel>();
    private final Map<DefaultBufferViewModel, String> bufferViewIds = new LinkedHashMap<DefaultBufferViewModel, String>();
    private final Map<DefaultBufferViewModel, Integer> bufferViewIndices = new LinkedHashMap<DefaultBufferViewModel, Integer>();
    private final Map<DefaultBufferViewModel, List<DefaultAccessorModel>> bufferViewAccessorModels = new LinkedHashMap<DefaultBufferViewModel, List<DefaultAccessorModel>>();
    private final List<DefaultBufferModel> bufferModels = new ArrayList<DefaultBufferModel>();
    private final Map<DefaultBufferModel, String> bufferIds = new LinkedHashMap<DefaultBufferModel, String>();
    private final Map<DefaultBufferModel, Integer> bufferIndices = new LinkedHashMap<DefaultBufferModel, Integer>();
    private final Map<DefaultBufferModel, List<DefaultBufferViewModel>> bufferBufferViewModels = new LinkedHashMap<DefaultBufferModel, List<DefaultBufferViewModel>>();
    private final Map<DefaultBufferModel, Set<Integer>> paddingByteIndices = new LinkedHashMap<DefaultBufferModel, Set<Integer>>();

    public void addAccessorModel(DefaultAccessorModel accessorModel, String idPrefix) {
        String id = BufferStructure.createId(idPrefix, this.accessorIds.values());
        this.accessorIndices.put(accessorModel, this.accessorIndices.size());
        this.accessorIds.put(accessorModel, id);
    }

    public void addBufferViewModel(DefaultBufferViewModel bufferViewModel, String idPrefix, Collection<? extends DefaultAccessorModel> accessorModels) {
        this.bufferViewModels.add(bufferViewModel);
        String id = BufferStructure.createId(idPrefix, this.bufferViewIds.values());
        this.bufferViewIds.put(bufferViewModel, id);
        this.bufferViewIndices.put(bufferViewModel, this.bufferViewIndices.size());
        this.bufferViewAccessorModels.put(bufferViewModel, new ArrayList<DefaultAccessorModel>(accessorModels));
    }

    public void addBufferModel(DefaultBufferModel bufferModel, String idPrefix, Collection<? extends DefaultBufferViewModel> bufferViewModels) {
        this.bufferModels.add(bufferModel);
        String id = BufferStructure.createId(idPrefix, this.bufferIds.values());
        this.bufferIds.put(bufferModel, id);
        this.bufferIndices.put(bufferModel, this.bufferIndices.size());
        this.bufferBufferViewModels.put(bufferModel, new ArrayList<DefaultBufferViewModel>(bufferViewModels));
    }

    private void addPaddingByteIndex(DefaultBufferModel bufferModel, int index) {
        this.paddingByteIndices.computeIfAbsent(bufferModel, bm -> new LinkedHashSet()).add(index);
    }

    void addPaddingByteIndices(DefaultBufferModel bufferModel, int startIndex, int count) {
        for (int index = startIndex; index < startIndex + count; ++index) {
            this.addPaddingByteIndex(bufferModel, index);
        }
    }

    public List<DefaultBufferModel> getBufferModels() {
        return Collections.unmodifiableList(this.bufferModels);
    }

    public String getBufferId(BufferModel bufferModel) {
        return this.bufferIds.get(bufferModel);
    }

    public Integer getBufferIndex(BufferModel bufferModel) {
        return this.bufferIndices.get(bufferModel);
    }

    public List<DefaultBufferViewModel> getBufferViewModels(BufferModel bufferModel) {
        List<DefaultBufferViewModel> bufferViewModels = this.bufferBufferViewModels.get(bufferModel);
        if (bufferViewModels == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(bufferViewModels);
    }

    public List<DefaultBufferViewModel> getBufferViewModels() {
        return Collections.unmodifiableList(this.bufferViewModels);
    }

    public String getBufferViewId(BufferViewModel bufferViewModel) {
        return this.bufferViewIds.get(bufferViewModel);
    }

    public Integer getBufferViewIndex(BufferViewModel bufferViewModel) {
        return this.bufferViewIndices.get(bufferViewModel);
    }

    public List<DefaultAccessorModel> getAccessorModels(BufferViewModel bufferViewModel) {
        List<DefaultAccessorModel> accessorModels = this.bufferViewAccessorModels.get(bufferViewModel);
        if (accessorModels == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(accessorModels);
    }

    public List<DefaultAccessorModel> getAccessorModels() {
        ArrayList<DefaultAccessorModel> allAccessorModels = new ArrayList<DefaultAccessorModel>(this.accessorIds.keySet());
        return Collections.unmodifiableList(allAccessorModels);
    }

    public String getAccessorId(AccessorModel accessorModel) {
        return this.accessorIds.get(accessorModel);
    }

    public Integer getAccessorIndex(AccessorModel accessorModel) {
        return this.accessorIndices.get(accessorModel);
    }

    public boolean isPaddingByteIndex(BufferModel bufferModel, int index) {
        Set<Integer> indices = this.paddingByteIndices.get(bufferModel);
        if (indices == null) {
            return false;
        }
        return indices.contains(index);
    }

    private static String createId(String prefix, Collection<? extends String> existingIds) {
        int counter = 0;
        String id = prefix;
        while (existingIds.contains(id)) {
            id = prefix + "_" + counter;
            ++counter;
        }
        return id;
    }
}

