/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.iteration;

import de.javagl.common.iteration.FilteringIterator;
import de.javagl.common.iteration.Iterators;
import de.javagl.common.iteration.TransformingIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class Iterables {
    public static <T> List<T> toList(Iterable<T> iterable) {
        Objects.requireNonNull(iterable, "The iterable is null");
        return Iterables.toCollection(iterable, new ArrayList());
    }

    public static <T> Set<T> toSet(Iterable<T> iterable) {
        Objects.requireNonNull(iterable, "The iterable is null");
        return Iterables.toCollection(iterable, new LinkedHashSet());
    }

    public static <T, C extends Collection<? super T>> C toCollection(Iterable<T> iterable, C collection) {
        Objects.requireNonNull(iterable, "The iterable is null");
        Objects.requireNonNull(collection, "The collection is null");
        return Iterators.toCollection(iterable.iterator(), collection);
    }

    public static <T> Iterable<T> iterableOverIterables(final Iterable<? extends Iterable<? extends T>> iterablesIterable) {
        Objects.requireNonNull(iterablesIterable, "The iterablesIterable is null");
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.iteratorOverIterables(iterablesIterable.iterator());
            }
        };
    }

    public static <S, T> Iterable<T> transformingIterable(final Iterable<? extends S> iterable, final Function<S, ? extends T> function) {
        Objects.requireNonNull(iterable, "The iterable is null");
        Objects.requireNonNull(function, "The function is null");
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new TransformingIterator(iterable.iterator(), function);
            }
        };
    }

    public static <T> Iterable<T> filteringIterable(final Iterable<? extends T> iterable, final Predicate<? super T> predicate) {
        Objects.requireNonNull(iterable, "The iterable is null");
        Objects.requireNonNull(predicate, "The predicate is null");
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new FilteringIterator(iterable.iterator(), predicate);
            }
        };
    }

    public static <T> boolean isSorted(Iterable<? extends T> iterable, Comparator<? super T> comparator) {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return true;
        }
        T t0 = iterator.next();
        while (iterator.hasNext()) {
            T t1 = iterator.next();
            if (comparator.compare(t0, t1) > 0) {
                return false;
            }
            t0 = t1;
        }
        return true;
    }

    private Iterables() {
    }
}

