/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.functional;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Functions {
    static <T> Function<Integer, T> fromList(final List<T> list, final T defaultValue) {
        return new Function<Integer, T>(){

            @Override
            public T apply(Integer i) {
                if (i >= 0 && i < list.size()) {
                    return list.get(i);
                }
                return defaultValue;
            }
        };
    }

    public static <S, T> Function<T, S> invert(Function<? super S, ? extends T> function, Iterable<? extends S> arguments) {
        LinkedHashMap map = new LinkedHashMap();
        for (S s : arguments) {
            T t = function.apply(s);
            map.put(t, s);
        }
        return k -> map.get(k);
    }

    public static <K, V> Function<K, V> fromMap(final Map<? super K, ? extends V> map, final V defaultValue) {
        return new Function<K, V>(){

            @Override
            public V apply(K k) {
                Object result = map.get(k);
                if (result == null && !map.containsKey(k)) {
                    return defaultValue;
                }
                return result;
            }
        };
    }

    private Functions() {
    }
}

