/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.functional;

import de.javagl.common.Tuple2;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public final class CachingBiFunction<T, U, R>
implements BiFunction<T, U, R> {
    private final BiFunction<T, U, R> delegate;
    private final Map<Tuple2<T, U>, R> map;

    public CachingBiFunction(BiFunction<T, U, R> delegate) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
        this.map = new HashMap<Tuple2<T, U>, R>();
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public R apply(T t, U u) {
        Tuple2 key = Tuple2.of(t, u);
        R value = this.map.get(key);
        if (value == null) {
            value = this.delegate.apply(t, u);
            this.map.put(key, value);
        }
        return value;
    }
}

