/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.collections;

import de.javagl.common.util.Comparators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Maps {
    public static <T> Map<T, Integer> createIndexLookupUnchecked(List<? extends T> list) {
        LinkedHashMap<T, Integer> map = new LinkedHashMap<T, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            T element = list.get(i);
            map.put(element, i);
        }
        return map;
    }

    public static <T> Map<T, Integer> createIndexLookup(List<? extends T> list) {
        LinkedHashMap<T, Integer> map = new LinkedHashMap<T, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            T t = list.get(i);
            Integer previous = map.put(t, i);
            if (previous == null) continue;
            throw new IllegalArgumentException("Duplicate element " + t + " at " + i + " and " + previous);
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> combine(Collection<? extends Map<? extends K, ? extends V>> maps) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map<K, V> map : maps) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K k = entry.getKey();
                V v = entry.getValue();
                Maps.addToList(result, k, v);
            }
        }
        return result;
    }

    public static <K, V extends Number> Map<K, V> sortByNumberValue(Map<K, V> map, boolean ascending) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Comparator valueComparator = Comparators.forNumbers();
        if (!ascending) {
            valueComparator = valueComparator.reversed();
        }
        Comparator comparator = Map.Entry.comparingByValue(valueComparator);
        Collections.sort(entries, comparator);
        return Maps.fromEntries(entries);
    }

    public static <K, V> Map<K, V> fromEntries(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            K k = entry.getKey();
            V v = entry.getValue();
            result.put(k, v);
        }
        return result;
    }

    public static <KI, VI, KO, VO> Map<KO, VO> transform(Map<KI, VI> map, Function<? super KI, ? extends KO> keyTransform, Function<? super VI, ? extends VO> valueTransform) {
        LinkedHashMap<KO, VO> result = new LinkedHashMap<KO, VO>();
        for (Map.Entry<KI, VI> entry : map.entrySet()) {
            KI ki = entry.getKey();
            VI vi = entry.getValue();
            KO ko = keyTransform.apply(ki);
            VO vo = valueTransform.apply(vi);
            result.put(ko, vo);
        }
        return result;
    }

    public static <K> void incrementCount(Map<K, Integer> map, K k) {
        map.put(k, Maps.getCount(map, k) + 1);
    }

    public static <K> Integer getCount(Map<K, Integer> map, K k) {
        Integer count = map.get(k);
        if (count == null) {
            count = 0;
            map.put(k, count);
        }
        return count;
    }

    static <K, E> List<E> getList(Map<K, List<E>> map, K k) {
        List<E> list = map.get(k);
        if (list == null) {
            list = new ArrayList();
            map.put(k, list);
        }
        return list;
    }

    public static <K, E> void addToList(Map<K, List<E>> map, K k, E e) {
        Maps.getList(map, k).add(e);
    }

    static <K, E> void removeFromList(Map<K, List<E>> map, K k, E e) {
        List<E> list = map.get(k);
        if (list != null) {
            list.remove(e);
            if (list.isEmpty()) {
                map.remove(k);
            }
        }
    }

    public static <K, V> void fillValues(Map<K, V> map, Iterable<? extends V> values) {
        Iterator<V> iterator = values.iterator();
        for (K k : map.keySet()) {
            if (!iterator.hasNext()) break;
            V value = iterator.next();
            map.put(k, value);
        }
    }

    static <K, V> Map<V, K> invert(Map<K, V> map) {
        LinkedHashMap<V, K> result = new LinkedHashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    @SafeVarargs
    public static <T> Map<Integer, T> fromElements(T ... elements) {
        return Maps.fromIterable(Arrays.asList(elements));
    }

    public static <T> Map<Integer, T> fromIterable(Iterable<? extends T> iterable) {
        LinkedHashMap<Integer, T> map = new LinkedHashMap<Integer, T>();
        int i = 0;
        for (T t : iterable) {
            map.put(i, t);
            ++i;
        }
        return map;
    }

    public static <K, V> Map<K, V> fromIterables(Iterable<? extends K> iterable0, Iterable<? extends V> iterable1) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        Iterator<K> i0 = iterable0.iterator();
        Iterator<V> i1 = iterable1.iterator();
        while (i0.hasNext() && i1.hasNext()) {
            K k = i0.next();
            V v = i1.next();
            map.put(k, v);
        }
        return map;
    }

    public static <K, V> Map<K, V> unmodifiableCopy(Map<? extends K, ? extends V> map) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    private Maps() {
    }
}

