/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.collections;

import de.javagl.common.collections.IndexViewList;
import de.javagl.common.functional.TriFunction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;

public class Lists {
    public static <T> List<T> unmodifiableListWith(Collection<? extends T> input) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(input));
    }

    public static List<Integer> fromArray(int ... array) {
        Objects.requireNonNull(array, "The array may not be null");
        class ResultList
        extends AbstractList<Integer>
        implements RandomAccess {
            final /* synthetic */ int[] val$array;

            ResultList(int[] nArray) {
                this.val$array = nArray;
            }

            @Override
            public Integer get(int index) {
                return this.val$array[index];
            }

            @Override
            public int size() {
                return this.val$array.length;
            }
        }
        return new ResultList(array);
    }

    public static <T, U> List<U> createView(final List<? extends T> list, final Function<? super T, ? extends U> function) {
        Objects.requireNonNull(list, "The list may not be null");
        Objects.requireNonNull(function, "The function may not be null");
        AbstractList view = new AbstractList<U>(){

            @Override
            public U get(int index) {
                Object t = list.get(index);
                Object u = function.apply(t);
                return u;
            }

            @Override
            public int size() {
                return list.size();
            }
        };
        if (list instanceof RandomAccess) {
            return Lists.withRandomAccess(view);
        }
        return view;
    }

    public static <A, B, C> List<C> createView(final List<? extends A> list0, final List<? extends B> list1, final BiFunction<? super A, ? super B, ? extends C> function) {
        Objects.requireNonNull(list0, "The list0 may not be null");
        Objects.requireNonNull(list1, "The list1 may not be null");
        Objects.requireNonNull(function, "The function may not be null");
        if (list0.size() != list1.size()) {
            throw new IllegalArgumentException("The sizes must be equal, but are " + list0.size() + " and " + list1.size());
        }
        AbstractList view = new AbstractList<C>(){

            @Override
            public C get(int index) {
                Object t = list0.get(index);
                Object u = list1.get(index);
                Object v = function.apply(t, u);
                return v;
            }

            @Override
            public int size() {
                return list0.size();
            }
        };
        if (list0 instanceof RandomAccess && list1 instanceof RandomAccess) {
            return Lists.withRandomAccess(view);
        }
        return view;
    }

    public static <A, B, C, D> List<D> createView(final List<A> list0, final List<B> list1, final List<C> list2, final TriFunction<? super A, ? super B, ? super C, ? extends D> function) {
        Objects.requireNonNull(list0, "The list0 may not be null");
        Objects.requireNonNull(list1, "The list1 may not be null");
        Objects.requireNonNull(list2, "The list2 may not be null");
        Objects.requireNonNull(function, "The function may not be null");
        if (list0.size() != list1.size() || list1.size() != list2.size()) {
            throw new IllegalArgumentException("The sizes must be equal, but are " + list0.size() + ", " + list1.size() + ", and " + list2.size());
        }
        AbstractList view = new AbstractList<D>(){

            @Override
            public D get(int index) {
                Object a = list0.get(index);
                Object b = list1.get(index);
                Object c = list2.get(index);
                Object d = function.apply(a, b, c);
                return d;
            }

            @Override
            public int size() {
                return list0.size();
            }
        };
        if (list0 instanceof RandomAccess && list1 instanceof RandomAccess && list2 instanceof RandomAccess) {
            return Lists.withRandomAccess(view);
        }
        return view;
    }

    public static <T> List<T> createView(int size, IntFunction<? extends T> function) {
        Lists.validateSize(size);
        return Lists.createView(0, size, function);
    }

    public static <T> List<T> createView(final int minIndexInclusive, final int maxIndexExclusive, final IntFunction<? extends T> f) {
        Objects.requireNonNull(f, "The function may not be null");
        if (minIndexInclusive > maxIndexExclusive) {
            throw new IllegalArgumentException("The minimum index is " + minIndexInclusive + " but may not be larger than the maximum index, which is " + maxIndexExclusive);
        }
        return new AbstractRandomAccessList<T>(){

            @Override
            public T get(int index) {
                Lists.validateIndex(index, this.size());
                return f.apply(index);
            }

            @Override
            public int size() {
                return maxIndexExclusive - minIndexInclusive;
            }
        };
    }

    public static <T> List<T> withRandomAccess(final List<T> list) {
        Objects.requireNonNull(list, "The list may not be null");
        return new AbstractRandomAccessList<T>(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public T get(int index) {
                return list.get(index);
            }

            @Override
            public T set(int index, T element) {
                return list.set(index, element);
            }

            @Override
            public void add(int index, T element) {
                list.add(index, element);
            }

            @Override
            public T remove(int index) {
                return list.remove(index);
            }
        };
    }

    public static List<Integer> steps(final int offset, final int stepSize, final int size) {
        Lists.validateSize(size);
        return new AbstractRandomAccessList<Integer>(){

            @Override
            public Integer get(int index) {
                Lists.validateIndex(index, this.size());
                return offset + stepSize * index;
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static List<Long> steps(final long offset, final long stepSize, final int size) {
        Lists.validateSize(size);
        return new AbstractRandomAccessList<Long>(){

            @Override
            public Long get(int index) {
                Lists.validateIndex(index, this.size());
                return offset + stepSize * (long)index;
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static List<Double> steps(final double offset, final double stepSize, final int size) {
        Lists.validateSize(size);
        return new AbstractRandomAccessList<Double>(){

            @Override
            public Double get(int index) {
                Lists.validateIndex(index, this.size());
                return offset + stepSize * (double)index;
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static List<Integer> fromRange(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("The minimum (" + min + ") is greater than the maximum (" + max + ")");
        }
        return Lists.steps(min, 1, max - min);
    }

    public static List<Long> fromRange(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("The minimum (" + min + ") is greater than the maximum (" + max + ")");
        }
        return Lists.steps(min, 1L, (int)(max - min));
    }

    static <T> List<T> pad(List<T> t, int padLeft, int padRight) {
        if (t.isEmpty()) {
            throw new IllegalArgumentException("The list is empty");
        }
        T padLeftValue = t.get(0);
        T padRightValue = t.get(t.size() - 1);
        return Lists.pad(t, padLeft, padLeftValue, padRight, padRightValue);
    }

    public static <T> List<T> pad(final List<? extends T> t, final int padLeft, final T padLeftValue, final int padRight, final T padRightValue) {
        if (padLeft < 0) {
            throw new IllegalArgumentException("The padLeft value may not be negative but is " + padLeft);
        }
        if (padRight < 0) {
            throw new IllegalArgumentException("The padRight value may not be negative but is " + padRight);
        }
        AbstractList view = new AbstractList<T>(){

            @Override
            public int size() {
                return t.size() + padLeft + padRight;
            }

            @Override
            public T get(int index) {
                Lists.validateIndex(index, this.size());
                if (index < padLeft) {
                    return padLeftValue;
                }
                if (index >= t.size() + padLeft) {
                    return padRightValue;
                }
                return t.get(index - padLeft);
            }
        };
        if (t instanceof RandomAccess) {
            return Lists.withRandomAccess(view);
        }
        return view;
    }

    public static <T> List<T> createIndexView(List<T> parent, List<Integer> indices) {
        return Lists.createIndexView(parent, indices::get, indices.size());
    }

    public static <T> List<T> createIndexView(List<T> parent, IntUnaryOperator indexLookup, int size) {
        return new IndexViewList<T>(parent, indexLookup, size);
    }

    static <T> List<T> createIndexView(List<T> parent, int[] indices) {
        Objects.requireNonNull(indices, "The indices may not be null");
        return Lists.createIndexView(parent, i -> indices[i], indices.length);
    }

    public static <T> List<T> concat(List<? extends T> list0, List<? extends T> list1) {
        Objects.requireNonNull(list0, "The list0 may not be null");
        Objects.requireNonNull(list1, "The list1 may not be null");
        if (list0 instanceof RandomAccess && list1 instanceof RandomAccess) {
            return Lists.concatRandomAccess(list0, list1);
        }
        return Lists.concatDefault(list0, list1);
    }

    private static <T> List<T> concatRandomAccess(final List<? extends T> list0, final List<? extends T> list1) {
        class ResultList
        extends AbstractList<T>
        implements RandomAccess {
            ResultList() {
            }

            @Override
            public T get(int index) {
                if (index < list0.size()) {
                    return list0.get(index);
                }
                return list1.get(index - list0.size());
            }

            @Override
            public int size() {
                return list0.size() + list1.size();
            }
        }
        return new ResultList();
    }

    private static <T> List<T> concatDefault(final List<? extends T> list0, final List<? extends T> list1) {
        class ResultList
        extends AbstractList<T> {
            ResultList() {
            }

            @Override
            public T get(int index) {
                if (index < list0.size()) {
                    return list0.get(index);
                }
                return list1.get(index - list0.size());
            }

            @Override
            public int size() {
                return list0.size() + list1.size();
            }
        }
        return new ResultList();
    }

    public static void validateSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("The size may not be negative, but is " + size);
        }
    }

    public static void validateIndex(int index, int size) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("The index may not be negative and must be smaller than " + size + ", but is " + index);
        }
    }

    private Lists() {
    }

    private static abstract class AbstractRandomAccessList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private AbstractRandomAccessList() {
        }
    }
}

