/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.collections;

import de.javagl.common.collections.Lists;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.function.IntUnaryOperator;

class IndexViewList<T>
extends AbstractList<T> {
    private final List<T> parent;
    private final int size;
    private final IntUnaryOperator indexLookup;

    IndexViewList(List<T> parent, IntUnaryOperator indexLookup, int size) {
        this.parent = Objects.requireNonNull(parent, "The parent may not be null");
        this.indexLookup = Objects.requireNonNull(indexLookup, "The indexLookup may not be null");
        if (size < 0) {
            throw new IllegalArgumentException("The size may not be negative, but is " + size);
        }
        this.size = size;
    }

    @Override
    public T get(int index) {
        Lists.validateIndex(index, this.size);
        int parentIndex = this.indexLookup.applyAsInt(index);
        return this.parent.get(parentIndex);
    }

    @Override
    public T set(int index, T element) {
        Lists.validateIndex(index, this.size);
        int parentIndex = this.indexLookup.applyAsInt(index);
        return this.parent.set(parentIndex, element);
    }

    @Override
    public int size() {
        return this.size;
    }
}

