/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.collections;

import de.javagl.common.collections.NumberCollections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.function.DoubleUnaryOperator;

public class DoubleMaps {
    private static final double EPSILON = 1.0E-10;

    public static <K> Map<K, Double> create(Iterable<? extends K> keys, double min, double max, Random random) {
        LinkedHashMap<K, Double> result = new LinkedHashMap<K, Double>();
        for (K k : keys) {
            double d = random.nextDouble();
            double v = min + d * (max - min);
            result.put(k, v);
        }
        return result;
    }

    public static <K> List<Map<K, Double>> create(Collection<? extends K> keys, List<? extends DoubleUnaryOperator> operators) {
        ArrayList<Map<K, Double>> results = new ArrayList<Map<K, Double>>();
        for (DoubleUnaryOperator doubleUnaryOperator : operators) {
            results.add(DoubleMaps.create(keys, doubleUnaryOperator));
        }
        return results;
    }

    public static <K> Map<K, Double> create(Collection<? extends K> keys, DoubleUnaryOperator operator) {
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        if (keys.size() == 1) {
            K k = keys.iterator().next();
            double v = operator.applyAsDouble(0.0);
            return Collections.singletonMap(k, v);
        }
        LinkedHashMap<K, Double> result = new LinkedHashMap<K, Double>();
        double stepSize = 1.0 / (double)(keys.size() - 1);
        int step = 0;
        for (K k : keys) {
            double a = (double)step * stepSize;
            double v = operator.applyAsDouble(a);
            result.put(k, v);
            ++step;
        }
        return result;
    }

    public static <K> Map<K, Double> scaleValuesToRange(Map<K, ? extends Number> map, double targetMin, double targetMax) {
        return DoubleMaps.scaleValuesToRange(map, targetMin, targetMax, 1.0E-10, targetMin);
    }

    public static <K> Map<K, Double> scaleValuesToRange(Map<K, ? extends Number> map, double targetMin, double targetMax, double epsilon, double defaultValue) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        double sourceMin = NumberCollections.min(map.values());
        double sourceMax = NumberCollections.max(map.values());
        double sourceDelta = sourceMax - sourceMin;
        double targetDelta = targetMax - targetMin;
        if (Math.abs(sourceMax - sourceMin) <= epsilon) {
            return DoubleMaps.transformValues(map, x -> defaultValue);
        }
        DoubleUnaryOperator op = x -> targetMin + (x - sourceMin) / sourceDelta * targetDelta;
        return DoubleMaps.transformValues(map, op);
    }

    public static <K> Map<K, Double> transformValues(Map<K, ? extends Number> map, DoubleUnaryOperator op) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<K, Double> result = new LinkedHashMap<K, Double>();
        for (Map.Entry<K, Number> entry : map.entrySet()) {
            K key = entry.getKey();
            Number value = entry.getValue();
            if (value == null) {
                result.put(key, null);
                continue;
            }
            double v = value.doubleValue();
            double r = op.applyAsDouble(v);
            result.put(key, r);
        }
        return result;
    }

    public static double getInterpolated(NavigableMap<Double, ? extends Number> map, double key) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Empty map");
        }
        Map.Entry<Double, ? extends Number> c = map.ceilingEntry(key);
        Map.Entry<Double, ? extends Number> f = map.floorEntry(key);
        if (c == null) {
            return f.getValue().doubleValue();
        }
        if (f == null) {
            return c.getValue().doubleValue();
        }
        if (c.equals(f)) {
            return c.getValue().doubleValue();
        }
        double deltaKeys = c.getKey() - f.getKey();
        double alpha = (key - f.getKey()) / deltaKeys;
        double deltaValues = c.getValue().doubleValue() - f.getValue().doubleValue();
        double result = f.getValue().doubleValue() + alpha * deltaValues;
        return result;
    }

    private DoubleMaps() {
    }
}

