/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.beans;

import de.javagl.common.beans.FullPersistenceDelegate;
import java.beans.DefaultPersistenceDelegate;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.beans.XMLEncoder;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Logger;

class VerboseXmlEncoder
extends XMLEncoder {
    static final Logger logger = Logger.getLogger(VerboseXmlEncoder.class.getName());

    VerboseXmlEncoder(OutputStream out) {
        super(out);
    }

    @Override
    public void writeStatement(Statement oldStm) {
        Object[] arguments = oldStm.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            if (!(arguments[i] instanceof Enum)) continue;
            VerboseXmlEncoder.forceWritingEnumValue(this, arguments[i]);
        }
        super.writeStatement(oldStm);
    }

    @Override
    public PersistenceDelegate getPersistenceDelegate(Class<?> type) {
        PersistenceDelegate p = super.getPersistenceDelegate(type);
        if (p.getClass().equals(DefaultPersistenceDelegate.class)) {
            p = new FullPersistenceDelegate();
            this.setPersistenceDelegate(type, p);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void forceWritingEnumValue(VerboseXmlEncoder encoder, Object object) {
        Field valueToExpressionField = null;
        Field refsField = null;
        try {
            Class<?> encoderClass = encoder.getClass().getSuperclass();
            valueToExpressionField = encoderClass.getDeclaredField("valueToExpression");
            valueToExpressionField.setAccessible(true);
            Object valueToExpressionObject = valueToExpressionField.get(encoder);
            Map valueToExpression = (Map)valueToExpressionObject;
            Object valueData = valueToExpression.get(object);
            if (valueData != null) {
                Class<?> valueDataClass = valueData.getClass();
                refsField = valueDataClass.getDeclaredField("refs");
                refsField.setAccessible(true);
                refsField.setInt(valueData, 0);
            }
        }
        catch (NoSuchFieldException e) {
            logger.warning(e.toString());
        }
        catch (SecurityException e) {
            logger.warning(e.toString());
        }
        catch (IllegalArgumentException e) {
            logger.warning(e.toString());
        }
        catch (IllegalAccessException e) {
            logger.warning(e.toString());
        }
        finally {
            if (valueToExpressionField != null) {
                valueToExpressionField.setAccessible(false);
            }
            if (refsField != null) {
                refsField.setAccessible(false);
            }
        }
    }
}

