/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.beans;

import de.javagl.common.beans.Methods;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BeanUtils {
    private static BeanInfo getBeanInfoOptional(Class<?> beanClass) {
        try {
            return Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    private static List<PropertyDescriptor> getPropertyDescriptorsOptional(Class<?> beanClass) {
        BeanInfo beanInfo = BeanUtils.getBeanInfoOptional(beanClass);
        if (beanInfo == null) {
            return Collections.emptyList();
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        if (propertyDescriptors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<PropertyDescriptor>(Arrays.asList(propertyDescriptors)));
    }

    private static PropertyDescriptor getPropertyDescriptorOptional(Class<?> beanClass, String propertyName) {
        List<PropertyDescriptor> propertyDescriptors = BeanUtils.getPropertyDescriptorsOptional(beanClass);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.getName().equals(propertyName)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public static void setAllOptional(Object targetBean, Object sourceBean) {
        Class<?> sourceClass = targetBean.getClass();
        Class<?> targetClass = targetBean.getClass();
        List<String> propertyNames = BeanUtils.getMutablePropertyNamesOptional(targetClass);
        for (String propertyName : propertyNames) {
            Method readMethod = BeanUtils.getReadMethodOptional(sourceClass, propertyName);
            Method writeMethod = BeanUtils.getWriteMethodOptional(targetClass, propertyName);
            if (readMethod == null || writeMethod == null) continue;
            try {
                Object value = readMethod.invoke(sourceBean, new Object[0]);
                Methods.invokeOptional(writeMethod, targetBean, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {}
        }
    }

    public static String getDescription(String propertyName) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append(" ");
            } else if (i == 0) {
                c = Character.toUpperCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void invokeWriteMethodOptional(Object bean, String propertyName, Object value) {
        Class<?> c = bean.getClass();
        Method method = BeanUtils.getWriteMethodOptional(c, propertyName);
        if (method != null) {
            Methods.invokeOptional(method, bean, value);
        }
    }

    public static Object invokeReadMethodOptional(Object bean, String propertyName) {
        Class<?> c = bean.getClass();
        Method method = BeanUtils.getReadMethodOptional(c, propertyName);
        if (method == null) {
            return null;
        }
        return Methods.invokeOptional(method, bean, new Object[0]);
    }

    public static List<String> getMutablePropertyNamesOptional(Class<?> beanClass) {
        List<PropertyDescriptor> propertyDescriptors = BeanUtils.getPropertyDescriptorsOptional(beanClass);
        ArrayList<String> result = new ArrayList<String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            String propertyName = propertyDescriptor.getName();
            Method readMethod = BeanUtils.getReadMethodOptional(beanClass, propertyName);
            Method writeMethod = BeanUtils.getWriteMethodOptional(beanClass, propertyName);
            if (readMethod == null || writeMethod == null) continue;
            result.add(propertyName);
        }
        return Collections.unmodifiableList(result);
    }

    public static Class<?> getPropertyTypeOptional(Class<?> beanClass, String propertyName) {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptorOptional(beanClass, propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        return propertyDescriptor.getPropertyType();
    }

    public static Method getWriteMethodOptional(Class<?> beanClass, String propertyName) {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptorOptional(beanClass, propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        return propertyDescriptor.getWriteMethod();
    }

    public static Method getReadMethodOptional(Class<?> beanClass, String propertyName) {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptorOptional(beanClass, propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        return propertyDescriptor.getReadMethod();
    }

    private BeanUtils() {
    }
}

