/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.xml;

import de.javagl.common.xml.XmlException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static Document defaultDocument = null;

    public static synchronized Document getDefaultDocument() {
        if (defaultDocument == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = null;
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new XmlException("Could not create default document", e);
            }
            defaultDocument = documentBuilder.newDocument();
        }
        return defaultDocument;
    }

    public static String toString(Node node) {
        StringWriter stringWriter = new StringWriter();
        XmlUtils.write(node, stringWriter, 4, false);
        return stringWriter.toString();
    }

    public static String toString(Node node, int indentation, boolean omitXmlDeclaration) {
        StringWriter stringWriter = new StringWriter();
        XmlUtils.write(node, stringWriter, indentation, omitXmlDeclaration);
        return stringWriter.toString();
    }

    public static void write(Node node, OutputStream outputStream) {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        XmlUtils.write(node, writer, 4, false);
    }

    public static void write(Node node, OutputStream outputStream, int indentation, boolean omitXmlDeclaration) {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        XmlUtils.write(node, writer, indentation, omitXmlDeclaration);
    }

    private static void write(Node node, Writer writer, int indentation, boolean omitXmlDeclaration) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (indentation > 0) {
            transformerFactory.setAttribute("indent-number", indentation);
        }
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException canNotHappen) {
            throw new XmlException("Could not create transformer", canNotHappen);
        }
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", XmlUtils.propertyStringFor(indentation > 0));
        transformer.setOutputProperty("omit-xml-declaration", XmlUtils.propertyStringFor(omitXmlDeclaration));
        DOMSource source = new DOMSource(node);
        StreamResult xmlOutput = new StreamResult(writer);
        try {
            transformer.transform(source, xmlOutput);
        }
        catch (TransformerException e) {
            throw new XmlException("Could not transform node", e);
        }
    }

    private static String propertyStringFor(boolean b) {
        return b ? "yes" : "no";
    }

    public static Node read(InputStream inputStream) throws XmlException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element node = document.getDocumentElement();
            return node;
        }
        catch (ParserConfigurationException canNotHappen) {
            throw new XmlException("Could not create parser", canNotHappen);
        }
        catch (SAXException e) {
            throw new XmlException("XML parsing error", e);
        }
        catch (IOException e) {
            throw new XmlException("IO error while reading XML", e);
        }
    }

    public static Node createTextNode(String tagName, Object contents) {
        Document d = XmlUtils.getDefaultDocument();
        Element node = d.createElement(tagName);
        node.appendChild(d.createTextNode(String.valueOf(contents)));
        return node;
    }

    public static String getAttributeValue(Node node, String attributeName, String defaultValue) {
        NamedNodeMap attributes = node.getAttributes();
        Node attributeNode = attributes.getNamedItem(attributeName);
        if (attributeNode == null) {
            return defaultValue;
        }
        String value = attributeNode.getNodeValue();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String getRequiredAttributeValue(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        Node attributeNode = attributes.getNamedItem(attributeName);
        if (attributeNode == null) {
            throw new XmlException("No attribute with name \"" + attributeName + "\" found");
        }
        String value = attributeNode.getNodeValue();
        if (value == null) {
            throw new XmlException("Attribute with name \"" + attributeName + "\" has no value");
        }
        return value;
    }

    static void removeWhitespace(Node node) {
        NodeList childList = node.getChildNodes();
        ArrayList<Node> toRemove = new ArrayList<Node>();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (child.getNodeType() == 3) {
                String text = child.getTextContent();
                String trimmed = text.trim();
                if (trimmed.isEmpty()) {
                    toRemove.add(child);
                } else if (trimmed.length() < text.length()) {
                    child.setTextContent(trimmed);
                }
            }
            XmlUtils.removeWhitespace(child);
        }
        for (Node c : toRemove) {
            node.removeChild(c);
        }
    }

    public static Node getFirstChild(Node node, String childNodeName) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            String childName = child.getNodeName();
            if (!childName.equalsIgnoreCase(childNodeName)) continue;
            return child;
        }
        return null;
    }

    public static List<Node> getChildren(Node node, String childNodeName) {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            String childName = child.getNodeName();
            if (!childName.equalsIgnoreCase(childNodeName)) continue;
            children.add(child);
        }
        return children;
    }

    public static void verifyNode(Node node, String expected) {
        if (node == null) {
            throw new XmlException("Did not find <" + expected + "> node");
        }
        if (!node.getNodeName().equalsIgnoreCase(expected)) {
            throw new XmlException("Expected <" + expected + "> tag, but found <" + node.getNodeName() + ">");
        }
    }

    static <T> T resolveAttributeFromMap(Node node, String attributeName, Map<String, ? extends T> map) {
        String id = XmlUtils.getAttributeValue(node, attributeName, null);
        if (id == null) {
            throw new XmlException("No attribute \"" + attributeName + "\" found");
        }
        T result = map.get(id);
        if (result == null) {
            throw new XmlException("Could not resolve value with id \"" + id + "\"");
        }
        return result;
    }

    static int readInt(Node node) {
        if (node == null) {
            throw new XmlException("Tried to read int value from null node");
        }
        String value = node.getFirstChild().getNodeValue();
        if (value == null) {
            throw new XmlException("Tried to read int value from null value");
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new XmlException("Expected int value, found \"" + value + "\"", e);
        }
    }

    static double readDouble(Node node) {
        if (node == null) {
            throw new XmlException("Tried to read double value from null node");
        }
        String value = node.getFirstChild().getNodeValue();
        if (value == null) {
            throw new XmlException("Tried to read double value from null value");
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new XmlException("Expected double value, found \"" + value + "\"", e);
        }
    }

    static boolean readBoolean(Node node) {
        if (node == null) {
            throw new XmlException("Tried to read boolean value from null node");
        }
        String value = node.getFirstChild().getNodeValue();
        return Boolean.parseBoolean(value);
    }

    static <E extends Enum<E>> E readEnum(Node node, Class<E> enumClass) {
        if (node == null) {
            throw new XmlException("Tried to read " + enumClass.getSimpleName() + " value from null node");
        }
        String value = node.getFirstChild().getNodeValue();
        if (value == null) {
            throw new XmlException("Tried to read " + enumClass.getSimpleName() + " value from null value");
        }
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (IllegalArgumentException e) {
            throw new XmlException("No valid " + enumClass.getSimpleName() + ": \"" + value + "\"");
        }
    }

    public static int readIntChild(Node node, String childNodeName, int defaultValue) {
        if (node == null) {
            throw new XmlException("Tried to read int value from child of null node");
        }
        Node child = XmlUtils.getFirstChild(node, childNodeName);
        if (child == null) {
            return defaultValue;
        }
        return XmlUtils.readInt(child);
    }

    static double readDoubleChild(Node node, String childNodeName, double defaultValue) {
        if (node == null) {
            throw new XmlException("Tried to read double value from child of null node");
        }
        Node child = XmlUtils.getFirstChild(node, childNodeName);
        if (child == null) {
            return defaultValue;
        }
        return XmlUtils.readDouble(child);
    }

    public static boolean readBooleanChild(Node node, String childNodeName, boolean defaultValue) {
        if (node == null) {
            throw new XmlException("Tried to read boolean value from child of null node");
        }
        Node child = XmlUtils.getFirstChild(node, childNodeName);
        if (child == null) {
            return defaultValue;
        }
        return XmlUtils.readBoolean(child);
    }

    public static <E extends Enum<E>> E readEnumChild(Node node, Class<E> enumClass, String childNodeName) {
        if (node == null) {
            throw new XmlException("Tried to read enum value from child of null node");
        }
        Node child = XmlUtils.getFirstChild(node, childNodeName);
        return XmlUtils.readEnum(child, enumClass);
    }

    private XmlUtils() {
    }
}

