/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.iteration;

import de.javagl.common.iteration.CombiningIterator;
import de.javagl.common.iteration.FilteringIterator;
import de.javagl.common.iteration.TransformingIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class Iterators {
    public static <T> List<T> toList(Iterator<T> iterator) {
        Objects.requireNonNull(iterator, "The iterator is null");
        return Iterators.toCollection(iterator, new ArrayList());
    }

    public static <T> Set<T> toSet(Iterator<T> iterator) {
        Objects.requireNonNull(iterator, "The iterator is null");
        return Iterators.toCollection(iterator, new LinkedHashSet());
    }

    public static <T, C extends Collection<? super T>> C toCollection(Iterator<T> iterator, C collection) {
        Objects.requireNonNull(iterator, "The iterator is null");
        Objects.requireNonNull(iterator, "The collection is null");
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <T> Iterator<T> weakeningIterator(final Iterator<? extends T> delegate) {
        Objects.requireNonNull(delegate, "The delegate is null");
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public T next() {
                return delegate.next();
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
    }

    public static <T> Iterator<T> iteratorOverIterators(Iterator<? extends T> iterator0, Iterator<? extends T> iterator1) {
        Objects.requireNonNull(iterator0, "The iterator0 is null");
        Objects.requireNonNull(iterator1, "The iterator1 is null");
        ArrayList<Iterator<? extends T>> iterators = new ArrayList<Iterator<? extends T>>(2);
        iterators.add(iterator0);
        iterators.add(iterator1);
        return Iterators.iteratorOverIterators(iterators.iterator());
    }

    public static <S extends Iterator<? extends T>, T> Iterator<T> iteratorOverIterators(Iterator<S> iteratorsIterator) {
        Objects.requireNonNull(iteratorsIterator, "The iteratorsIterator is null");
        return new CombiningIterator(iteratorsIterator);
    }

    public static <S extends Iterator<? extends T>, T> Iterator<T> iteratorOverIterators(Iterable<S> iteratorsIterable) {
        Objects.requireNonNull(iteratorsIterable, "The iteratorsIterable is null");
        return new CombiningIterator(iteratorsIterable.iterator());
    }

    public static <S extends Iterable<? extends T>, T> Iterator<T> iteratorOverIterables(Iterator<S> iterablesIterator) {
        Objects.requireNonNull(iterablesIterator, "The iterablesIterator is null");
        TransformingIterator<Iterable, Iterator> iteratorIterator = new TransformingIterator<Iterable, Iterator>(iterablesIterator, iterable -> iterable.iterator());
        return new CombiningIterator(iteratorIterator);
    }

    public static <S extends Iterable<? extends T>, T> Iterator<T> iteratorOverIterables(Iterable<S> iterablesIterable) {
        Objects.requireNonNull(iterablesIterable, "The iterablesIterable is null");
        return Iterators.iteratorOverIterables(iterablesIterable.iterator());
    }

    public static <T> Iterator<T> iteratorOverIterables(Iterable<? extends T> iterable0, Iterable<? extends T> iterable1) {
        Objects.requireNonNull(iterable0, "The iterable0 is null");
        Objects.requireNonNull(iterable1, "The iterable1 is null");
        ArrayList<Iterable<? extends T>> iterables = new ArrayList<Iterable<? extends T>>(2);
        iterables.add(iterable0);
        iterables.add(iterable1);
        return Iterators.iteratorOverIterables(iterables.iterator());
    }

    public static <S, T> Iterator<T> transformingIterator(Iterator<? extends S> iterator, Function<S, ? extends T> function) {
        Objects.requireNonNull(iterator, "The iterator is null");
        Objects.requireNonNull(function, "The function is null");
        return new TransformingIterator<S, T>(iterator, function);
    }

    public static <T> Iterator<T> filteringIterator(Iterator<? extends T> iterator, Predicate<? super T> predicate) {
        Objects.requireNonNull(iterator, "The iterator is null");
        Objects.requireNonNull(predicate, "The predicate is null");
        return new FilteringIterator<T>(iterator, predicate);
    }

    private Iterators() {
    }
}

