/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.iteration;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

class FilteringIterator<T>
implements Iterator<T> {
    private final Iterator<? extends T> iterator;
    private final Predicate<? super T> predicate;
    private T next;
    private boolean hasNext;

    FilteringIterator(Iterator<? extends T> iterator, Predicate<? super T> predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
        this.prepareNext();
    }

    private void prepareNext() {
        this.hasNext = false;
        while (this.iterator.hasNext()) {
            this.next = this.iterator.next();
            if (!this.predicate.test(this.next)) continue;
            this.hasNext = true;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("No more elements");
        }
        T result = this.next;
        this.prepareNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("May not remove elements with this iterator");
    }
}

