/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.iteration;

import java.util.Iterator;
import java.util.NoSuchElementException;

class CombiningIterator<T>
implements Iterator<T> {
    private final Iterator<? extends Iterator<? extends T>> iteratorIterator;
    private Iterator<? extends T> currentIterator;
    private Iterator<? extends T> removalIterator;

    CombiningIterator(Iterator<? extends Iterator<? extends T>> iteratorIterator) {
        this.iteratorIterator = iteratorIterator;
        this.prepareNextIterator();
    }

    private void prepareNextIterator() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            this.currentIterator = null;
            while (this.iteratorIterator.hasNext()) {
                this.currentIterator = this.iteratorIterator.next();
                if (this.currentIterator.hasNext()) break;
                this.currentIterator = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null) {
            return false;
        }
        if (this.currentIterator.hasNext()) {
            return true;
        }
        throw new RuntimeException("Invalid iterator state");
    }

    @Override
    public T next() {
        if (this.currentIterator == null) {
            throw new NoSuchElementException("No more elements");
        }
        T result = this.currentIterator.next();
        this.removalIterator = this.currentIterator;
        this.prepareNextIterator();
        return result;
    }

    @Override
    public void remove() {
        if (this.removalIterator == null) {
            throw new IllegalStateException("No more elements");
        }
        this.removalIterator.remove();
        this.removalIterator = null;
    }
}

