/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.functional;

import java.util.function.DoubleUnaryOperator;

public class DoubleUnaryOperators {
    public static DoubleUnaryOperator interpolate(double min, double max) {
        double delta = max - min;
        return x -> min + x * delta;
    }

    public static DoubleUnaryOperator interpolate(final double minSource, double maxSource, final double minTarget, double maxTarget) {
        final double invDeltaSource = 1.0 / (maxSource - minSource);
        final double deltaTarget = maxTarget - minTarget;
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double value) {
                double alpha = (value - minSource) * invDeltaSource;
                return minTarget + alpha * deltaTarget;
            }
        };
    }

    public static DoubleUnaryOperator clamp(DoubleUnaryOperator function, double min, double max) {
        return x -> Math.max(min, Math.min(max, function.applyAsDouble(x)));
    }

    public static DoubleUnaryOperator affine(double factor, double addend) {
        return x -> factor * x + addend;
    }

    private DoubleUnaryOperators() {
    }
}

