/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.concurrent;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ParallelRangeExecutor {
    public static void execute(int parallelism, ExecutorService executorService, int globalMin, int globalMax, final RangeExecutor rangeExecutor) {
        if (parallelism <= 0) {
            throw new IllegalArgumentException("Parallelism must be positive, but is " + parallelism);
        }
        if (globalMin > globalMax) {
            throw new IllegalArgumentException("The global minimum may not be larger than the global maximum. Global minimum is " + globalMin + ", global maximum is " + globalMax);
        }
        int range = globalMax - globalMin;
        if (range == 0) {
            return;
        }
        int numTasks = Math.min(range, parallelism);
        int localRange = (range - 1) / numTasks + 1;
        int spare = localRange * numTasks - range;
        int currentIndex = globalMin;
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>(numTasks);
        for (int i = 0; i < numTasks; ++i) {
            final int taskIndex = i;
            final int min = currentIndex;
            final int max = min + localRange - (i < spare ? 1 : 0);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    rangeExecutor.execute(taskIndex, min, max);
                }
            };
            tasks.add(Executors.callable(runnable));
            currentIndex = max;
        }
        try {
            executorService.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private ParallelRangeExecutor() {
    }

    public static interface RangeExecutor {
        public void execute(int var1, int var2, int var3);
    }
}

