/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorServices {
    public static ExecutorService createFixedTimeoutRethrowingExecutorService(int poolSize, long keepAliveTime, TimeUnit timeUnit, final boolean rethrowCancellation) {
        ThreadPoolExecutor e = new ThreadPoolExecutor(poolSize, poolSize, keepAliveTime, timeUnit, new LinkedBlockingQueue()){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (t == null && r instanceof Future) {
                    try {
                        Future future = (Future)((Object)r);
                        if (future.isDone()) {
                            future.get();
                        }
                    }
                    catch (CancellationException ce) {
                        if (rethrowCancellation) {
                            t = ce;
                        }
                    }
                    catch (ExecutionException ee) {
                        t = ee.getCause();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (t != null) {
                    throw new RuntimeException(t);
                }
            }
        };
        e.allowCoreThreadTimeOut(true);
        return e;
    }

    public static ExecutorService createFixedTimeoutExecutorService(int poolSize, long keepAliveTime, TimeUnit timeUnit) {
        ThreadPoolExecutor e = new ThreadPoolExecutor(poolSize, poolSize, keepAliveTime, timeUnit, new LinkedBlockingQueue<Runnable>());
        e.allowCoreThreadTimeOut(true);
        return e;
    }

    private ExecutorServices() {
    }
}

