/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Maps {
    public static <K> void incrementCount(Map<K, Integer> map, K k) {
        map.put(k, Maps.getCount(map, k) + 1);
    }

    public static <K> Integer getCount(Map<K, Integer> map, K k) {
        Integer count = map.get(k);
        if (count == null) {
            count = 0;
            map.put(k, count);
        }
        return count;
    }

    static <K, E> List<E> getList(Map<K, List<E>> map, K k) {
        List<E> list = map.get(k);
        if (list == null) {
            list = new ArrayList();
            map.put(k, list);
        }
        return list;
    }

    public static <K, E> void addToList(Map<K, List<E>> map, K k, E e) {
        Maps.getList(map, k).add(e);
    }

    static <K, E> void removeFromList(Map<K, List<E>> map, K k, E e) {
        List<E> list = map.get(k);
        if (list != null) {
            list.remove(e);
            if (list.isEmpty()) {
                map.remove(k);
            }
        }
    }

    public static <K, V> void fillValues(Map<K, V> map, Iterable<? extends V> values) {
        Iterator<V> iterator = values.iterator();
        for (K k : map.keySet()) {
            if (!iterator.hasNext()) break;
            V value = iterator.next();
            map.put(k, value);
        }
    }

    static <K, V> Map<V, K> invert(Map<K, V> map) {
        LinkedHashMap<V, K> result = new LinkedHashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    @SafeVarargs
    public static <T> Map<Integer, T> fromElements(T ... elements) {
        return Maps.fromIterable(Arrays.asList(elements));
    }

    public static <T> Map<Integer, T> fromIterable(Iterable<? extends T> iterable) {
        LinkedHashMap<Integer, T> map = new LinkedHashMap<Integer, T>();
        int i = 0;
        for (T t : iterable) {
            map.put(i, t);
            ++i;
        }
        return map;
    }

    public static <K, V> Map<K, V> fromIterables(Iterable<? extends K> iterable0, Iterable<? extends V> iterable1) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        Iterator<K> i0 = iterable0.iterator();
        Iterator<V> i1 = iterable1.iterator();
        while (i0.hasNext() && i1.hasNext()) {
            K k = i0.next();
            V v = i1.next();
            map.put(k, v);
        }
        return map;
    }

    public static <K, V> Map<K, V> unmodifiableCopy(Map<? extends K, ? extends V> map) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    private Maps() {
    }
}

