/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.collections;

import java.util.Map;
import java.util.NavigableMap;

public class DoubleMaps {
    public static double getInterpolated(NavigableMap<Double, ? extends Number> map, double key) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Empty map");
        }
        Map.Entry<Double, ? extends Number> c = map.ceilingEntry(key);
        Map.Entry<Double, ? extends Number> f = map.floorEntry(key);
        if (c == null) {
            return f.getValue().doubleValue();
        }
        if (f == null) {
            return c.getValue().doubleValue();
        }
        if (c.equals(f)) {
            return c.getValue().doubleValue();
        }
        double deltaKeys = c.getKey() - f.getKey();
        double alpha = (key - f.getKey()) / deltaKeys;
        double deltaValues = c.getValue().doubleValue() - f.getValue().doubleValue();
        double result = f.getValue().doubleValue() + alpha * deltaValues;
        return result;
    }

    private DoubleMaps() {
    }
}

