/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.beans;

import de.javagl.common.beans.XmlEncoders;
import de.javagl.common.xml.XmlException;
import java.beans.ExceptionListener;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class XmlBeanUtil {
    public static void writeFullBeanXml(Object object, OutputStream outputStream) {
        XMLEncoder encoder = XmlEncoders.createVerbose(outputStream);
        encoder.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                throw new XmlException("Could not encode object", e);
            }
        });
        encoder.writeObject(object);
        encoder.flush();
        encoder.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createFullBeanXmlString(Object object) {
        ByteArrayOutputStream stream = null;
        try {
            stream = new ByteArrayOutputStream();
            XmlBeanUtil.writeFullBeanXml(object, stream);
            String string = stream.toString();
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new XmlException("Could not close the stream", e);
                }
            }
        }
    }

    private XmlBeanUtil() {
    }
}

