/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.beans;

import de.javagl.common.beans.Methods;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class PropertyChangeUtils {
    static boolean maintainsPropertyChangeListeners(Class<?> c) {
        Objects.requireNonNull(c, "The class may not be null");
        Method addMethod = Methods.getMethodOptional(c, "addPropertyChangeListener", PropertyChangeListener.class);
        if (addMethod == null || !PropertyChangeUtils.isPublicInstanceMethod(addMethod)) {
            return false;
        }
        Method removeMethod = Methods.getMethodOptional(c, "removePropertyChangeListener", PropertyChangeListener.class);
        return removeMethod != null && PropertyChangeUtils.isPublicInstanceMethod(removeMethod);
    }

    public static void tryAddPropertyChangeListenerUnchecked(Object target, PropertyChangeListener propertyChangeListener) {
        Objects.requireNonNull(target, "The target may not be null");
        Objects.requireNonNull(propertyChangeListener, "The propertyChangeListener may not be null");
        if (PropertyChangeUtils.maintainsPropertyChangeListeners(target.getClass())) {
            PropertyChangeUtils.addPropertyChangeListenerUnchecked(target, propertyChangeListener);
        }
    }

    private static void addPropertyChangeListenerUnchecked(Object target, PropertyChangeListener propertyChangeListener) {
        Class<?> c = target.getClass();
        if (!PropertyChangeUtils.maintainsPropertyChangeListeners(c)) {
            throw new IllegalArgumentException("Class " + c + " does not maintain PropertyChangeListeners");
        }
        Method addMethod = Methods.getMethodUnchecked(c, "addPropertyChangeListener", PropertyChangeListener.class);
        Methods.invokeUnchecked(addMethod, target, propertyChangeListener);
    }

    public static void tryRemovePropertyChangeListenerUnchecked(Object target, PropertyChangeListener propertyChangeListener) {
        Objects.requireNonNull(target, "The target may not be null");
        Objects.requireNonNull(propertyChangeListener, "The propertyChangeListener may not be null");
        if (PropertyChangeUtils.maintainsPropertyChangeListeners(target.getClass())) {
            PropertyChangeUtils.removePropertyChangeListenerUnchecked(target, propertyChangeListener);
        }
    }

    private static void removePropertyChangeListenerUnchecked(Object target, PropertyChangeListener propertyChangeListener) {
        Class<?> c = target.getClass();
        if (!PropertyChangeUtils.maintainsPropertyChangeListeners(c)) {
            throw new IllegalArgumentException("Class " + c + " does not maintain PropertyChangeListeners");
        }
        Method removeMethod = Methods.getMethodUnchecked(c, "removePropertyChangeListener", PropertyChangeListener.class);
        Methods.invokeUnchecked(removeMethod, target, propertyChangeListener);
    }

    static boolean maintainsNamedPropertyChangeListeners(Class<?> c) {
        Objects.requireNonNull(c, "The class may not be null");
        Method addMethod = Methods.getMethodOptional(c, "addPropertyChangeListener", String.class, PropertyChangeListener.class);
        if (addMethod == null || !PropertyChangeUtils.isPublicInstanceMethod(addMethod)) {
            return false;
        }
        Method removeMethod = Methods.getMethodOptional(c, "removePropertyChangeListener", String.class, PropertyChangeListener.class);
        return removeMethod != null && PropertyChangeUtils.isPublicInstanceMethod(removeMethod);
    }

    public static void tryAddNamedPropertyChangeListenerUnchecked(Object target, String propertyName, PropertyChangeListener propertyChangeListener) {
        Objects.requireNonNull(target, "The target may not be null");
        Objects.requireNonNull(propertyName, "The propertyName may not be null");
        Objects.requireNonNull(propertyChangeListener, "The propertyChangeListener may not be null");
        if (PropertyChangeUtils.maintainsNamedPropertyChangeListeners(target.getClass())) {
            PropertyChangeUtils.addNamedPropertyChangeListenerUnchecked(target, propertyName, propertyChangeListener);
        }
    }

    private static void addNamedPropertyChangeListenerUnchecked(Object target, String propertyName, PropertyChangeListener propertyChangeListener) {
        Class<?> c = target.getClass();
        if (!PropertyChangeUtils.maintainsNamedPropertyChangeListeners(c)) {
            throw new IllegalArgumentException("Class " + c + " does not maintain named PropertyChangeListeners");
        }
        Method addMethod = Methods.getMethodUnchecked(c, "addPropertyChangeListener", String.class, PropertyChangeListener.class);
        Methods.invokeUnchecked(addMethod, target, propertyName, propertyChangeListener);
    }

    public static void tryRemoveNamedPropertyChangeListenerUnchecked(Object target, String propertyName, PropertyChangeListener propertyChangeListener) {
        Objects.requireNonNull(target, "The target may not be null");
        Objects.requireNonNull(propertyName, "The propertyName may not be null");
        Objects.requireNonNull(propertyChangeListener, "The propertyChangeListener may not be null");
        if (PropertyChangeUtils.maintainsNamedPropertyChangeListeners(target.getClass())) {
            PropertyChangeUtils.removeNamedPropertyChangeListenerUnchecked(target, propertyName, propertyChangeListener);
        }
    }

    private static void removeNamedPropertyChangeListenerUnchecked(Object target, String propertyName, PropertyChangeListener propertyChangeListener) {
        Class<?> c = target.getClass();
        if (!PropertyChangeUtils.maintainsNamedPropertyChangeListeners(c)) {
            throw new IllegalArgumentException("Class " + c + " does not maintain named PropertyChangeListeners");
        }
        Method removeMethod = Methods.getMethodUnchecked(c, "removePropertyChangeListener", String.class, PropertyChangeListener.class);
        Methods.invokeUnchecked(removeMethod, target, propertyName, propertyChangeListener);
    }

    private static boolean isPublicInstanceMethod(Method method) {
        return Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers());
    }

    private PropertyChangeUtils() {
    }
}

