/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.beans;

import de.javagl.common.beans.BeanUtils;
import de.javagl.common.beans.PropertyChangeUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyChangeListeners {
    private static final Logger logger = Logger.getLogger(PropertyChangeListeners.class.getName());

    public static void addDeepLogger(Object object) {
        PropertyChangeListeners.addDeepLogger(object, Level.INFO);
    }

    public static void addDeepLogger(Object object, Level level) {
        PropertyChangeListeners.addDeepLogger(object, (? super String m) -> logger.log(level, (String)m));
    }

    public static void addDeepConsoleLogger(Object object) {
        PropertyChangeListeners.addDeepLogger(object, (? super String m) -> System.out.println((String)m));
    }

    public static void addDeepLogger(Object object, final Consumer<? super String> consumer) {
        Objects.requireNonNull(consumer, "The consumer may not be null");
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Object source = event.getSource();
                String propertyName = event.getPropertyName();
                Object oldValue = event.getOldValue();
                String oldValueString = PropertyChangeListeners.createLoggingString(oldValue);
                Object newValue = event.getNewValue();
                String newValueString = PropertyChangeListeners.createLoggingString(newValue);
                String message = "Property " + propertyName + " changed from " + oldValueString + " to " + newValueString + " in " + source;
                consumer.accept(message);
            }
        };
        PropertyChangeListeners.addDeepPropertyChangeListener(object, propertyChangeListener);
    }

    private static String createLoggingString(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> objectClass = object.getClass();
        if (!objectClass.isArray()) {
            return String.valueOf(object);
        }
        StringBuilder sb = new StringBuilder();
        int length = Array.getLength(object);
        sb.append("[");
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            Object element = Array.get(object, i);
            sb.append(PropertyChangeListeners.createLoggingString(element));
        }
        sb.append("]");
        return sb.toString();
    }

    public static ObservedObject addDeepPropertyChangeListener(Object object, final PropertyChangeListener propertyChangeListener) {
        Objects.requireNonNull(object, "The object may not be null");
        Objects.requireNonNull(propertyChangeListener, "The propertyChangeListener may not be null");
        PropertyChangeListener forwardingPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                PropertyChangeListeners.removeRecursive(oldValue, propertyChangeListener);
                PropertyChangeListeners.removeRecursive(oldValue, this);
                PropertyChangeListeners.addRecursive(newValue, propertyChangeListener);
                PropertyChangeListeners.addRecursive(newValue, this);
            }
        };
        PropertyChangeListeners.addRecursive(object, propertyChangeListener);
        PropertyChangeListeners.addRecursive(object, forwardingPropertyChangeListener);
        ObservedObject observedObject = new ObservedObject(object, propertyChangeListener, forwardingPropertyChangeListener);
        return observedObject;
    }

    public static void removeDeepPropertyChangeListener(Object object, PropertyChangeListener propertyChangeListener) {
        Objects.requireNonNull(object, "The object may not be null");
        Objects.requireNonNull(propertyChangeListener, "The propertyChangeListener may not be null");
        PropertyChangeListeners.removeRecursive(object, propertyChangeListener);
    }

    private static void addRecursive(Object object, PropertyChangeListener propertyChangeListener) {
        PropertyChangeListeners.addRecursive(object, propertyChangeListener, new LinkedHashSet<Object>());
    }

    private static void addRecursive(Object object, PropertyChangeListener propertyChangeListener, Set<Object> processedObjects) {
        Objects.requireNonNull(processedObjects, "The processedObjects may not be null");
        if (object == null) {
            return;
        }
        if (processedObjects.contains(object)) {
            return;
        }
        processedObjects.add(object);
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(object, i);
                PropertyChangeListeners.addRecursive(element, propertyChangeListener, processedObjects);
            }
            return;
        }
        PropertyChangeUtils.tryAddPropertyChangeListenerUnchecked(object, propertyChangeListener);
        List<String> propertyNames = BeanUtils.getMutablePropertyNamesOptional(object.getClass());
        for (String propertyName : propertyNames) {
            Object value = BeanUtils.invokeReadMethodOptional(object, propertyName);
            PropertyChangeListeners.addRecursive(value, propertyChangeListener, processedObjects);
        }
    }

    private static void removeRecursive(Object object, PropertyChangeListener propertyChangeListener) {
        PropertyChangeListeners.removeRecursive(object, propertyChangeListener, new LinkedHashSet<Object>());
    }

    private static void removeRecursive(Object object, PropertyChangeListener propertyChangeListener, Set<Object> processedObjects) {
        Objects.requireNonNull(processedObjects, "The processedObjects may not be null");
        if (object == null) {
            return;
        }
        if (processedObjects.contains(object)) {
            return;
        }
        processedObjects.add(object);
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(object, i);
                PropertyChangeListeners.removeRecursive(element, propertyChangeListener, processedObjects);
            }
            return;
        }
        PropertyChangeUtils.tryRemovePropertyChangeListenerUnchecked(object, propertyChangeListener);
        List<String> propertyNames = BeanUtils.getMutablePropertyNamesOptional(object.getClass());
        for (String propertyName : propertyNames) {
            Object value = BeanUtils.invokeReadMethodOptional(object, propertyName);
            PropertyChangeListeners.removeRecursive(value, propertyChangeListener, processedObjects);
        }
    }

    private PropertyChangeListeners() {
    }

    public static class ObservedObject {
        private final Object object;
        private final PropertyChangeListener propertyChangeListener;
        private final PropertyChangeListener forwardingPropertyChangeListener;

        ObservedObject(Object object, PropertyChangeListener propertyChangeListener, PropertyChangeListener forwardingPropertyChangeListener) {
            this.object = object;
            this.propertyChangeListener = propertyChangeListener;
            this.forwardingPropertyChangeListener = forwardingPropertyChangeListener;
        }

        public void detach() {
            PropertyChangeListeners.removeDeepPropertyChangeListener(this.object, this.propertyChangeListener);
            PropertyChangeListeners.removeDeepPropertyChangeListener(this.object, this.forwardingPropertyChangeListener);
        }
    }
}

