/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.beans;

import java.beans.BeanInfo;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.lang.reflect.Method;

class FullPersistenceDelegate
extends PersistenceDelegate {
    FullPersistenceDelegate() {
    }

    @Override
    protected Expression instantiate(Object oldInstance, Encoder encoder) {
        return new Expression(oldInstance, oldInstance.getClass(), "new", null);
    }

    @Override
    protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder encoder) {
        super.initialize(type, oldInstance, newInstance, encoder);
        if (oldInstance.getClass() == type) {
            this.initializeProperties(type, oldInstance, encoder);
        }
    }

    private void initializeProperties(Class<?> type, Object oldInstance, Encoder encoder) {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(type);
        }
        catch (IntrospectionException ie) {
            encoder.getExceptionListener().exceptionThrown(ie);
            return;
        }
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            try {
                this.initializeProperty(type, pds[i], oldInstance, encoder);
                continue;
            }
            catch (Exception e) {
                encoder.getExceptionListener().exceptionThrown(e);
            }
        }
    }

    private void initializeProperty(Class<?> type, PropertyDescriptor pd, Object oldInstance, Encoder encoder) throws Exception {
        Method getter = pd.getReadMethod();
        Method setter = pd.getWriteMethod();
        if (getter != null && setter != null) {
            Expression oldGetExpression = new Expression(oldInstance, getter.getName(), new Object[0]);
            Object oldValue = oldGetExpression.getValue();
            Statement setStatement = new Statement(oldInstance, setter.getName(), new Object[]{oldValue});
            encoder.writeStatement(setStatement);
        }
    }
}

