/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.category;

import de.javagl.category.Category;
import de.javagl.category.CategoryEvent;
import de.javagl.category.CategoryListener;
import de.javagl.category.MutableCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

final class DefaultCategory<T>
implements MutableCategory<T> {
    private final String name;
    private final List<MutableCategory<T>> children;
    private final List<T> elements;
    private final List<CategoryListener<T>> categoryListeners;
    private final CategoryListener<T> forwardingListener = new CategoryListener<T>(){

        @Override
        public void elementsAdded(CategoryEvent<T> event) {
            for (CategoryListener listener : DefaultCategory.this.categoryListeners) {
                listener.elementsAdded(event);
            }
        }

        @Override
        public void elementsRemoved(CategoryEvent<T> event) {
            for (CategoryListener listener : DefaultCategory.this.categoryListeners) {
                listener.elementsRemoved(event);
            }
        }

        @Override
        public void childAdded(CategoryEvent<T> event) {
            for (CategoryListener listener : DefaultCategory.this.categoryListeners) {
                listener.childAdded(event);
            }
        }

        @Override
        public void childRemoved(CategoryEvent<T> event) {
            for (CategoryListener listener : DefaultCategory.this.categoryListeners) {
                listener.childRemoved(event);
            }
        }
    };

    DefaultCategory(String name) {
        this.name = Objects.requireNonNull(name, "The name may not be null");
        this.children = new ArrayList<MutableCategory<T>>();
        this.categoryListeners = new CopyOnWriteArrayList<CategoryListener<T>>();
        this.elements = new ArrayList<T>();
    }

    void addChild(MutableCategory<T> child) {
        Objects.requireNonNull(child, "The child may not be null");
        this.children.add(child);
        child.addCategoryListener(this.forwardingListener);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MutableCategory<T> addChild(String name) {
        Objects.requireNonNull(name, "The name may not be null");
        Category present = this.getChild(name);
        if (present != null) {
            return present;
        }
        DefaultCategory<T> child = new DefaultCategory<T>(name);
        this.addChild(child);
        this.fireChildAdded(child);
        return child;
    }

    @Override
    public MutableCategory<T> removeChild(String name) {
        Category removedChild = this.getChild(name);
        if (removedChild != null) {
            this.children.remove(removedChild);
            removedChild.removeCategoryListener(this.forwardingListener);
            this.fireChildRemoved(removedChild);
        }
        return removedChild;
    }

    @Override
    public void removeAllChildren() {
        List<MutableCategory<T>> removedChildren = this.getChildren();
        for (MutableCategory<T> child : removedChildren) {
            this.removeChild(child.getName());
        }
    }

    @Override
    public MutableCategory<T> getChild(String name) {
        for (MutableCategory<T> child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public List<MutableCategory<T>> getChildren() {
        return Collections.unmodifiableList(new ArrayList<MutableCategory<T>>(this.children));
    }

    @Override
    public boolean addElements(Iterable<? extends T> elements) {
        boolean changed = false;
        if (elements != null) {
            for (T element : elements) {
                changed |= this.elements.add(element);
            }
            if (changed) {
                this.fireElementsAdded(elements);
            }
        }
        return changed;
    }

    @Override
    public boolean removeElements(Iterable<? extends T> elements) {
        boolean changed = false;
        if (elements != null) {
            for (T element : elements) {
                changed |= this.elements.remove(element);
            }
            if (changed) {
                this.fireElementsRemoved(elements);
            }
        }
        return changed;
    }

    @Override
    public void removeAllElements() {
        this.removeElements(this.getElements());
    }

    @Override
    public List<T> getElements() {
        return Collections.unmodifiableList(new ArrayList<T>(this.elements));
    }

    private void fireChildAdded(Category<T> child) {
        if (!this.categoryListeners.isEmpty()) {
            CategoryEvent<T> categoryEvent = new CategoryEvent<T>(this, null, child);
            for (CategoryListener<T> listener : this.categoryListeners) {
                listener.childAdded(categoryEvent);
            }
        }
    }

    private void fireChildRemoved(Category<T> child) {
        if (!this.categoryListeners.isEmpty()) {
            CategoryEvent<T> categoryEvent = new CategoryEvent<T>(this, null, child);
            for (CategoryListener<T> listener : this.categoryListeners) {
                listener.childRemoved(categoryEvent);
            }
        }
    }

    private void fireElementsAdded(Iterable<? extends T> elements) {
        if (!this.categoryListeners.isEmpty()) {
            CategoryEvent<? extends T> categoryEvent = new CategoryEvent<T>(this, elements, null);
            for (CategoryListener<? extends T> categoryListener : this.categoryListeners) {
                categoryListener.elementsAdded(categoryEvent);
            }
        }
    }

    private void fireElementsRemoved(Iterable<? extends T> elements) {
        if (!this.categoryListeners.isEmpty()) {
            CategoryEvent<? extends T> categoryEvent = new CategoryEvent<T>(this, elements, null);
            for (CategoryListener<? extends T> categoryListener : this.categoryListeners) {
                categoryListener.elementsRemoved(categoryEvent);
            }
        }
    }

    @Override
    public void addCategoryListener(CategoryListener<T> listener) {
        this.categoryListeners.add(listener);
    }

    @Override
    public void removeCategoryListener(CategoryListener<T> listener) {
        this.categoryListeners.remove(listener);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.children, this.elements);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Category)) {
            return false;
        }
        Category other = (Category)object;
        if (!Objects.equals(this.name, other.getName())) {
            return false;
        }
        if (!Objects.equals(this.children, other.getChildren())) {
            return false;
        }
        return Objects.equals(this.elements, other.getElements());
    }
}

