/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.category;

import de.javagl.category.Category;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.Set;

public final class CategoryEvent<T>
extends EventObject {
    private final Category<T> category;
    private final Set<T> elements;
    private final Category<T> child;

    CategoryEvent(Category<T> category, Iterable<? extends T> elements, Category<T> child) {
        super(category);
        this.category = category;
        if (elements == null) {
            this.elements = Collections.emptySet();
        } else {
            LinkedHashSet<T> e = new LinkedHashSet<T>();
            for (T element : elements) {
                e.add(element);
            }
            this.elements = Collections.unmodifiableSet(e);
        }
        this.child = child;
    }

    public Category<T> getCategory() {
        return this.category;
    }

    public Set<T> getElements() {
        return this.elements;
    }

    public Category<T> getChild() {
        return this.child;
    }

    @Override
    public String toString() {
        return "CategoryEvent[category=" + this.category + ",elements=" + this.elements + ",child=" + this.child + "]";
    }
}

