/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.category;

import de.javagl.category.Categories;
import de.javagl.category.Category;
import de.javagl.category.DefaultCategory;
import de.javagl.category.MutableCategory;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class CategoriesBuilder<T> {
    private MutableCategory<T> category;

    CategoriesBuilder(String name) {
        this.category = new DefaultCategory(name);
    }

    private CategoriesBuilder(MutableCategory<T> category) {
        this.category = Objects.requireNonNull(category, "The category may not be null");
    }

    public CategoriesBuilder<T> add(T element) {
        this.category.addElements(Arrays.asList(element));
        return this;
    }

    public CategoriesBuilder<T> addAll(Iterable<? extends T> elements) {
        if (elements != null) {
            this.category.addElements(elements);
        }
        return this;
    }

    public CategoriesBuilder<T> get(String name) {
        Objects.requireNonNull(name, "The name may not be null");
        MutableCategory<T> childCategory = this.category.getChild(name);
        if (childCategory == null) {
            childCategory = this.category.addChild(name);
        }
        CategoriesBuilder<T> child = new CategoriesBuilder<T>(childCategory);
        return child;
    }

    private Set<T> getAllElements() {
        return Categories.getAllElements(this.category);
    }

    public CategoriesBuilder<T> mergeRecursively(Category<? extends T> other) {
        Categories.mergeRecursively(this.category, other);
        return this;
    }

    public CategoriesBuilder<T> addIfUncategorized(String name, Iterable<? extends T> candidates) {
        Objects.requireNonNull(name, "The name may not be null");
        LinkedHashSet<T> available = new LinkedHashSet<T>();
        for (T candidate : candidates) {
            available.add(candidate);
        }
        available.removeAll(this.getAllElements());
        for (Object element : available) {
            this.get(name).add(element);
        }
        return this;
    }

    public MutableCategory<T> get() {
        return this.category;
    }
}

